/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.page;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.page.RConsoleEditor;
import org.eclipse.statet.internal.r.console.ui.page.RInputConfigurator;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.ui.RConsole;
import org.eclipse.statet.r.console.ui.tools.ChangeWorkingDirectoryWizard;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.ui.RUIHelp;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.pkgmanager.OpenRPkgManagerHandler;
import org.eclipse.statet.r.ui.pkgmanager.StartAction;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

public class RConsolePage
extends NIConsolePage {
    private IContextProvider helpContextProvider;

    public RConsolePage(RConsole console, IConsoleView view) {
        super((NIConsole)console, view);
    }

    public RConsole getConsole() {
        return (RConsole)super.getConsole();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected RInputConfigurator createInputEditorConfigurator() {
        return new RInputConfigurator(this, (RSourceEditor)this.getInputEditor());
    }

    protected RConsoleEditor createInputEditor() {
        return new RConsoleEditor(this);
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
        super.initActions(serviceLocator, handlers);
        IContextService contextService = (IContextService)serviceLocator.getService(IContextService.class);
        contextService.activateContext("org.eclipse.statet.r.actionSets.RSessionTools");
        this.helpContextProvider = RUIHelp.createEnrichedRHelpContextProvider((ISourceViewer)this.getInputEditor().getViewer(), (String)"org.eclipse.statet.r.ui.r_console");
        this.getInputEditor().getViewer().getTextWidget().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(RConsolePage.this.helpContextProvider.getContext(null));
            }
        });
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.appendToGroup("nico.control", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.PauseTool", null, null, null, null, null, null, null, 32, null, false)));
        if (this.getConsole().getProcess().isProvidingFeatureSet("org.eclipse.statet.nico/remote")) {
            menuManager.appendToGroup("nico.control", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.DisconnectTool", null, null, null, null, null, null, null, 8, null, false)));
            menuManager.appendToGroup("nico.control", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.ReconnectTool", null, null, null, null, null, null, null, 8, null, false)));
        }
        menuManager.insertBefore("additions", (IContributionItem)new Separator("workspace"));
        menuManager.appendToGroup("workspace", (IAction)new ChangeWorkingDirectoryWizard.ChangeAction((ToolProvider)this));
        menuManager.insertBefore("additions", (IContributionItem)new Separator("view"));
        RProcess process = this.getConsole().getProcess();
        REnv rEnv = process.getREnv();
        if (process.isProvidingFeatureSet("org.eclipse.statet.r.data") && rEnv != null) {
            menuManager.appendToGroup("nico.control", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.OpenRPkgManager", null, null, null, null, "Open Package Manager", "P", null, 8, null, false)));
            MenuManager rEnvMenu = new MenuManager("R &Environment");
            menuManager.appendToGroup("nico.control", (IContributionItem)rEnvMenu);
            rEnvMenu.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.OpenRPkgManager", null, null, null, null, "Open Package Manager", "P", null, 8, null, false)));
            if (RPkgUtils.DEBUG) {
                rEnvMenu.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "NO_COMMAND", null, null, null, null, "Open Package Manager - Clean", null, null, 8, null, false), (IHandler2)new OpenRPkgManagerHandler(){

                    protected int getRequestFlags() {
                        return 0x200000;
                    }
                }));
                rEnvMenu.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "NO_COMMAND", null, null, null, null, "Open Package Manager - Install 'zic'", null, null, 8, null, false), (IHandler2)new OpenRPkgManagerHandler(){

                    protected StartAction getStartAction() {
                        return new StartAction(2, (List)ImCollections.newList((Object)"zic"));
                    }
                }));
            }
            rEnvMenu.add((IContributionItem)new Separator());
            rEnvMenu.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.UpdateREnvIndex", null, null, null, null, "Update &index (changes)", null, null, 8, null, false)));
            rEnvMenu.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.ResetREnvIndex", null, null, null, null, "Reset inde&x (completely)", null, null, 8, null, false)));
        }
    }

    protected void fillOutputContextMenu(IMenuManager menuManager) {
        IPageSite site = this.getSite();
        super.fillOutputContextMenu(menuManager);
        menuManager.appendToGroup("view", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.nico.commands.AdjustOutputWidth", null, null, null, null, Messages.AdjustWidth_label, Messages.AdjustWidth_mnemonic, null, 8, null, false)));
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == IContextProvider.class) {
            return (T)this.helpContextProvider;
        }
        if (adapterType == REnv.class) {
            return (T)this.getTool().getAdapter(REnv.class);
        }
        return (T)super.getAdapter(adapterType);
    }

    protected void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        RCodeStyleSettings codeStyle;
        super.handleSettingsChanged(groupIds, options);
        if (groupIds.contains("r/r.codestyle/indent") && UIAccess.isOkToUse((Viewer)this.getOutputViewer()) && (codeStyle = this.getConsole().getRCodeStyle()).isDirty()) {
            this.getOutputViewer().setTabWidth(codeStyle.getTabSize());
        }
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
    }
}

