/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.persistence;

import java.util.Map;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorPersistor {
    public static final String STYLE_PERSISTENCE_PREFIX = "color";
    public static final Color DEFAULT_COLOR = Display.getDefault().getSystemColor(1);

    public static void saveColor(String prefix, Map<String, String> properties, Color color) {
        prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX;
        if (color == null) {
            return;
        }
        properties.put(prefix, ColorPersistor.asString(color));
    }

    public static Color loadColor(String prefix, Map<String, String> properties) {
        String colorAsString = properties.get(prefix = String.valueOf(prefix) + "." + STYLE_PERSISTENCE_PREFIX);
        if (colorAsString == null) {
            return null;
        }
        return ColorPersistor.asColor(colorAsString);
    }

    public static String asString(Color color) {
        return StringConverter.asString((RGB)color.getRGB());
    }

    public static Color asColor(String colorAsString) {
        try {
            return new Color(StringConverter.asRGB((String)colorAsString));
        }
        catch (DataFormatException e) {
            return DEFAULT_COLOR;
        }
    }
}

