/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.ExportedRClass;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.internal.r.core.builder.ExportedRMethod;
import org.eclipse.statet.internal.r.core.builder.RPkgData;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangClass;
import org.eclipse.statet.r.core.rmodel.RLangElement;
import org.eclipse.statet.r.core.rmodel.RLangMethod;
import org.eclipse.statet.r.core.rmodel.RSourceFrame;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;

@NonNullByDefault
public class RModelIndexOrder {
    protected final RProjectNature rProject;
    protected final String projectName;
    protected @Nullable RPkgData pkgData;
    protected final List<Result> updated = new ArrayList<Result>();
    protected final List<String> removed = new ArrayList<String>();
    protected final List<String> modelTypeIds;
    protected final boolean isFullBuild;

    public RModelIndexOrder(RProject rProject, List<String> modelTypeIds, boolean isFullBuild) {
        this.rProject = (RProjectNature)rProject;
        this.projectName = rProject.getProject().getName();
        this.modelTypeIds = modelTypeIds;
        this.isFullBuild = isFullBuild;
    }

    protected @Nullable Result createResult(RSourceUnit sourceUnit, @Nullable RSourceUnitModelInfo model) {
        if (model == null) {
            return null;
        }
        RSourceFrame topFrame = model.getTopFrame();
        List children = topFrame.getModelChildren(null);
        ArrayList<RLangElement> exports = new ArrayList<RLangElement>(children.size());
        RUnitElement root = new RUnitElement(sourceUnit, exports);
        for (RLangElement element : children) {
            int n = element.getElementType();
            switch (n & 0xF00) {
                case 1280: {
                    exports.add(new ExportedRMethod((RLangElement<?>)root, (RLangMethod)element));
                    break;
                }
                case 1024: {
                    exports.add(new ExportedRClass((RLangElement<?>)root, (RLangClass)element));
                    break;
                }
                case 1536: {
                    exports.add(new ExportedRElement(root, element));
                    break;
                }
            }
        }
        HashSet<String> names = new HashSet<String>();
        names.addAll(model.getTopFrame().getAllAccessNames());
        Map<String, ? extends RFrame> frames = model.getReferencedFrames();
        for (RFrame rFrame : frames.values()) {
            names.addAll(((RSourceFrame)rFrame).getAllAccessNames());
        }
        return new Result(root, names);
    }

    protected void addRemovedUnit(String unitId) {
        if (!this.isFullBuild) {
            this.removed.add(unitId);
        }
    }

    protected static class Result {
        public final String unitId;
        public final RUnitElement exportedElement;
        public final Set<String> defaultNames;

        public Result(RUnitElement root, Set<String> defaultNames) {
            this.unitId = root.getId();
            this.exportedElement = root;
            this.defaultNames = defaultNames;
        }
    }
}

