/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RInteger32Store;
import org.eclipse.statet.rj.data.impl.SimpleRList;

@NonNullByDefault
public class RArrayImpl<TData extends RStore<?>>
extends AbstractRObject
implements RArray<TData>,
ExternalizableRObject {
    private long length;
    private TData data;
    private String className1;
    private RInteger32Store dimAttribute;
    private @Nullable SimpleRList<RStore<?>> dimnamesAttribute;

    public RArrayImpl(TData data, String className1, int[] dim) {
        if (data == null || className1 == null || dim == null) {
            throw new NullPointerException();
        }
        this.length = RDataUtils.computeLengthFromDim(dim);
        if (data.getLength() >= 0L && data.getLength() != this.length) {
            throw new IllegalArgumentException("dim");
        }
        this.data = data;
        this.className1 = className1;
        this.dimAttribute = new RInteger32Store(dim);
    }

    public RArrayImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        if ((options & 0x10) != 0) {
            this.className1 = io.readString();
        }
        this.length = io.readVULong((byte)(options & 7));
        int[] dim = io.readIntArray();
        this.dimAttribute = new RInteger32Store(dim);
        if ((options & 0x40) != 0) {
            RCharacter32Store names0 = new RCharacter32Store(io, dim.length);
            RStore[] names1 = new RStore[dim.length];
            int i = 0;
            while (i < dim.length) {
                names1[i] = factory.readNames(io, dim[i]);
                ++i;
            }
            this.dimnamesAttribute = new SimpleRList<RStore>(names1, names0);
        }
        this.data = factory.readStore(io, this.length);
        if ((options & 0x10) == 0) {
            String string = this.className1 = dim.length == 2 ? "matrix" : "array";
        }
        if ((options & 8) != 0) {
            this.setAttributes(factory.readAttributeList(io));
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        RList attributes;
        int n = this.dimAttribute.length();
        int options = io.getVULongGrade(this.length);
        if (!this.className1.equals(n == 2 ? "matrix" : "array")) {
            options |= 0x10;
        }
        if ((io.flags & 1) == 0 && this.dimnamesAttribute != null) {
            options |= 0x40;
        }
        RList rList = attributes = (io.flags & 2) != 0 ? this.getAttributes() : null;
        if (attributes != null) {
            options |= 8;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), this.length);
        io.writeInt(n);
        this.dimAttribute.writeExternal(io);
        if ((options & 0x40) != 0) {
            ((ExternalizableRStore)((Object)this.dimnamesAttribute.getNames())).writeExternal(io);
            int i = 0;
            while (i < n) {
                factory.writeNames(this.dimnamesAttribute.get(i), io);
                ++i;
            }
        }
        factory.writeStore((RStore<?>)this.data, io);
        if ((options & 8) != 0) {
            factory.writeAttributeList(attributes, io);
        }
    }

    @Override
    public final byte getRObjectType() {
        return 3;
    }

    @Override
    public String getRClassName() {
        return this.className1;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public RIntegerStore getDim() {
        return this.dimAttribute;
    }

    @Override
    public @Nullable RCharacterStore getDimNames() {
        if (this.dimnamesAttribute != null) {
            return this.dimnamesAttribute.getNames();
        }
        return null;
    }

    @Override
    public @Nullable RStore<?> getNames(int dim) {
        if (this.dimnamesAttribute != null) {
            return this.dimnamesAttribute.get(dim);
        }
        return null;
    }

    @Override
    public TData getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=RArray, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.getLength());
        sb.append("\n\tdim=");
        this.dimAttribute.appendTo(sb);
        sb.append("\n\tdata: ");
        sb.append(this.data.toString());
        return sb.toString();
    }
}

