/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.status;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class StringBuilderWriter
extends Writer {
    private final StringBuilder sb;

    public StringBuilderWriter(StringBuilder sb) {
        this.sb = sb;
    }

    public StringBuilderWriter() {
        this(new StringBuilder());
    }

    @Override
    public void write(int c) throws IOException {
        this.sb.append(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.sb.append(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.sb.append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.sb.append(str.substring(off, off + len));
    }

    @Override
    public Writer append(@Nullable CharSequence csq) throws IOException {
        this.sb.append(csq);
        return this;
    }

    @Override
    public Writer append(@Nullable CharSequence csq, int start, int end) throws IOException {
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.sb.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.sb.toString();
    }
}

