/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.statet.jcommons.collections.ByteList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ByteArrayList
implements ByteList {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private byte[] array;
    private int size;

    public ByteArrayList() {
        this.array = EMPTY_ARRAY;
    }

    public ByteArrayList(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int indexOf(byte element) {
        byte[] array = this.array;
        int size = this.size;
        int i = 0;
        while (i < size) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte element) {
        byte[] array = this.array;
        int i = this.size - 1;
        while (i >= 0) {
            if (array[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public boolean contains(byte element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public byte getAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    protected final void ensureCapacity(int min) {
        if (min > this.array.length) {
            int newCapacity;
            if (this.array == EMPTY_ARRAY) {
                min = 8;
            }
            if ((newCapacity = Math.max(this.array.length + (this.array.length >> 1), min)) < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            byte[] newArray = new byte[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    @Override
    public boolean add(byte element) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = element;
        return true;
    }

    @Override
    public void addAt(int index, byte element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        this.ensureCapacity(this.size + 1);
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = element;
        ++this.size;
    }

    @Override
    public boolean add(byte[] element, int start, int end) {
        int l = end - start;
        this.ensureCapacity(this.size + l);
        System.arraycopy(element, start, this.array, this.size, l);
        this.size += l;
        return true;
    }

    @Override
    public byte setAt(int index, byte element) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        byte oldElement = this.array[index];
        this.array[index] = element;
        return oldElement;
    }

    private void doRemoveElementBefore(int index) {
        if (index != this.size) {
            System.arraycopy(this.array, index, this.array, index - 1, this.size - index);
        }
    }

    @Override
    public boolean remove(byte element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.doRemoveElementBefore(index + 1);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int removeAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        byte oldElement = this.array[index];
        this.doRemoveElementBefore(index + 1);
        --this.size;
        return oldElement;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public byte[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public String getString(Charset charset) {
        return new String(this.array, 0, this.size, charset);
    }
}

