/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.emf.ui;

import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ListViewerObservableValueDecorator
extends DecoratingObservableValue
implements IViewerObservableValue,
Listener {
    private final List<Object> input;
    private AbstractListViewer viewer;

    public ListViewerObservableValueDecorator(IObservableValue decorated, AbstractListViewer viewer, List<Object> input) {
        super(decorated, true);
        this.viewer = viewer;
        this.input = input;
        viewer.getControl().addListener(12, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.type == 12) {
            this.dispose();
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Object getValue() {
        return this.checkValue(super.getValue());
    }

    public void setValue(Object value) {
        if (value == null) {
            value = this.input.get(0);
        } else if (value instanceof EObject) {
            this.checkInput((EObject)value);
        }
        super.setValue(value);
    }

    private void checkInput(EObject value) {
        int i = 1;
        while (i < this.input.size()) {
            if (this.input.get(i) == value) {
                return;
            }
            ++i;
        }
        i = 1;
        while (i < this.input.size()) {
            Object item = this.input.get(i);
            if (item instanceof EObject && ((EObject)item).eClass() == value.eClass()) {
                this.input.set(i, value);
                this.viewer.setInput(this.input);
                return;
            }
            ++i;
        }
    }

    private EObject checkValue(Object value) {
        return value instanceof EObject ? (EObject)value : null;
    }

    protected void handleValueChange(ValueChangeEvent event) {
        ValueDiff diff = Diffs.createValueDiff((Object)this.checkValue(event.diff.getOldValue()), (Object)this.checkValue(event.diff.getNewValue()));
        this.fireValueChange(diff);
    }

    public synchronized void dispose() {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.removeListener(12, (Listener)this);
            }
            this.viewer = null;
        }
        super.dispose();
    }
}

