/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.AbstractToolScopeHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public class PauseHandler
extends AbstractToolScopeHandler<ToolProcess>
implements IElementUpdater,
IDebugEventSetListener {
    private boolean isChecked;

    public PauseHandler(IWorkbenchWindow scope, @Nullable String commandId) {
        super(scope, commandId);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public void dispose() {
        DebugPlugin debugManager = DebugPlugin.getDefault();
        if (debugManager != null) {
            debugManager.removeDebugEventListener((IDebugEventSetListener)this);
        }
        super.dispose();
    }

    private boolean setChecked(boolean isChecked) {
        if (isChecked != this.isChecked) {
            this.isChecked = isChecked;
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateState(@Nullable ToolProcess tool) {
        boolean refresh = false;
        refresh |= this.setChecked(tool != null && tool.getQueue().isRequested((byte)5));
        return refresh |= super.updateState(tool);
    }

    protected void updateChecked(boolean isChecked) {
        if (this.setChecked(isChecked)) {
            this.refreshCommandElements();
        }
    }

    private void updateChecked(ToolProcess tool, boolean isChecked) {
        UIAccess.getDisplay().asyncExec(() -> {
            if (this.getCurrentTool(null) != tool) {
                return;
            }
            this.updateChecked(isChecked);
        });
    }

    public void handleDebugEvents(@NonNull DebugEvent[] events) {
        ToolProcess tool = (ToolProcess)this.getCurrentTool(null);
        if (tool == null) {
            return;
        }
        Boolean paused = null;
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() == tool.getQueue()) {
                Queue.StateDelta delta;
                if (Queue.isStateRequest((DebugEvent)event)) {
                    delta = (Queue.StateDelta)event.getData();
                    paused = delta.newState == 5 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                } else if (Queue.isStateChange((DebugEvent)event)) {
                    delta = (Queue.StateDelta)event.getData();
                    if (delta.newState == 5) {
                        paused = true;
                    }
                }
            }
            ++n2;
        }
        if (paused != null) {
            this.updateChecked(tool, paused);
        }
    }

    public void updateCommandElement(UIElement element, Map<String, ?> parameters) {
        element.setChecked(this.isChecked);
    }

    @Override
    protected @Nullable Object execute(ExecutionEvent event, ToolProcess tool, IEvaluationContext evalContext) {
        boolean isPaused = tool.getQueue().isRequested((byte)5);
        boolean success = isPaused ? tool.getQueue().resume() : tool.getQueue().pause();
        this.updateChecked(success && (isPaused ^= success));
        return null;
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler
    implements IElementUpdater {
        public WorkbenchHandler() {
            super("org.eclipse.statet.nico.commands.PauseTool");
        }

        protected AbstractScopeHandler createScopeHandler(Object scope) {
            return new PauseHandler((IWorkbenchWindow)scope, this.getCommandId());
        }
    }
}

