/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.internal.nico.ui.LocalTaskTransfer;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsolePage;
import org.eclipse.statet.nico.ui.console.SubmitPasteAction;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;

public class SubmitDropAdapter
implements DropTargetListener {
    private final NIConsolePage page;

    public SubmitDropAdapter(NIConsolePage page) {
        this.page = page;
    }

    public void dragEnter(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.validate(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 0;
    }

    public void dropAccept(DropTargetEvent event) {
        this.validate(event);
    }

    public void drop(DropTargetEvent event) {
        if (LocalTaskTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            LocalTaskTransfer.Data data = (LocalTaskTransfer.Data)event.data;
            ToolProcess process = this.page.getConsole().getProcess();
            if (data == null || data.process == null || data.runnables == null || process.isTerminated()) {
                return;
            }
            data.process.getQueue().move(data.runnables, process.getQueue());
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            ToolController controller = this.page.getConsole().getProcess().getController();
            if (text == null || controller == null) {
                return;
            }
            IRunnableWithProgress runnable = SubmitPasteAction.createRunnable(controller, text);
            NicoUITools.runSubmitInBackground(controller.getTool(), runnable, this.page.getSite().getShell());
            return;
        }
    }

    private void validate(DropTargetEvent event) {
        ToolProcess process = this.page.getConsole().getProcess();
        if (LocalTaskTransfer.getTransfer().isSupportedType(event.currentDataType) && (event.operations & 2) == 2 && process.getMainType().equals(LocalTaskTransfer.getTransfer().getMainType()) && !process.isTerminated()) {
            event.detail = 2;
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (event.operations & 1) == 1 && !this.page.getConsole().getProcess().isTerminated()) {
            event.detail = 1;
            return;
        }
        event.detail = 0;
    }

    public static class TaskSet {
        public ToolProcess process;
    }
}

