/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.refactoring;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.ast.NodeType;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LtxSourceIndenter {
    private TexCodeStyleSettings codeStyle;
    private AbstractDocument document;
    private TexAstNode rootNode;
    private int refLine;
    private int firstLine;
    private int lastLine;
    private IndentUtil util;
    private int[] lineColumns;

    public void setup(TexCoreAccess coreAccess) {
        this.codeStyle = coreAccess.getTexCodeStyle();
    }

    private void init(AbstractDocument document, TexAstNode node, int firstLine, int lastLine) throws BadLocationException {
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (firstLine < 0 || lastLine < 0 || firstLine > lastLine) {
            throw new IllegalArgumentException("line index");
        }
        this.document = document;
        this.rootNode = node;
        this.firstLine = firstLine;
        this.lastLine = lastLine;
        int count = this.document.getNumberOfLines(0, this.document.getLineOffset(this.lastLine));
        this.lineColumns = new int[count + 2];
        Arrays.fill(this.lineColumns, -1);
        this.util = new IndentUtil((IDocument)document, (IIndentSettings)this.codeStyle);
    }

    public void clear() {
        this.document = null;
        this.rootNode = null;
        this.codeStyle = null;
        this.util = null;
        this.lineColumns = null;
    }

    public int getNewIndentColumn(int line) throws BadLocationException {
        return this.lineColumns[line];
    }

    public int getNewIndentOffset(int line) {
        try {
            return this.util.getIndentedOffsetAt(line, this.lineColumns[line]);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public TextEdit getIndentEdits(AbstractDocument document, TexAstNode node, int codeOffset, int firstLine, int lastLine) throws CoreException {
        try {
            this.init(document, node, firstLine, lastLine);
            this.computeIndent(codeOffset);
            return this.createEdits();
        }
        catch (BadLocationException e) {
            throw this.createFailedException(e);
        }
    }

    protected void computeIndent(int codeOffset) throws BadLocationException {
        this.refLine = this.firstLine - 1;
        if (this.refLine >= 0) {
            this.lineColumns[this.refLine] = this.util.getLineIndent(this.refLine, false)[0];
            int i = this.refLine + 1;
            while (i < this.firstLine) {
                this.lineColumns[i] = this.lineColumns[this.refLine];
                ++i;
            }
        }
        int line = this.firstLine;
        while (line <= this.lastLine) {
            boolean addEnv = false;
            if (line <= 0 || this.codeStyle.getIndentEnvDepth() <= 0) continue;
            this.lineColumns[line] = this.lineColumns[line - 1];
            IRegion prevLine = this.document.getLineInformation(line - 1);
            IRegion currentLine = this.document.getLineInformation(line);
            int currentLineStop = currentLine.getOffset() + currentLine.getLength();
            AstNode node = AstSelection.search((AstNode)this.rootNode, (int)(prevLine.getOffset() + prevLine.getLength()), (int)(prevLine.getOffset() + prevLine.getLength()), (int)3).getCovering();
            while (node != null && !(node instanceof TexAstNode)) {
                node = node.getParent();
            }
            if (node instanceof TexAstNode) {
                TexAstNode texNode = (TexAstNode)node;
                Set<String> envs = this.codeStyle.getIndentEnvLabels();
                while (texNode != null && (texNode.getStartOffset() >= prevLine.getOffset() || texNode.getEndOffset() <= currentLineStop)) {
                    if (texNode.getNodeType() == NodeType.ENVIRONMENT && (envs == null || envs.contains(texNode.getText()))) {
                        if (texNode.getStartOffset() >= prevLine.getOffset() && texNode.getEndOffset() > currentLineStop) {
                            addEnv = true;
                            break;
                        }
                        if (texNode.getStartOffset() >= prevLine.getOffset() || texNode.getEndOffset() > currentLineStop) break;
                        int beginLine = this.document.getLineOfOffset(texNode.getStartOffset());
                        if (this.lineColumns[beginLine] < 0) {
                            this.lineColumns[beginLine] = this.util.getLineIndent(beginLine, false)[0];
                        }
                        this.lineColumns[line] = this.lineColumns[beginLine];
                        break;
                    }
                    texNode = texNode.getTexParent();
                }
            }
            if (addEnv) {
                int n = line;
                this.lineColumns[n] = this.lineColumns[n] + this.codeStyle.getIndentEnvDepth() * this.util.getLevelColumns();
            }
            ++line;
        }
    }

    protected MultiTextEdit createEdits() throws BadLocationException, CoreException {
        final MultiTextEdit edits = new MultiTextEdit();
        IndentUtil.IndentEditAction action = new IndentUtil.IndentEditAction(){

            public int getIndentColumn(int line, int lineOffset) throws BadLocationException {
                return LtxSourceIndenter.this.getNewIndentColumn(line);
            }

            public void doEdit(int line, int offset, int length, StringBuilder text) throws BadLocationException {
                if (text != null) {
                    edits.addChild((TextEdit)new ReplaceEdit(offset, length, text.toString()));
                }
            }
        };
        this.util.changeIndent(this.firstLine, this.lastLine, action);
        return edits;
    }

    protected CoreException createFailedException(Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", -1, "Indentation failed", e));
    }
}

