/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.internal.r.ui.dataeditor.GotoCellDialog;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableViewer;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public class GotoCellHandler
extends AbstractHandler
implements IElementUpdater {
    private final RDataTableViewer tableViewer;

    public GotoCellHandler(RDataTableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void updateElement(UIElement element, Map parameters) {
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
        try {
            element.setText("Go to line (cell)...");
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.tableViewer.isOK()) {
            return null;
        }
        GotoCellDialog dialog = new GotoCellDialog(this.tableViewer);
        long[] anchor = this.tableViewer.getAnchorDataIdxs();
        if (anchor != null) {
            if (anchor[0] >= 0L) {
                dialog.set(Orientation.HORIZONTAL, anchor[0]);
            }
            if (anchor[1] >= 0L) {
                dialog.set(Orientation.VERTICAL, anchor[1]);
            }
        }
        if (dialog.open() == 0) {
            this.tableViewer.setAnchorDataIdxs(dialog.get(Orientation.HORIZONTAL), dialog.get(Orientation.VERTICAL));
        }
        return null;
    }
}

