/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.graphics;

import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.rj.eclient.graphics.ERGraphic;
import org.eclipse.statet.rj.eclient.graphics.util.CopyToDevRunnable;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class StatetRGraphicCopyToDevWizard
extends Wizard {
    private final RProcess tool;
    private final ERGraphic graphic;
    private final String devCmd;
    private final String devAbbr;
    private ConfigPage page;

    public StatetRGraphicCopyToDevWizard(RProcess tool, ERGraphic graphic, String devCmd, String devAbbr) {
        this.tool = tool;
        this.graphic = graphic;
        this.devCmd = devCmd;
        this.devAbbr = devAbbr;
        this.setDialogSettings(DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"GraphicCopyToDev-Wizard"));
        this.setWindowTitle("Save Graphic using R");
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.page = new ConfigPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (!this.tool.isTerminated()) {
            try {
                String path;
                FileValidator validator = this.page.getValidator();
                final IPath relative = validator.isRelativeFile() ? validator.getRelativeFile() : null;
                final IFileStore absolute = relative == null ? validator.getFileStore() : null;
                try {
                    path = relative != null ? relative.toString() : this.tool.getWorkspaceData().toToolPath(absolute);
                }
                catch (StatusException e) {
                    throw StatusUtils.convert((StatusException)e);
                }
                final boolean open = this.page.getOpen();
                final IWorkbenchPage workbenchPage = UIAccess.getActiveWorkbenchPage((boolean)true);
                this.graphic.getRHandle().getQueue().add((ToolRunnable)new CopyToDevRunnable(this.graphic, this.devCmd, RUtil.escapeCompletely((String)path), "onefile= TRUE, paper= \"special\""){

                    public void run(RToolService r, ProgressMonitor m) throws StatusException {
                        super.run(r, m);
                        if (open) {
                            try {
                                IFileStore fileName;
                                if (relative != null) {
                                    ((IRBasicAdapter)r).refreshWorkspaceData(0, m);
                                    IFileStore wd = StatetRGraphicCopyToDevWizard.this.tool.getWorkspaceData().getWorkspaceDir();
                                    if (wd == null) {
                                        return;
                                    }
                                    fileName = wd.getFileStore(relative);
                                } else {
                                    fileName = absolute;
                                }
                                if (fileName != null && fileName.fetchInfo(0, null).exists()) {
                                    UIAccess.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                IWorkbenchPage page = workbenchPage;
                                                if (page == null || page.getWorkbenchWindow().getShell() == null) {
                                                    page = UIAccess.getActiveWorkbenchPage((boolean)true);
                                                }
                                                if (page == null) {
                                                    return;
                                                }
                                                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileName);
                                            }
                                            catch (CoreException e) {
                                                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", "An error occurred when opening the exported R graphic.", (Throwable)e));
                                            }
                                        }
                                    });
                                }
                            }
                            catch (CoreException e) {
                                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", "An error occurred when opening the exported R graphic.", (Throwable)e));
                            }
                        }
                    }
                });
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)"An error occurred when exporting the R graphic (Device {0}).", (Object)(this.graphic.getDevId() + 1)), (Throwable)e), 3);
                return false;
            }
        }
        this.page.saveSettings();
        return true;
    }

    private class ConfigPage
    extends WizardPage {
        private static final String SETTINGS_HISTORY = "todev.file-";
        private static final String SETTINGS_OPEN = "open.file-";
        private final String settingType;
        private final IObservableValue<String> newLocationValue;
        private final IObservableValue<Boolean> openFileValue;
        private ResourceInputComposite locationGroup;
        private Button openFileControl;
        private DataBindingContext dbc;

        public ConfigPage() {
            super("Config");
            this.settingType = StatetRGraphicCopyToDevWizard.this.devAbbr.toLowerCase(Locale.ROOT);
            this.setTitle(NLS.bind((String)"Save Graphic as {0} using R", (Object)StatetRGraphicCopyToDevWizard.this.devAbbr.toUpperCase()));
            this.setDescription("Select the file to save the graphic to.");
            Realm realm = Realm.getDefault();
            this.newLocationValue = new WritableValue(realm, (Object)"", String.class);
            this.openFileValue = new WritableValue(realm, (Object)Boolean.FALSE, Boolean.class);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)new GridLayout());
            this.setControl((Control)container);
            this.createContents(container);
            LayoutUtils.addSmallFiller((Composite)container, (boolean)true);
            ToolInfoGroup info = new ToolInfoGroup(container, (ToolProcess)StatetRGraphicCopyToDevWizard.this.tool);
            info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            Dialog.applyDialogFont((Control)container);
            this.setErrorMessage(null);
            this.setMessage(null);
        }

        protected void createContents(Composite container) {
            this.locationGroup = new ResourceInputComposite(container, 1, 5, "Graphic File");
            IFileStore wd = StatetRGraphicCopyToDevWizard.this.tool.getWorkspaceData().getWorkspaceDir();
            if (wd != null) {
                this.locationGroup.getValidator().setRelative((IStringVariable)new StaticVariable("wd", null, wd.toString()), 2);
            } else {
                this.locationGroup.getValidator().setIgnoreRelative(true);
            }
            this.locationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.locationGroup.setHistory(this.getDialogSettings().getArray(SETTINGS_HISTORY + this.settingType));
            Group group = new Group(container, -1);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
            this.openFileControl = new Button((Composite)group, 32);
            this.openFileControl.setLayoutData((Object)new GridData(4, 4, true, false));
            this.openFileControl.setText("&Open file when finished");
            Realm realm = Realm.getDefault();
            this.dbc = new DataBindingContext(realm);
            this.dbc.bindValue(this.locationGroup.getObservable(), this.newLocationValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.locationGroup.getValidator()), null);
            this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.openFileControl), this.openFileValue);
            this.openFileValue.setValue((Object)this.getDialogSettings().getBoolean(SETTINGS_OPEN + this.settingType));
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)(SETTINGS_HISTORY + this.settingType), (String)((String)this.newLocationValue.getValue()));
            settings.put(SETTINGS_OPEN + this.settingType, ((Boolean)this.openFileValue.getValue()).booleanValue());
        }

        public FileValidator getValidator() throws CoreException {
            return this.locationGroup.getValidator();
        }

        public boolean getOpen() {
            return (Boolean)this.openFileValue.getValue();
        }

        public void dispose() {
            if (this.dbc != null) {
                this.dbc.dispose();
                this.dbc = null;
            }
            super.dispose();
        }
    }
}

