/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.statet.internal.r.ui.pager.TextFileDocumentProvider;
import org.eclipse.statet.internal.r.ui.pager.TextFileSourceViewerConfiguration;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;

@NonNullByDefault
public class TextFileEditorPage
extends StatusTextEditor {
    private static final TextFileDocumentProvider DOCUMENT_PROVIDER = new TextFileDocumentProvider();
    private final TextFileSourceViewerConfiguration sourceViewerConfiguration;

    public TextFileEditorPage() {
        this.setDocumentProvider((IDocumentProvider)DOCUMENT_PROVIDER);
        this.sourceViewerConfiguration = new TextFileSourceViewerConfiguration();
        this.setSourceViewerConfiguration(this.sourceViewerConfiguration);
        this.setRulerContextMenuId("");
    }

    public TextFileDocumentProvider getDocumentProvider() {
        return (TextFileDocumentProvider)super.getDocumentProvider();
    }

    protected void doSetInput(@Nullable IEditorInput input) throws CoreException {
        TextFileDocumentProvider documentProvider = this.getDocumentProvider();
        documentProvider.connect(input);
        try {
            this.sourceViewerConfiguration.setStyleRegions(DOCUMENT_PROVIDER.getTextFormatRegions(input));
            super.doSetInput(input);
        }
        finally {
            documentProvider.disconnect(input);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void performSaveAs(@Nullable IProgressMonitor progressMonitor) {
    }

    protected IVerticalRuler createVerticalRuler() {
        return new CompositeRuler();
    }
}

