/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.workbench.ContainerSelectionComposite;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathUtils;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizardPage;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.swt.widgets.Composite;

public class NewRFileCreationWizardPage
extends NewElementWizardPage {
    private static final String fgDefaultExtension = ".R";
    private final NewElementWizardPage.ResourceGroup resourceGroup;

    public NewRFileCreationWizardPage(IStructuredSelection selection) {
        super("NewRFileCreationWizardPage", selection);
        this.setTitle(Messages.NewRScriptFileWizardPage_title);
        this.setDescription(Messages.NewRScriptFileWizardPage_description);
        this.resourceGroup = new NewElementWizardPage.ResourceGroup((NewElementWizardPage)this, fgDefaultExtension, (ContainerSelectionComposite.ContainerFilter)new RSourceFolderFilter());
    }

    protected void createContents(Composite parent) {
        this.resourceGroup.createGroup(parent);
    }

    NewElementWizardPage.ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }

    public void saveSettings() {
        this.resourceGroup.saveSettings();
    }

    protected void validatePage() {
        this.updateStatus(this.resourceGroup.validate());
    }

    private static class RSourceFolderFilter
    extends ContainerSelectionComposite.ContainerFilter {
        private RSourceFolderFilter() {
        }

        public boolean select(IContainer container) {
            IProject project;
            block6: {
                project = container.getProject();
                if (container.getType() != 4) break block6;
                if (project.hasNature("org.eclipse.statet.r.resourceProjects.R")) {
                    return true;
                }
            }
            try {
                RProject rProject = RProjects.getRProject((IProject)project);
                if (rProject != null) {
                    ImList buildpath = rProject.getRawBuildpath();
                    for (BuildpathElement sourceContainer : buildpath) {
                        if (!sourceContainer.getPath().isPrefixOf(container.getFullPath())) continue;
                        return !BuildpathUtils.isExcluded((IResource)container, (BuildpathElement)sourceContainer);
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return false;
        }
    }
}

