/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.graphics;

import com.ibm.icu.text.DecimalFormat;
import org.eclipse.statet.ecommons.graphics.core.ColorAlphaDef;
import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.ui.components.AlphaSelector;
import org.eclipse.statet.ecommons.ui.components.DoubleText;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.dialogs.ToolPopup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RAlphaChooser
extends ToolPopup {
    private static final String ALPHA = "Alpha";
    private Float fInitialValue;
    private int fInitial255 = -1;
    private Color fInitialSWTColor;
    private Float fCurrentValue;
    private int fCurrent255 = -1;
    private Color fCurrentSWTColor;
    private ColorDef fBaseColor;
    private Composite fStatusControl;

    public static void drawPreview(GC gc, int x, int y, int width, int height, Color color) {
        if (color != null) {
            gc.setBackground(gc.getDevice().getSystemColor(1));
            gc.fillRectangle(x, y, width + 1, height + 1);
            gc.setBackground(color);
            int b = 1 + height / 4;
            gc.fillRectangle(x, y + b, width + 1, height + 1 - 2 * b);
        }
    }

    public static Color createPreviewColor(ColorAlphaDef baseColor) {
        return RAlphaChooser.createPreviewColor(baseColor.getAlpha255(), (ColorDef)baseColor);
    }

    public static Color createPreviewColor(int alpha255, ColorDef baseColor) {
        if (baseColor == null) {
            return new Color(alpha255, alpha255, alpha255);
        }
        int white = 255 - alpha255;
        return new Color(white + baseColor.getRed() * alpha255 / 255, white + baseColor.getGreen() * alpha255 / 255, white + baseColor.getBlue() * alpha255 / 255);
    }

    public void open(Shell parent, Rectangle position, Float initialValue) {
        this.fInitialValue = initialValue;
        if (initialValue != null) {
            this.fInitial255 = 255 - Math.round(initialValue.floatValue() * 255.0f);
        }
        this.doSetValue(initialValue != null ? initialValue : Float.valueOf(1.0f));
        super.open(parent, position);
    }

    protected void addTabs(CTabFolder tabFolder) {
        new AlphaTab(this){

            @Override
            protected Float getValue() {
                return RAlphaChooser.this.getValue();
            }

            @Override
            protected void setValue(Float value) {
                RAlphaChooser.this.doSetValue(value);
            }
        };
    }

    protected ToolPopup.ToolTab getBestTab() {
        return this.getTab(ALPHA);
    }

    protected void addStatusControls(Composite composite) {
        this.fStatusControl = new ToolPopup.PreviewCanvas(composite){

            protected void drawPreview(GC gc, int idx, int x, int y, int width, int height) {
                Color color = null;
                switch (idx) {
                    case 0: {
                        if (RAlphaChooser.this.fInitialValue == null) break;
                        if (RAlphaChooser.this.fInitialSWTColor == null) {
                            RAlphaChooser.this.fInitialSWTColor = RAlphaChooser.createPreviewColor(RAlphaChooser.this.fInitial255, RAlphaChooser.this.fBaseColor);
                        }
                        color = RAlphaChooser.this.fInitialSWTColor;
                        break;
                    }
                    case 1: {
                        if (RAlphaChooser.this.fCurrentValue == null) break;
                        if (RAlphaChooser.this.fCurrentSWTColor == null) {
                            RAlphaChooser.this.fCurrentSWTColor = RAlphaChooser.createPreviewColor(RAlphaChooser.this.fCurrent255, RAlphaChooser.this.fBaseColor);
                        }
                        color = RAlphaChooser.this.fCurrentSWTColor;
                        break;
                    }
                }
                RAlphaChooser.drawPreview(gc, x, y, width, height, color);
            }
        };
        this.updateStatus();
    }

    protected void doSetValue(Float value) {
        if (value == null || value.equals(this.fCurrentValue)) {
            return;
        }
        int v255 = 255 - Math.round(value.floatValue() * 255.0f);
        if (this.fCurrentSWTColor != null && v255 != this.fCurrent255) {
            this.fCurrentSWTColor = null;
        }
        this.fCurrentValue = value;
        this.fCurrent255 = v255;
        if (this.fStatusControl != null) {
            this.updateStatus();
        }
    }

    protected void updateStatus() {
        StringBuilder sb = new StringBuilder();
        DecimalFormat format = ((AlphaTab)this.getTab(ALPHA)).getFormat();
        sb.append("Previous: ");
        sb.append(this.fInitialValue != null ? format.format((Object)this.fInitialValue) : "-");
        sb.append("\n");
        sb.append("Current: ");
        sb.append(format.format((Object)this.fCurrentValue));
        this.fStatusControl.setToolTipText(sb.toString());
        this.fStatusControl.redraw();
    }

    public Float getValue() {
        return this.fCurrentValue;
    }

    protected void onDispose() {
        this.fStatusControl = null;
        super.onDispose();
    }

    protected static abstract class AlphaTab
    extends ToolPopup.ToolTab {
        private final AlphaSelector fSelector;
        private DoubleText fText;
        private int fTextChange;
        private final DecimalFormat fFormat = DoubleText.createFormat((int)3);

        AlphaTab(ToolPopup parent) {
            this(parent, RAlphaChooser.ALPHA, "Definition by Alpha [0, 1]");
        }

        AlphaTab(ToolPopup parent, String name, String tooltip) {
            super(RAlphaChooser.ALPHA, parent, name, tooltip);
            Composite composite = this.create();
            composite.setLayout((Layout)LayoutUtils.newTabGrid((int)3));
            this.fSelector = new AlphaSelector(composite, composite.getBackground());
            this.fSelector.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
            IObjValueListener<Double> textListener = new IObjValueListener<Double>(){

                public void valueAboutToChange(ObjValueEvent<Double> event) {
                }

                public void valueChanged(ObjValueEvent<Double> event) {
                    if (event.newValue == null) {
                        return;
                    }
                    Float oldValue = fSelector.getValue(0);
                    ++fTextChange;
                    try {
                        try {
                            Float value = Float.valueOf(((Double)event.newValue).floatValue());
                            if (!value.equals(oldValue)) {
                                fSelector.setValue(0, value);
                                this.setValue(value);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            --fTextChange;
                        }
                    }
                    finally {
                        --fTextChange;
                    }
                }
            };
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText("     &Alpha (opaque):");
            DoubleText text = new DoubleText(composite, 2048);
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = LayoutUtils.hintWidth((Text)text.getControl(), (int)6);
            text.getControl().setLayoutData((Object)gd);
            text.addValueListener((IObjValueListener)textListener);
            text.setIncrement(0.001);
            text.setMinMax(0.0, 1.0);
            text.setFormat(this.fFormat);
            this.fText = text;
            Label label2 = new Label(composite, 0);
            GridData gd2 = new GridData(4, 4, false, true, 2, 1);
            label2.setLayoutData((Object)gd2);
            this.fSelector.addValueListener((IObjValueListener)new IObjValueListener<Float>(){

                public void valueAboutToChange(ObjValueEvent<Float> event) {
                }

                public void valueChanged(ObjValueEvent<Float> event) {
                    if (fTextChange == 0) {
                        Float value = (Float)event.newValue;
                        fText.setValue(0, Double.valueOf(value.doubleValue()));
                        this.setValue(value);
                    }
                }
            });
        }

        public DecimalFormat getFormat() {
            return this.fFormat;
        }

        protected void activated() {
            this.fSelector.setBaseColor(this.getBaseColor());
            Float value = this.getValue();
            this.fSelector.setValue(0, value);
        }

        protected abstract Float getValue();

        protected abstract void setValue(Float var1);

        protected ColorDef getBaseColor() {
            return null;
        }
    }
}

