/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;

@NonNullByDefault
public class InsertAssignmentHandler
extends AbstractHandler {
    private final SourceEditor editor;

    public InsertAssignmentHandler(SourceEditor editor) {
        this.editor = editor;
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        this.setBaseEnabled(this.editor.isEditable(false));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.editor.isEditable(true)) {
            this.insertSequence();
        }
        return null;
    }

    private RCodeStyleSettings getCodeStyle() {
        SourceUnit sourceUnit = this.editor.getSourceUnit();
        RCoreAccess coreAccess = sourceUnit instanceof RSourceUnit ? ((RSourceUnit)sourceUnit).getRCoreAccess() : RCore.getWorkbenchAccess();
        return coreAccess.getRCodeStyle();
    }

    private void insertSequence() {
        SourceViewer sourceViewer = this.editor.getViewer();
        IDocument document = sourceViewer.getDocument();
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        int selectionLength = selection.getLength();
        StringBuilder sequence = new StringBuilder("<-");
        try {
            RCodeStyleSettings codeStyle = this.getCodeStyle();
            if ((offset == 0 || !RTokens.isWhitespace((int)document.getChar(offset - 1))) && codeStyle.getWhitespaceAssignBefore()) {
                sequence.insert(0, ' ');
            }
            if (codeStyle.getWhitespaceAssignAfter()) {
                sequence.append(' ');
            }
            document.replace(offset, selectionLength, sequence.toString());
        }
        catch (BadLocationException e) {
            RUIPlugin.logError(100, "An error occurred while inserting assignment.", e);
        }
        int targetOffset = offset + sequence.length();
        sourceViewer.setSelectedRange(targetOffset, 0);
        sourceViewer.revealRange(targetOffset, 0);
    }
}

