/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.time.Duration;
import java.time.Instant;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class APool2NodeObject
extends DefaultPooledObject<APool2NodeHandler> {
    private volatile long lastAllocatedBeginNanos;
    private volatile long lastAllocatedEndNanos;
    private volatile Instant stateTime = this.getCreateInstant();

    public APool2NodeObject(APool2NodeHandler object) {
        super((Object)object);
    }

    public synchronized boolean allocate() {
        if (super.allocate()) {
            this.lastAllocatedBeginNanos = System.nanoTime();
            this.stateTime = Instant.now();
            return true;
        }
        return false;
    }

    public synchronized void markReturning() {
        switch (this.getState()) {
            case RETURNING: {
                return;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
        }
        this.stateTime = Instant.now();
        super.markReturning();
    }

    public synchronized boolean deallocate() {
        switch (this.getState()) {
            case IDLE: {
                return false;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
            case RETURNING: {
                this.stateTime = Instant.now();
                return super.deallocate();
            }
        }
        return false;
    }

    public synchronized void invalidate() {
        switch (this.getState()) {
            case INVALID: {
                return;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
        }
        this.stateTime = Instant.now();
        super.invalidate();
    }

    public Instant getStateTime() {
        return this.stateTime;
    }

    public @Nullable Duration getActiveDuration() {
        if (this.getBorrowedCount() <= 0L) {
            return null;
        }
        long end = this.lastAllocatedEndNanos;
        long begin = this.lastAllocatedBeginNanos;
        long t = end - begin;
        if (t < 0L) {
            t = System.nanoTime() - begin;
        }
        return Duration.ofNanos(t);
    }

    public long getActiveTimeMillis() {
        Duration duration = this.getActiveDuration();
        return duration != null ? duration.toMillis() : -1L;
    }
}

