/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.ui.ElementNameProvider;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.rtm.base.ui.rexpr.DefaultRExprTypeUIAdapters;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.statet.rtm.base.util.RExprType;
import org.eclipse.swt.graphics.Image;

public class RExprTypeUIAdapter {
    protected static final int PRIORITY_INVALID = 0;
    protected static final int PRIORITY_DEFAULT = 10;
    private final RExprType type;
    private final Image image;

    public RExprTypeUIAdapter(RExprType type, Image image) {
        this.type = type;
        this.image = image;
    }

    public RExprType getType() {
        return this.type;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.type.getLabel();
    }

    public RExprWidget.TypeDef createWidgetDef() {
        return new RExprWidget.TypeDef(this);
    }

    public int isValidInput(Object input, IContext context) {
        List<?> elements = this.getElements(input);
        if (elements == null || elements.isEmpty() || !this.isMulti() && elements.size() != 1) {
            return 0;
        }
        return this.isValidElements(elements);
    }

    public List<String> getInputExprs(Object input, IContext context) {
        List<?> elements = this.getElements(input);
        return this.collectElementName(elements, input instanceof ElementNameProvider ? (ElementNameProvider)input : DefaultRExprTypeUIAdapters.DIRECT_NAME);
    }

    public int isMoveValid(Object input, IContext source, IContext context) {
        return 0;
    }

    protected List<?> getElements(Object input) {
        if (input instanceof IStructuredSelection) {
            return ((IStructuredSelection)input).toList();
        }
        if (input instanceof List) {
            return (List)input;
        }
        return null;
    }

    protected boolean isMulti() {
        return false;
    }

    protected int isValidElements(List<?> elements) {
        int priority = Integer.MAX_VALUE;
        for (Object element : elements) {
            int elementPriority = this.isValidElement(element);
            if (elementPriority <= 0) {
                return 0;
            }
            if (elementPriority >= priority) continue;
            priority = elementPriority;
        }
        return priority;
    }

    protected int isValidElement(Object element) {
        return 0;
    }

    protected List<String> collectElementName(List<?> elements, ElementNameProvider nameProvider) {
        ArrayList<String> expressions = new ArrayList<String>(elements.size());
        for (Object element : elements) {
            String name;
            ElementName elementName = nameProvider.getElementName(element);
            if (!(elementName instanceof RElementName) || (name = elementName.getDisplayName()) == null) continue;
            expressions.add(name);
        }
        return expressions;
    }

    public String adopt(String typeKey, String expr) {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RExprTypeUIAdapter");
        sb.append(" for '").append(this.getType().getTypeKey()).append("'");
        sb.append(" (").append(this.getClass().getName()).append(")");
        sb.append("\n\tlabel= ").append(this.getLabel());
        sb.append("\n\tisMulti= ").append(this.isMulti());
        return sb.toString();
    }
}

