/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.ast.Block;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikidocParser;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.HardLineWrap;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupSourceFormatAdapter;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextHeuristicTokenScanner;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikidocDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextDocumentConstants;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextPartitionNodeType;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.AbstractMarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.ecommons.text.core.util.NonDeletingPositionUpdater;
import org.eclipse.statet.ecommons.text.ui.assist.LinkedModeBracketLevel;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.WikitextBracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractAutoEditStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.text.edits.TextEdit;

public class MarkupAutoEditStrategy
extends AbstractAutoEditStrategy {
    private static final char[] CURLY_BRACKET_TYPE = new char[]{'{', '}'};
    private static final char[] SQUARE_BRACKET_TYPE = new char[]{'[', ']'};
    private static final char[] PARATHESIS_TYPE = new char[]{'[', ']'};
    private static final WikidocParser DEFAULT_PARSER = new WikidocParser(null);
    private static final String POSITION_CATEGORY = "org.eclipse.statet.docmlet.wikitext.MarkupAutoEdit";
    private static final IPositionUpdater POSITION_UPDATER = new NonDeletingPositionUpdater("org.eclipse.statet.docmlet.wikitext.MarkupAutoEdit");
    private final WikitextCoreAccess wikitextCoreAccess;
    private final Settings settings;
    private WikitextHeuristicTokenScanner scanner;
    private WikitextCodeStyleSettings wikitextCodeStyle;
    private final HardLineWrap hardLineWrap;

    public MarkupAutoEditStrategy(WikitextCoreAccess coreAccess, SourceEditor editor) {
        super(editor);
        assert (coreAccess != null);
        this.wikitextCoreAccess = coreAccess;
        this.settings = new Settings(coreAccess);
        this.hardLineWrap = new HardLineWrap(this.getDocumentContentInfo(), this.wikitextCoreAccess);
    }

    public Settings getSettings() {
        return this.settings;
    }

    protected IIndentSettings getCodeStyleSettings() {
        return this.wikitextCodeStyle;
    }

    protected TreePartition initCustomization(int offset, int ch) throws BadLocationException, BadPartitioningException {
        if (this.scanner == null) {
            this.scanner = this.createScanner();
        }
        this.wikitextCodeStyle = this.wikitextCoreAccess.getWikitextCodeStyle();
        return super.initCustomization(offset, ch);
    }

    protected WikitextHeuristicTokenScanner createScanner() {
        return WikitextHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo());
    }

    /*
     * Unable to fully structure code
     */
    protected TextRegion computeValidRange(int offset, TreePartition partition, int ch) {
        block1: {
            node = partition.getTreeNode();
            if (!(node.getType() instanceof WikitextPartitionNodeType)) break block1;
            if (this.getDocumentContentInfo().getPrimaryType() != "org.eclipse.statet.Wikidoc") ** GOTO lbl6
            return super.computeValidRange(offset, partition, ch);
lbl-1000:
            // 1 sources

            {
                node = parent;
lbl6:
                // 2 sources

                ** while ((parent = node.getParent()) != null && parent.getType() instanceof WikitextPartitionNodeType)
            }
lbl7:
            // 1 sources

            return node;
        }
        return null;
    }

    protected WikitextHeuristicTokenScanner getScanner() {
        return this.scanner;
    }

    protected void quitCustomization() {
        super.quitCustomization();
        this.wikitextCodeStyle = null;
    }

    private final boolean isClosedBracket(int backwardOffset, int forwardOffset, String currentPartition, char[] type) {
        try {
            AbstractDocument doc = this.getDocument();
            this.scanner.configure((IDocument)doc, currentPartition);
            IRegion line = doc.getLineInformationOfOffset(forwardOffset);
            int balance = this.scanner.computePairBalance(backwardOffset, line.getOffset(), forwardOffset, line.getOffset() + line.getLength(), 1, type, '\\');
            return balance <= 0;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    private boolean isValueChar(int offset) throws BadLocationException {
        int ch = this.getChar(offset);
        return ch != -1 && Character.isLetterOrDigit(ch);
    }

    protected final WikitextMarkupLanguage getMarkupLanguage() {
        return WikidocDocumentSetupParticipant.getMarkupLanguage((IDocument)this.getDocument(), (String)this.getDocumentContentInfo().getPartitioning());
    }

    protected final MarkupConfig getMarkupConfig() {
        WikitextMarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage != null) {
            return markupLanguage.getMarkupConfig();
        }
        return null;
    }

    protected final ExtdocMarkupLanguage getExtdocMarkupLanguage() {
        WikitextMarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage instanceof ExtdocMarkupLanguage) {
            return (ExtdocMarkupLanguage)markupLanguage;
        }
        return null;
    }

    protected char isCustomizeKey(KeyEvent event) {
        switch (event.character) {
            case '$': 
            case '(': 
            case '[': 
            case '{': {
                return event.character;
            }
            case '\t': {
                if (event.stateMask != 0) break;
                return '\t';
            }
            case '\n': 
            case '\r': {
                if (this.getEditor3() == null) break;
                return '\n';
            }
        }
        return '\u0000';
    }

    protected void doCustomizeKeyCommand(char ch, DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        int cEnd = command.offset + command.length;
        int linkedModeType = -1;
        int linkedModeOffset = -1;
        switch (ch) {
            case '\t': {
                if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && this.isRegularTabCommand(command)) {
                    command.text = "\t";
                    this.smartInsertOnTab(command, true);
                    break;
                }
                return;
            }
            case '{': {
                if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && !WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "{";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, CURLY_BRACKET_TYPE)) {
                        command.text = "{}";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 125) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '[': {
                if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && !WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "[";
                    if (!this.settings.closeBrackets || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, SQUARE_BRACKET_TYPE)) {
                        command.text = "[]";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 93) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '(': {
                if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && !WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    command.text = "(";
                    if (!this.settings.closeParenthesis || this.isValueChar(cEnd)) break;
                    if (!this.isClosedBracket(command.offset, cEnd, contentType, PARATHESIS_TYPE)) {
                        command.text = "()";
                        linkedModeType = 0x1000002;
                        break;
                    }
                    if (this.getChar(cEnd) != 41) break;
                    linkedModeType = 2;
                    break;
                }
                return;
            }
            case '$': {
                if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType) && !WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)command.offset)) {
                    MarkupConfig markupConfig;
                    command.text = "$";
                    if (!this.settings.closeMathDollar || this.isValueChar(cEnd) || !((markupConfig = this.getMarkupConfig()) instanceof AbstractMarkupConfig) || !((AbstractMarkupConfig)markupConfig).isTexMathDollarsEnabled()) break;
                    command.text = "$$";
                    linkedModeType = 0x1000002;
                    break;
                }
                return;
            }
            case '\n': {
                if (!WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) break;
                command.text = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
                this.smartIndentOnNewLine(command);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (command.doit && command.text.length() > 0 && this.getEditor().isEditable(true)) {
            this.getViewer().getTextWidget().setRedraw(false);
            try {
                this.applyCommand(command);
                this.updateSelection(command);
                if (linkedModeType >= 0) {
                    if (linkedModeOffset < 0) {
                        linkedModeOffset = command.offset;
                    }
                    this.createLinkedMode(linkedModeOffset, ch, linkedModeType).enter();
                }
            }
            finally {
                this.getViewer().getTextWidget().setRedraw(true);
            }
        }
    }

    protected void doCustomizeOtherCommand(DocumentCommand command, TreePartition partition) throws Exception {
        String contentType = partition.getType();
        if (WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT.matches(contentType)) {
            if (command.length == 0 && TextUtilities.equals((String[])this.getDocument().getLegalLineDelimiters(), (String)command.text) != -1) {
                this.smartIndentOnNewLine(command);
            } else if (this.settings.hardWrapText) {
                this.smartLineWrap(command);
            }
        }
    }

    protected void smartIndentOnNewLine(DocumentCommand command) throws Exception {
        this.customizeCommandDefault(command);
    }

    protected void smartLineWrap(DocumentCommand command) throws Exception {
        AbstractDocument doc = this.getDocument();
        int lineNum = doc.getLineOfOffset(command.offset);
        IRegion lineInfo = doc.getLineInformation(lineNum);
        IndentUtil indentUtil = null;
        int processMode = 0;
        switch (this.settings.getSmartInsertHardWrapMode()) {
            case UPTO_CURSOR: {
                if (this.containsControl(command.text)) break;
                indentUtil = this.createIndentUtil(doc);
                int column = indentUtil.getColumn(lineNum, command.offset);
                column = indentUtil.getColumn((CharSequence)command.text, command.text.length(), column);
                if (column <= this.wikitextCodeStyle.getLineWidth()) break;
                processMode = 1;
                break;
            }
            case MERGE: {
                if (this.containsControl(command.text) || command.offset + command.length > lineInfo.getOffset() + lineInfo.getLength()) {
                    processMode = 3;
                    break;
                }
                indentUtil = this.createIndentUtil(doc);
                int column = indentUtil.getColumn(lineNum, command.offset);
                column = indentUtil.getColumn((CharSequence)command.text, command.text.length(), column);
                String tail = doc.get(command.offset + command.length, lineInfo.getOffset() + lineInfo.getLength() - (command.offset + command.length));
                column = indentUtil.getColumn((CharSequence)tail, tail.length(), column);
                if (column <= this.wikitextCodeStyle.getLineWidth()) break;
                processMode = 3;
                break;
            }
        }
        if (processMode != 0) {
            if (indentUtil == null) {
                indentUtil = this.createIndentUtil(doc);
            }
            this.wrapLine(command, (byte)processMode, indentUtil);
        }
    }

    protected void wrapLine(DocumentCommand command, byte mode, IndentUtil indentUtil) throws Exception {
        MarkupSourceFormatAdapter formatAdapter;
        ExtdocMarkupLanguage markupLanguage = this.getExtdocMarkupLanguage();
        if (markupLanguage == null || (formatAdapter = markupLanguage.getSourceFormatAdapter()) == null) {
            return;
        }
        AbstractDocument doc = this.getDocument();
        TextRegion workRegion = this.getFastParseRegion(command);
        SourceContent sourceContent = this.createSourceContent(doc, workRegion, command);
        Document workDoc = new Document(sourceContent.getString());
        WikidocParser parser = DEFAULT_PARSER;
        parser.setMarkupLanguage((WikitextMarkupLanguage)markupLanguage);
        SourceComponent sourceNode = parser.parse(sourceContent);
        TextEdit textEdit = this.hardLineWrap.createTextEdit((IDocument)workDoc, sourceNode, (TextRegion)new BasicTextRegion(doc.getLineOffset(doc.getLineOfOffset(command.offset)) - workRegion.getStartOffset(), command.offset + command.text.length() - workRegion.getStartOffset()), mode, formatAdapter, this.createIndentUtil((AbstractDocument)workDoc));
        if (textEdit == null) {
            return;
        }
        textEdit.moveTree(workRegion.getStartOffset());
        DocumentRewriteSession rewriteSession = doc.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
        try {
            doc.addPositionCategory(POSITION_CATEGORY);
            doc.addPositionUpdater(POSITION_UPDATER);
            this.applyCommand(command);
            Position offsetPosition = new Position(command.offset, doc.getLength() - command.offset);
            doc.addPosition(POSITION_CATEGORY, offsetPosition);
            if (command.caretOffset == -1) {
                command.caretOffset = command.offset + command.text.length();
            }
            Position caretPosition = new Position(command.caretOffset, doc.getLength() - command.caretOffset);
            doc.addPosition(POSITION_CATEGORY, caretPosition);
            textEdit.apply((IDocument)doc, 0);
            command.offset = offsetPosition.offset;
            command.caretOffset = caretPosition.offset;
            this.updateSelection(command);
        }
        finally {
            doc.stopRewriteSession(rewriteSession);
            doc.removePositionUpdater(POSITION_UPDATER);
            doc.removePositionCategory(POSITION_CATEGORY);
        }
    }

    protected void correctIndent(final DocumentCommand command, int minColumn, IndentUtil indentUtil) throws Exception {
        MarkupSourceFormatAdapter formatAdapter;
        ExtdocMarkupLanguage markupLanguage = this.getExtdocMarkupLanguage();
        if (markupLanguage == null || (formatAdapter = markupLanguage.getSourceFormatAdapter()) == null) {
            return;
        }
        AbstractDocument doc = this.getDocument();
        int lineNum = doc.getLineOfOffset(command.offset);
        int lineOffset = doc.getLineOffset(lineNum);
        TextRegion workRegion = this.getFastParseRegion(command);
        SourceContent sourceContent = this.createSourceContent(doc, workRegion, command);
        Document workDoc = new Document(sourceContent.getString());
        WikidocParser parser = DEFAULT_PARSER;
        parser.setMarkupLanguage((WikitextMarkupLanguage)markupLanguage);
        SourceComponent sourceNode = parser.parse(sourceContent);
        int offsetInAst = lineOffset - workRegion.getStartOffset();
        AstSelection astSelection = AstSelection.search((AstNode)sourceNode, (int)offsetInAst, (int)offsetInAst, (int)3);
        WikitextAstNode blockNode = this.getBlockNode(astSelection.getCovering(), offsetInAst);
        if (blockNode == null) {
            return;
        }
        String prefixText = formatAdapter.getPrefixCont(blockNode, this.createIndentUtil((AbstractDocument)workDoc));
        if (prefixText == null) {
            return;
        }
        IndentUtil.ILineIndent indent = indentUtil.getIndent((CharSequence)prefixText);
        if (indent.getIndentColumn() < minColumn) {
            return;
        }
        indentUtil.changeIndent(lineNum, lineNum, new IndentUtil.IndentEditAction(indent.getIndentColumn()){

            public void doEdit(int line, int lineOffset, int length, StringBuilder text) throws BadLocationException {
                command.offset = lineOffset;
                command.length = length;
                command.text = text != null ? text.toString() : "";
            }
        });
    }

    private TextRegion getFastParseRegion(DocumentCommand command) {
        TreePartitionNode child;
        AbstractDocument doc = this.getDocument();
        TextRegion validRange = this.getValidRange();
        TreePartitionNode rootNode = TreePartitionUtils.getRootNode((IDocument)doc, (String)this.getDocumentContentInfo().getPartitioning());
        int childIdx = rootNode.indexOfChild(command.offset);
        if (childIdx < 0) {
            childIdx = -(childIdx + 1);
        }
        int startOffset = 0;
        if (childIdx > 0) {
            TreePartitionNode child2 = rootNode.getChild(childIdx - 1);
            startOffset = child2.getType() instanceof WikitextPartitionNodeType ? child2.getStartOffset() : child2.getEndOffset();
        }
        if (startOffset < validRange.getStartOffset()) {
            startOffset = validRange.getStartOffset();
        }
        int endOffset = Integer.MAX_VALUE;
        if (childIdx < rootNode.getChildCount() && command.offset + command.length > (child = rootNode.getChild(childIdx)).getEndOffset() && (childIdx = rootNode.indexOfChild(command.offset + command.length)) < 0) {
            childIdx = -(childIdx + 1);
        }
        if (childIdx + 1 < rootNode.getChildCount()) {
            child = rootNode.getChild(childIdx + 1);
            endOffset = child.getType() instanceof WikitextPartitionNodeType ? child.getEndOffset() : child.getStartOffset();
        }
        if (endOffset > validRange.getEndOffset()) {
            endOffset = validRange.getEndOffset();
        }
        return new BasicTextRegion(startOffset, endOffset);
    }

    private WikitextAstNode getBlockNode(AstNode node, int offset) {
        while (node != null) {
            if (node instanceof Block && node.getStartOffset() < offset) {
                return (Block)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private LinkedModeUI createLinkedMode(int offset, char type, int mode) throws BadLocationException {
        LinkedModeModel model = new LinkedModeModel();
        int pos = 0;
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeBracketLevel.InBracketPosition position = WikitextBracketLevel.createPosition(type, (IDocument)this.getDocument(), offset + 1, 0, pos++);
        group.addPosition((LinkedPosition)position);
        model.addGroup(group);
        model.forceInstall();
        WikitextBracketLevel level = new WikitextBracketLevel(model, (IDocument)this.getDocument(), this.getDocumentContentInfo(), (List<? extends LinkedPosition>)ImCollections.newList((Object)position), mode & 0xFFFF0000);
        LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)this.getViewer());
        ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        ui.setExitPosition((ITextViewer)this.getViewer(), offset + (mode & 0xFF), 0, pos);
        ui.setSimpleMode(true);
        ui.setExitPolicy((LinkedModeUI.IExitPolicy)level);
        return ui;
    }

    public static final class Settings
    implements SmartInsertSettings,
    ISettingsChangedHandler {
        private final WikitextCoreAccess coreAccess;
        private boolean enabledByDefault;
        private SmartInsertSettings.TabAction tabAction;
        private boolean closeBrackets;
        private boolean closeParenthesis;
        private boolean closeMathDollar;
        private boolean hardWrapText;
        private SmartInsertSettings.HardWrapMode hardWrapMode;

        public Settings(WikitextCoreAccess coreAccess) {
            this.coreAccess = coreAccess;
            this.updateSettings();
        }

        public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
            if (groupIds == null || groupIds.contains("Wikitext/editor/smartinsert")) {
                this.updateSettings();
            }
        }

        private void updateSettings() {
            PreferenceAccess prefs = this.coreAccess.getPrefs();
            this.enabledByDefault = (Boolean)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
            this.tabAction = (SmartInsertSettings.TabAction)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_TAB_ACTION_PREF);
            this.closeBrackets = (Boolean)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_CLOSEBRACKETS_ENABLED_PREF);
            this.closeParenthesis = (Boolean)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_CLOSEPARENTHESIS_ENABLED_PREF);
            this.closeMathDollar = (Boolean)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_CLOSEMATHDOLLAR_ENABLED_PREF);
            this.hardWrapText = (Boolean)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_HARDWRAP_TEXT_ENABLED_PREF);
            this.hardWrapMode = (SmartInsertSettings.HardWrapMode)prefs.getPreferenceValue(WikitextEditingSettings.SMARTINSERT_HARDWRAP_MODE_PREF);
        }

        public boolean isSmartInsertEnabledByDefault() {
            return this.enabledByDefault;
        }

        public SmartInsertSettings.TabAction getSmartInsertTabAction() {
            return this.tabAction;
        }

        public SmartInsertSettings.HardWrapMode getSmartInsertHardWrapMode() {
            return this.hardWrapMode;
        }
    }
}

