/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze.core;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeCommandHandler;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeHelper;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.swt.CompositeFreezeLayerPainter;
import org.eclipse.statet.ecommons.waltable.freeze.ui.action.DefaultFreezeGridBindings;
import org.eclipse.statet.ecommons.waltable.grid.core.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportSelectDimPositionsCommandHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class CompositeFreezeLayer
extends CompositeLayer {
    protected final FreezeLayer freezeLayer;
    protected final ViewportLayer viewportLayer;
    protected final SelectionLayer selectionLayer;

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, true);
    }

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
        this.setChildLayer("FROZEN_REGION", freezeLayer, 0, 0);
        this.setChildLayer("FROZEN_ROW_REGION", new DimensionallyDependentLayer(viewportLayer.getScrollableLayer(), viewportLayer, freezeLayer), 1, 0);
        this.setChildLayer("FROZEN_COLUMN_REGION", new DimensionallyDependentLayer(viewportLayer.getScrollableLayer(), freezeLayer, viewportLayer), 0, 1);
        this.setChildLayer("NONFROZEN_REGION", viewportLayer, 1, 1);
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultFreezeGridBindings());
        }
    }

    @Override
    protected LayerPainter createPainter() {
        return new CompositeFreezeLayerPainter(this);
    }

    public boolean isFrozen() {
        return this.freezeLayer.isFrozen();
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new FreezeCommandHandler(this.freezeLayer, this.viewportLayer, this.selectionLayer));
        AbstractLayer frozenRowLayer = (AbstractLayer)this.getChildLayerByLayoutCoordinate(1, 0);
        frozenRowLayer.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(frozenRowLayer, Orientation.VERTICAL));
        AbstractLayer frozenColumnLayer = (AbstractLayer)this.getChildLayerByLayoutCoordinate(0, 1);
        frozenColumnLayer.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(frozenRowLayer, Orientation.HORIZONTAL));
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            this.viewportLayer.doCommand(command);
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Map<String, String> properties) {
        PositionCoordinate coord = this.freezeLayer.getTopLeftPosition();
        properties.put(String.valueOf(prefix) + ".freezeTopLeftPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        coord = this.freezeLayer.getBottomRightPosition();
        properties.put(String.valueOf(prefix) + ".freezeBottomRightPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Map<String, String> properties) {
        String property = properties.get(String.valueOf(prefix) + ".freezeTopLeftPosition");
        PositionCoordinate topLeftPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            topLeftPosition = new PositionCoordinate(this.freezeLayer, Long.parseLong(columnPosition), Long.parseLong(rowPosition));
        }
        property = properties.get(String.valueOf(prefix) + ".freezeBottomRightPosition");
        PositionCoordinate bottomRightPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            bottomRightPosition = new PositionCoordinate(this.freezeLayer, Long.parseLong(columnPosition), Long.parseLong(rowPosition));
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            if (topLeftPosition.columnPosition == -1L && topLeftPosition.rowPosition == -1L && bottomRightPosition.columnPosition == -1L && bottomRightPosition.rowPosition == -1L) {
                FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
            } else {
                FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
            }
        }
        super.loadState(prefix, properties);
    }
}

