/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.swt.events.MouseEvent;

public class NatEventData {
    private final Object originalEvent;
    private final NatTable natTable;
    private final LabelStack regionLabels;
    long columnPosition;
    long rowPosition;

    public static NatEventData createInstanceFromEvent(MouseEvent event) {
        NatTable natTable = (NatTable)event.widget;
        long columnPosition = natTable.getColumnPositionByX(event.x);
        long rowPosition = natTable.getRowPositionByY(event.y);
        return new NatEventData(natTable, natTable.getRegionLabelsByXY(event.x, event.y), columnPosition, rowPosition, event);
    }

    public NatEventData(NatTable natTable, LabelStack regionLabels, long columnPosition, long rowPosition, Object originalEvent) {
        this.natTable = natTable;
        this.regionLabels = regionLabels;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.originalEvent = originalEvent;
    }

    public NatTable getNatTable() {
        return this.natTable;
    }

    public LabelStack getRegionLabels() {
        return this.regionLabels;
    }

    public long getColumnPosition() {
        return this.columnPosition;
    }

    public long getRowPosition() {
        return this.rowPosition;
    }

    public Object getOriginalEvent() {
        return this.originalEvent;
    }
}

