/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.matcher;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;

public class CellPainterMouseEventMatcher
extends MouseEventMatcher {
    private LayerCellPainter targetCellPainter;
    private Class<? extends LayerCellPainter> targetCellPainterClass;

    public CellPainterMouseEventMatcher(String regionName, int button, LayerCellPainter targetCellPainter) {
        super(regionName, button);
        this.targetCellPainter = targetCellPainter;
    }

    public CellPainterMouseEventMatcher(String regionName, int button, Class<? extends LayerCellPainter> targetCellPainterClass) {
        super(regionName, button);
        this.targetCellPainterClass = targetCellPainterClass;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        long rowPosition;
        long columnPosition;
        LayerCell cell;
        if (super.matches(natTable, event, regionLabels) && (cell = natTable.getCellByPosition(columnPosition = natTable.getColumnPositionByX(event.x), rowPosition = natTable.getRowPositionByY(event.y))) != null) {
            ConfigRegistry configRegistry = natTable.getConfigRegistry();
            LayerCellPainter layerCellPainter = configRegistry.getAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getLabels().getLabels());
            GC gc = new GC((Drawable)natTable.getDisplay());
            try {
                LRectangle adjustedCellBounds = natTable.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
                LayerCellPainter clickedCellPainter = layerCellPainter.getCellPainterAt(event.x, event.y, cell, gc, adjustedCellBounds, configRegistry);
                if (clickedCellPainter != null && (this.targetCellPainter != null && this.targetCellPainter == clickedCellPainter || this.targetCellPainterClass != null && this.targetCellPainterClass.isInstance(clickedCellPainter))) {
                    return true;
                }
            }
            finally {
                gc.dispose();
            }
        }
        return false;
    }
}

