/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.viewport.core.ScrollStepCommand;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ScrollStepCommandHandler
implements LayerCommandHandler<ScrollStepCommand> {
    private final ViewportLayer viewportLayer;

    public ScrollStepCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ScrollStepCommand> getCommandClass() {
        return ScrollStepCommand.class;
    }

    @Override
    public boolean executeCommand(ScrollStepCommand command) {
        Direction direction = command.getDirection();
        ViewportLayerDim viewportDim = this.viewportLayer.getDim(direction.getOrientation());
        if (direction.isBackward()) {
            viewportDim.scrollBackwardByStep();
        } else {
            viewportDim.scrollForwardByStep();
        }
        return true;
    }
}

