/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.internal.rhelp.core.server.ServerREnvHelpAccess;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;

@NonNullByDefault
public class RHelpManagerIntern {
    private static final int HELP_LOADED = 2;
    private static final int HELP_AVAILABLE = 1;
    private static final int UNKNOWN = 0;
    private static final int HELP_MISSING = -1;
    private static final int RENV_DELETED = -2;
    protected final REnvManager rEnvManager;
    private final Object indexLock = new Object();
    private final Map<String, EnvItem> helpIndexes = new HashMap<String, EnvItem>();
    private final SerUtil serUtil = new SerUtil();
    private final CopyOnWriteIdentityListSet<RHelpManager.Listener> listeners = new CopyOnWriteIdentityListSet();

    private static @Nullable Object getStateLocation(REnvHelpConfiguration config) {
        switch (config.getStateSharedType()) {
            case "directory": {
                return config.getStateSharedDirectoryPath();
            }
            case "server": {
                return config.getStateSharedServerUri();
            }
        }
        return null;
    }

    private static boolean isConfigEqual(REnvHelpConfiguration config1, @Nullable REnvHelpConfiguration config2) {
        return config2 != null && config1.getStateSharedType() == config2.getStateSharedType() && Objects.equals(RHelpManagerIntern.getStateLocation(config1), RHelpManagerIntern.getStateLocation(config2));
    }

    private static boolean isEquals(@Nullable Throwable e1, @Nullable Throwable e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 != null && e2 != null) {
            return e1.getClass() == e2.getClass() && Objects.equals(e1.getMessage(), e2.getMessage()) && RHelpManagerIntern.isEquals(e1.getCause(), e2.getCause());
        }
        return false;
    }

    public RHelpManagerIntern(REnvManager rEnvManager) {
        this.rEnvManager = rEnvManager;
    }

    public @Nullable REnv getREnv(@Nullable String id) {
        return this.rEnvManager.get(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnvItem getItem(REnv rEnv) {
        Object object = this.indexLock;
        synchronized (object) {
            EnvItem item = this.helpIndexes.get(rEnv.getId());
            if (item == null) {
                item = new EnvItem(rEnv);
                this.helpIndexes.put(rEnv.getId(), item);
            }
            return item;
        }
    }

    private ImList<EnvItem> getItems() {
        return ImCollections.toList(this.helpIndexes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object beginIndexUpdate(REnv rEnv) {
        EnvItem item = this.getItem(rEnv);
        Object object = item.helpLock;
        synchronized (object) {
            block4: {
                if (!item.indexUpdate) break block4;
                return null;
            }
            item.indexUpdate = true;
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endIndexUpdate(Object lock) {
        EnvItem item = (EnvItem)lock;
        Object object = item.helpLock;
        synchronized (object) {
            item.indexUpdate = false;
        }
        RHelpManager.Event event = new RHelpManager.Event(2, item.rEnv);
        this.notifiyListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object beginIndexCheck(REnv rEnv) {
        EnvItem item = this.getItem(rEnv);
        Object object = item.helpLock;
        synchronized (object) {
            block4: {
                if (!item.indexCheck && !item.indexUpdate) break block4;
                return null;
            }
            item.indexCheck = true;
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endIndexCheck(Object lock) {
        EnvItem item = (EnvItem)lock;
        Object object = item.helpLock;
        synchronized (object) {
            item.indexCheck = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkREnvs() {
        ArrayList<EnvItem> items;
        ImList rEnvs = this.rEnvManager.list();
        Object object = this.indexLock;
        synchronized (object) {
            Iterator iterator = rEnvs.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    items = new ArrayList<EnvItem>(this.helpIndexes.values());
                    break;
                }
                REnv rEnv = (REnv)iterator.next();
                this.getItem(rEnv);
            }
        }
        for (EnvItem item : items) {
            REnvHelpImpl oldHelp = null;
            RHelpManager.Event event = null;
            try {
                Object object2 = item.helpLock;
                synchronized (object2) {
                    if (item.rEnv.isDeleted()) {
                        oldHelp = item.unset(-2);
                        event = new RHelpManager.Event(3, item.rEnv);
                    } else {
                        REnvHelpConfiguration rEnvConfig = (REnvHelpConfiguration)item.rEnv.get(REnvHelpConfiguration.class);
                        if (item.isConfigured()) {
                            if (item.isConfigEqual(rEnvConfig)) {
                                // MONITOREXIT @DISABLED, blocks:[16, 17, 1, 18, 2, 6, 11] lbl34 : MonitorExitStatement: MONITOREXIT : var7_7
                                if (oldHelp != null) {
                                    oldHelp.dispose();
                                }
                                if (event == null) continue;
                                this.notifiyListeners(event);
                                continue;
                            }
                            oldHelp = item.unset(0);
                        }
                        item.updateConfig(rEnvConfig);
                    }
                }
            }
            catch (Throwable throwable) {
                if (oldHelp != null) {
                    oldHelp.dispose();
                }
                if (event != null) {
                    this.notifiyListeners(event);
                }
                throw throwable;
            }
            if (oldHelp != null) {
                oldHelp.dispose();
            }
            if (event == null) continue;
            this.notifiyListeners(event);
        }
    }

    public boolean updateLocalHelp(final REnvHelpConfiguration rEnvConfig, @Nullable Map<String, String> rEnvSharedProperties, final REnvHelpImpl newHelp) {
        REnv rEnv = newHelp.getREnv();
        SerSaveController controller = new SerSaveController(this.getItem(rEnv), rEnvConfig){

            @Override
            public void onSaved() {
                EnvItem item = this.getItem();
                item.updateConfig(rEnvConfig);
                this.oldHelp = item.set(newHelp);
            }
        };
        try {
            this.serUtil.save(rEnvConfig, newHelp, (SerUtil.Controller)controller);
            return true;
        }
        finally {
            controller.dispose();
        }
    }

    public void updateServerHelp() {
        try {
            ServerClientSupport serverSupport = ServerClientSupport.getInstance();
            ImList<EnvItem> items = this.getItems();
            for (EnvItem item : items) {
                if (item.rEnv.isDeleted()) continue;
                this.updateServerHelp(item, serverSupport);
            }
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occured while updating R help data for R environments.", (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerHelp(EnvItem item, ServerClientSupport serverSupport) {
        block32: {
            long currentStamp;
            REnvHelpConfiguration rEnvConfig;
            Object object = item.helpLock;
            synchronized (object) {
                if (item.configStateType != "server") {
                    return;
                }
                rEnvConfig = (REnvHelpConfiguration)item.rEnv.get(REnvHelpConfiguration.class);
                if (rEnvConfig == null) {
                    return;
                }
                if (item.state == 0) {
                    item.updateLocalStamp(this.serUtil.getStamp(rEnvConfig));
                }
                currentStamp = item.localStamp;
            }
            RHelpManager.Event event = null;
            try {
                try {
                    ServerREnvHelpAccess serverAccess = serverSupport.getREnvHelpAccess(rEnvConfig);
                    if (!serverAccess.loadREnvHelpData(rEnvConfig, currentStamp, new SerSaveController(item, rEnvConfig))) break block32;
                    REnvHelpImpl newHelp = null;
                    REnvHelpImpl oldHelp = null;
                    try {
                        Object object2 = item.helpLock;
                        synchronized (object2) {
                            switch (item.state) {
                                case -2: {
                                    break;
                                }
                                case 2: {
                                    item.updateConfig(rEnvConfig);
                                    newHelp = this.serUtil.load(rEnvConfig);
                                    oldHelp = item.set(newHelp);
                                    event = new RHelpManager.Event(2, item.rEnv);
                                    break;
                                }
                                default: {
                                    item.updateLocalStamp(this.serUtil.getStamp(rEnvConfig));
                                    event = new RHelpManager.Event(2, item.rEnv);
                                }
                            }
                        }
                        if (newHelp != null) {
                            newHelp.setIndex(serverAccess);
                        }
                    }
                    finally {
                        if (oldHelp != null) {
                            oldHelp.dispose();
                        }
                    }
                    RHelpCoreInternals.log((Status)new InfoStatus("org.eclipse.statet.rhelp.core", String.format("Successfully updated R help data for R environment '%1$s'.", item.rEnv.getName())));
                }
                catch (Exception e) {
                    if (RHelpManagerIntern.isEquals(item.lastServerException, e)) {
                        if (event != null) {
                            this.notifiyListeners(event);
                        }
                        return;
                    }
                    item.lastServerException = e;
                    int severity = 4;
                    String message = null;
                    if (e instanceof StatusException) {
                        Status status = ((StatusException)((Object)e)).getStatus();
                        switch (status.getCode()) {
                            case 1002: {
                                severity = 1;
                                message = String.format("Updating R help data for R environment '%1$s' failed. It seems the R help server is currently not available.", item.rEnv.getName());
                                break;
                            }
                            default: {
                                severity = status.getSeverity();
                            }
                        }
                    }
                    RHelpCoreInternals.log(Status.newStatus((int)severity, (String)"org.eclipse.statet.rhelp.core", message != null ? message : String.format("An error occured when updating R help data for R environment '%1$s'.", item.rEnv.getName()), (Throwable)e));
                    if (event != null) {
                        this.notifiyListeners(event);
                    }
                }
            }
            finally {
                if (event != null) {
                    this.notifiyListeners(event);
                }
            }
        }
    }

    public List<REnv> getREnvWithHelpIntern() {
        ImList<EnvItem> items = this.getItems();
        ArrayList<REnv> withHelp = new ArrayList<REnv>(items.size());
        for (EnvItem item : items) {
            if (item.rEnv.isDeleted() || !this.hasHelp(item)) continue;
            withHelp.add(item.rEnv);
        }
        return withHelp;
    }

    public boolean hasHelpIntern(REnv rEnv) {
        if (rEnv.isDeleted()) {
            return false;
        }
        EnvItem item = this.getItem(rEnv);
        return this.hasHelp(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasHelp(EnvItem item) {
        Object object = item.helpLock;
        synchronized (object) {
            if (item.state == 0) {
                REnvHelpConfiguration rEnvConfig = (REnvHelpConfiguration)item.rEnv.get(REnvHelpConfiguration.class);
                item.updateLocalStamp(rEnvConfig != null ? this.serUtil.getStamp(rEnvConfig) : 0L);
            }
            switch (item.state) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable REnvHelpImpl getHelpIntern(REnv rEnv) {
        EnvItem item = this.getItem(rEnv);
        Object object = item.helpLock;
        synchronized (object) {
            switch (item.state) {
                case 2: {
                    item.help.lock();
                    return item.help;
                }
                case 0: 
                case 1: {
                    REnvHelpConfiguration rEnvConfig = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class);
                    if (rEnvConfig != null) {
                        item.updateConfig(rEnvConfig);
                        item.set(this.serUtil.load(rEnvConfig));
                    }
                    if (item.help != null) {
                        item.help.lock();
                        return item.help;
                    }
                    return null;
                }
            }
            return null;
        }
    }

    public void addListener(RHelpManager.Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(RHelpManager.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifiyListeners(RHelpManager.Event event) {
        for (RHelpManager.Listener listener : this.listeners) {
            try {
                listener.onRHelpChanged(event);
            }
            catch (Exception e) {
                RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when notifying an R help manager listener.", (Throwable)e));
            }
        }
    }

    private static class EnvItem {
        final REnv rEnv;
        int state;
        long localStamp;
        @Nullable REnvHelpImpl help;
        private String configStateType;
        private @Nullable Object configStateLocation;
        final Object helpLock = new Object();
        boolean indexUpdate;
        boolean indexCheck;
        @Nullable Throwable lastServerException;

        public EnvItem(REnv rEnv) {
            this.rEnv = rEnv;
            this.updateConfig(null);
            this.unset(rEnv.isDeleted() ? -2 : 0);
        }

        public boolean isConfigured() {
            return this.state == 2 || this.state == -1;
        }

        public void updateConfig(@Nullable REnvHelpConfiguration config) {
            Object newStateLocation;
            String newStateType;
            if (config != null) {
                newStateType = config.getStateSharedType();
                newStateLocation = RHelpManagerIntern.getStateLocation(config);
            } else {
                newStateType = "";
                newStateLocation = null;
            }
            if (newStateType != this.configStateType || !Objects.equals(newStateLocation, this.configStateLocation)) {
                this.configStateType = newStateType;
                this.configStateLocation = newStateLocation;
                this.lastServerException = null;
            }
        }

        public void updateLocalStamp(long stamp) {
            assert (this.help == null);
            this.state = stamp != 0L ? 1 : -1;
            this.localStamp = stamp;
        }

        public @Nullable REnvHelpImpl set(@Nullable REnvHelpImpl help) {
            if (help == null) {
                return this.unset(-1);
            }
            REnvHelpImpl oldHelp = this.help;
            this.state = 2;
            this.localStamp = help.getStamp();
            this.help = help;
            return oldHelp;
        }

        public @Nullable REnvHelpImpl unset(int state) {
            REnvHelpImpl oldHelp = this.help;
            this.state = state;
            this.localStamp = 0L;
            this.help = null;
            return oldHelp;
        }

        public boolean isConfigEqual(@Nullable REnvHelpConfiguration config) {
            return config != null && this.configStateType == config.getStateSharedType() && Objects.equals(this.configStateLocation, RHelpManagerIntern.getStateLocation(config));
        }
    }

    private static class SerSaveController
    implements SerUtil.Controller {
        private final EnvItem item;
        private final REnvHelpConfiguration rEnvConfig;
        protected @Nullable REnvHelpImpl oldHelp;

        public SerSaveController(EnvItem item, REnvHelpConfiguration rEnvConfig) {
            this.item = item;
            this.rEnvConfig = rEnvConfig;
        }

        public EnvItem getItem() {
            return this.item;
        }

        @Override
        public Object getFileLock() {
            return this.item.helpLock;
        }

        @Override
        public boolean shouldSave() {
            return this.item.state != -2 && RHelpManagerIntern.isConfigEqual(this.rEnvConfig, (REnvHelpConfiguration)this.item.rEnv.get(REnvHelpConfiguration.class));
        }

        @Override
        public void onSaved() {
        }

        public void dispose() {
            if (this.oldHelp != null) {
                this.oldHelp.dispose();
            }
        }
    }
}

