/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.net.core.sshd.util;

import java.util.Collection;
import org.apache.sshd.common.AttributeRepository;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class ChainingAttributes
implements AttributeRepository {
    private final AttributeRepository delegate;
    private final AttributeRepository parent;

    public ChainingAttributes(AttributeRepository delegate, AttributeRepository parent) {
        this.delegate = delegate;
        this.parent = parent;
    }

    public int getAttributesCount() {
        return this.delegate.getAttributesCount();
    }

    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.delegate.attributeKeys();
    }

    public <T> @Nullable T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.delegate.getAttribute((AttributeRepository.AttributeKey)ObjectUtils.nonNullAssert(key));
    }

    public <T> @Nullable T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        T value = this.getAttribute((AttributeRepository.AttributeKey)ObjectUtils.nonNullAssert(key));
        if (value == null) {
            return (T)this.parent.getAttribute(key);
        }
        return value;
    }
}

