/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.debug.core.sourcelookup.RLibrarySourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@NonNullByDefault
public class RLibrarySourceContainerTypeDelegate
extends AbstractSourceContainerTypeDelegate {
    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if ("org.eclipse.statet.r.debugSourceContainers.RLibraryType".equals(element.getNodeName())) {
                String path = element.getAttribute("path");
                if (path == null || path.isEmpty()) {
                    this.abort(Messages.RLibrarySourceContainer_error_InvalidConfiguration_message, null);
                }
                return new RLibrarySourceContainer(path);
            }
            this.abort(Messages.RLibrarySourceContainer_error_InvalidConfiguration_message, null);
        }
        this.abort(Messages.RLibrarySourceContainer_error_InvalidConfiguration_message, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        RLibrarySourceContainer rLibraryContainer = (RLibrarySourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement("org.eclipse.statet.r.debugSourceContainers.RLibraryType");
        element.setAttribute("path", rLibraryContainer.getLocation());
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

