/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
final class AutoIdMap<E> {
    private @Nullable Object[] currentArray = new Object[16];

    public synchronized int put(@NonNull E e) {
        int size = this.currentArray.length;
        int i = 1;
        while (i < size) {
            if (this.currentArray[i] == null) {
                this.currentArray[i] = e;
                return i;
            }
            ++i;
        }
        this.currentArray = Arrays.copyOf(this.currentArray, size + 16);
        this.currentArray[size] = e;
        return size;
    }

    public synchronized void remove(int id) {
        if (id > 0 && id < this.currentArray.length) {
            this.currentArray[id] = null;
        }
    }

    public E get(int id) {
        return (E)this.currentArray[id];
    }
}

