/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RJIOExternalizable;
import org.eclipse.statet.rj.server.dbg.Tracepoint;

@NonNullByDefault
public class TracepointEvent
implements Tracepoint,
RJIOExternalizable {
    public static final byte KIND_ABOUT_TO_HIT = 1;
    public static final byte KIND_INSTALLED = 16;
    public static final byte KIND_UNINSTALLED = 32;
    private final byte kind;
    private final int type;
    private final @Nullable String filePath;
    private final long id;
    private final String elementId;
    private final @Nullable String label;
    private final int flags;

    public TracepointEvent(byte kind, int type, @Nullable String filePath, long id, String elementId, @Nullable String label, int flags) {
        this.kind = kind;
        this.type = type;
        this.filePath = filePath;
        this.id = id;
        this.elementId = elementId;
        this.label = label;
        this.flags = flags;
    }

    public TracepointEvent(RJIO io) throws IOException {
        this.kind = io.readByte();
        this.type = io.readInt();
        this.filePath = io.readString();
        this.id = io.readLong();
        this.elementId = io.readString();
        this.label = io.readString();
        this.flags = io.readInt();
    }

    public void writeExternal(RJIO io) throws IOException {
        io.writeByte(this.kind);
        io.writeInt(this.type);
        io.writeString(this.filePath);
        io.writeLong(this.id);
        io.writeString(this.elementId);
        io.writeString(this.label);
        io.writeInt(this.flags);
    }

    public byte getKind() {
        return this.kind;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public @Nullable String getFilePath() {
        return this.filePath;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.elementId;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public int getFlags() {
        return this.flags;
    }
}

