/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class SimpleNamePassAuthMethod
extends ServerAuthMethod {
    private Map<String, byte[]> users = (Map)ObjectUtils.nonNullLateInit();
    private byte[] digestSash = (byte[])ObjectUtils.nonNullLateInit();
    private MessageDigest digestService = (MessageDigest)ObjectUtils.nonNullLateInit();
    private Charset digestCharset = (Charset)ObjectUtils.nonNullLateInit();

    public SimpleNamePassAuthMethod() {
        super("name-pass", true);
    }

    @Override
    public void doInit(@Nullable String arg) throws RjException {
        ServerUtils.ArgKeyValue config = ServerUtils.getArgConfigValue(arg);
        try {
            this.digestSash = new byte[8];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.digestSash);
            this.digestService = MessageDigest.getInstance("SHA-512");
            this.digestCharset = StandardCharsets.UTF_8;
        }
        catch (Exception e) {
            throw new RjException("", e);
        }
        Properties read = new Properties();
        if (config.getKey().equals("file")) {
            String fileName = config.getValue();
            if (fileName == null || fileName.isEmpty()) {
                throw new RjException("Missing password file name.", null);
            }
            File file = new File(fileName);
            try {
                read.load(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RjException("Reading password file failed.", null);
            }
        } else {
            throw new RjException(String.format("Unsupported configuration type '%1$s'.", config.getKey()));
        }
        this.digestService.update(this.digestSash);
        this.users = new HashMap<String, byte[]>();
        for (Map.Entry<Object, Object> entry : read.entrySet()) {
            String username = (String)ObjectUtils.nonNullAssert((Object)((String)entry.getKey()));
            byte[] password = this.digestService.digest(this.digestCharset.encode((String)ObjectUtils.nonNullAssert((Object)((String)entry.getValue()))).array());
            this.users.put(username, password);
        }
    }

    @Override
    protected ImList<Callback> doCreateLogin() throws RjException {
        return ImCollections.newList((Object[])new Callback[]{new NameCallback("Loginname"), new PasswordCallback("Password", false)});
    }

    @Override
    protected String doPerformLogin(ImList<Callback> callbacks) throws LoginException, RjException {
        byte[] loginPassword;
        byte[] object;
        String loginName = ((NameCallback)callbacks.get(0)).getName();
        if (loginName != null && (object = this.users.get(loginName)) instanceof byte[] && Arrays.equals(object, loginPassword = this.getPass((PasswordCallback)callbacks.get(1)))) {
            return loginName;
        }
        throw new FailedLoginException("Invalid loginname or password");
    }

    private byte[] getPass(PasswordCallback callback) {
        char[] loginPassword = callback.getPassword();
        if (loginPassword == null) {
            return new byte[0];
        }
        this.digestService.update(this.digestSash);
        byte[] loginBytes = this.digestService.digest(this.digestCharset.encode(CharBuffer.wrap(loginPassword)).array());
        callback.clearPassword();
        Arrays.fill(loginPassword, '\u0000');
        return loginBytes;
    }
}

