/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.statet.internal.r.core.rmodel.AnonymousAccess;
import org.eclipse.statet.internal.r.core.rmodel.BasicPackageReferences;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.rmodel.CompositeSourceElement;
import org.eclipse.statet.internal.r.core.rmodel.ElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.EmbeddedRBuildElement;
import org.eclipse.statet.internal.r.core.rmodel.RSourceElementByElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.RSourceUnitElement;
import org.eclipse.statet.internal.r.core.rmodel.RSourceUnitModelInfoImpl;
import org.eclipse.statet.internal.r.core.rmodel.RoxygenAnalyzeContext;
import org.eclipse.statet.internal.r.core.rmodel.RoxygenAnalyzer;
import org.eclipse.statet.internal.r.core.rmodel.RoxygenRCodeElement;
import org.eclipse.statet.internal.r.core.rmodel.SubIndexedDElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.SubIndexedSElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.SubNamedPartSyntacticElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.SubNamedSlotSemanticElementAccess;
import org.eclipse.statet.internal.r.core.rmodel.SubNamedSlotSyntacticElementAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.r.core.rmodel.Parameters;
import org.eclipse.statet.r.core.rmodel.ParametersBuilder;
import org.eclipse.statet.r.core.rmodel.PlaceholderDetail;
import org.eclipse.statet.r.core.rmodel.RCoreFunctions;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceFrame;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Arithmetic;
import org.eclipse.statet.r.core.source.ast.Assignment;
import org.eclipse.statet.r.core.source.ast.CForLoop;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.CLoopCommand;
import org.eclipse.statet.r.core.source.ast.CRepeatLoop;
import org.eclipse.statet.r.core.source.ast.CWhileLoop;
import org.eclipse.statet.r.core.source.ast.DocuTag;
import org.eclipse.statet.r.core.source.ast.Dummy;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.Help;
import org.eclipse.statet.r.core.source.ast.Logical;
import org.eclipse.statet.r.core.source.ast.Model;
import org.eclipse.statet.r.core.source.ast.NSGet;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.NullConst;
import org.eclipse.statet.r.core.source.ast.NumberConst;
import org.eclipse.statet.r.core.source.ast.Pipe;
import org.eclipse.statet.r.core.source.ast.Placeholder;
import org.eclipse.statet.r.core.source.ast.Power;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.ast.Relational;
import org.eclipse.statet.r.core.source.ast.Seq;
import org.eclipse.statet.r.core.source.ast.Sign;
import org.eclipse.statet.r.core.source.ast.SourceComponent;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.core.source.ast.StringConst;
import org.eclipse.statet.r.core.source.ast.SubIndexed;
import org.eclipse.statet.r.core.source.ast.SubNamed;
import org.eclipse.statet.r.core.source.ast.Symbol;

@NonNullByDefault
public class SourceAnalyzer
extends RAstVisitor {
    private static final int S_GLOBAL = 0;
    private static final int S_LOCAL = 1;
    private static final int S_SEARCH = 2;
    private static final int RETURN_SOURCE_CONTAINTER = 1;
    private static final int RETURN_METHOD_SIGNATURE = 2;
    private static final int RETURN_STRING_ARRAY = 3;
    private static final int REG_CLASS_REPRESENTATION = 4;
    private static final int REG_CLASS_PROTOTYPE = 5;
    private static final int[] NO_REQUESTS = new int[0];
    private static final int[] STRING_ARRAY_REQUEST = new int[]{3};
    private static final int[] SIGNATURE_REQUESTS = new int[]{2, 3};
    private static final int[] REPRESENTATION_REQUEST = new int[]{4};
    private static final int[] PROTOTYPE_REQUEST = new int[]{5};
    private static final Integer FIRST = 0;
    private static final ImList<RAstNode> NO_NODES = ImCollections.emptyList();
    private static final Comparator<SourceStructElement> SOURCEELEMENT_SORTER = new Comparator<SourceStructElement>(){

        @Override
        public int compare(SourceStructElement e1, SourceStructElement e2) {
            return e1.getSourceRange().getStartOffset() - e2.getSourceRange().getStartOffset();
        }
    };
    private RSourceUnit sourceUnit = (RSourceUnit)ObjectUtils.nonNullLateInit();
    private AstInfo ast = (AstInfo)ObjectUtils.nonNullLateInit();
    private @Nullable List<EmbeddedRBuildElement> chunkElements;
    private @Nullable List<EmbeddedRBuildElement> inlineElements;
    private int anonymCount;
    private final ArrayList<String> idComponents = new ArrayList(32);
    private LinkedHashMap<String, BuildSourceFrame> frames;
    private Map<String, BuildSourceFrame> dependencyEnvironments;
    private final ArrayList<BuildSourceFrame> currentEnvironments = new ArrayList(32);
    private BuildSourceFrame globalEnvir;
    private BuildSourceFrame genericDefaultEnvir;
    private BuildSourceFrame topLevelEnvir;
    private BuildSourceFrame topScope;
    private BasicPackageReferences packageRefs;
    private final LinkedList<RAstNode> argValueToIgnore = new LinkedList();
    private int[] request = NO_REQUESTS;
    private @Nullable Object returnValue;
    private final ArrayList<SourceElementBuilder> sourceContainerBuilders = new ArrayList();
    private SourceElementBuilder currentSourceContainerBuilder;
    private RCoreFunctions configuredRDef;
    private final Map<String, FCallAnalyzer> fCallAnalyzers = new HashMap<String, FCallAnalyzer>();
    private FCallAnalyzer fCallFallback;
    private final FCallAnalyzer fCallNoAnalysis = new FCallAnalyzer(){

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    };
    private final RoxygenAnalyzer roxygenAnalyzer;
    private final RoxygenAdapter roxygenAdapter;
    private boolean roxygenExamples;
    private final HashMap<String, Integer> commonNames = new HashMap();
    private final HashMap<String, Integer> classNames = new HashMap();
    private final HashMap<String, Integer> importNames = new HashMap();

    public SourceAnalyzer() {
        this.configure(RCoreFunctions.DEFAULT);
        this.roxygenAnalyzer = new RoxygenAnalyzer();
        this.roxygenAdapter = new RoxygenAdapter();
    }

    public void configure(RCoreFunctions rdef) {
        this.configuredRDef = rdef;
        this.fCallAnalyzers.clear();
        this.fCallAnalyzers.put("assign", new BaseAssign(rdef));
        FCallAnalyzer analyzer = new BaseRemove(rdef);
        this.fCallAnalyzers.put("remove", analyzer);
        this.fCallAnalyzers.put("rm", analyzer);
        this.fCallAnalyzers.put("exists", new BaseExists(rdef));
        this.fCallAnalyzers.put("get", new BaseGet(rdef));
        this.fCallAnalyzers.put("save", new BaseSave(rdef));
        this.fCallAnalyzers.put("call", new BaseCall(rdef));
        this.fCallAnalyzers.put("do.call", new BaseDoCall(rdef));
        this.fCallAnalyzers.put("library", new BaseLibrary(rdef));
        this.fCallAnalyzers.put("require", new BaseRequire(rdef));
        this.fCallAnalyzers.put("globalenv", new BaseGlobalenv(rdef));
        this.fCallAnalyzers.put("topenv", new BaseTopenv(rdef));
        this.fCallAnalyzers.put("c", new BaseC(rdef));
        this.fCallAnalyzers.put("setGeneric", new MethodsSetGeneric(rdef));
        this.fCallAnalyzers.put("setGroupGeneric", new MethodsSetGroupGeneric(rdef));
        this.fCallAnalyzers.put("removeGeneric", new MethodsRemoveGeneric(rdef));
        this.fCallAnalyzers.put("signature", new MethodsSignature(rdef));
        this.fCallAnalyzers.put("setClass", new MethodsSetClass(rdef));
        this.fCallAnalyzers.put("setClassUnion", new MethodsSetClassUnion(rdef));
        this.fCallAnalyzers.put("representation", new MethodsRepresentation(rdef));
        this.fCallAnalyzers.put("prototype", new MethodsPrototype(rdef));
        this.fCallAnalyzers.put("setIs", new MethodsSetIs(rdef));
        this.fCallAnalyzers.put("removeClass", new MethodsRemoveClass(rdef));
        this.fCallAnalyzers.put("resetClass", this.fCallNoAnalysis);
        this.fCallAnalyzers.put("setAs", new MethodsSetAs(rdef));
        this.fCallAnalyzers.put("setValidity", new MethodsSetValidity(rdef));
        this.fCallAnalyzers.put("getClass", new MethodsGetClass(rdef));
        this.fCallAnalyzers.put("getClassDef", new MethodsGetClassDef(rdef));
        this.fCallAnalyzers.put("findClass", new MethodsFindClass(rdef));
        this.fCallAnalyzers.put("new", new MethodsNew(rdef));
        this.fCallAnalyzers.put("as", new MethodsAs(rdef));
        this.fCallAnalyzers.put("setMethod", new MethodsSetMethod(rdef));
        this.fCallAnalyzers.put("removeMethod", new MethodsRemoveMethod(rdef));
        this.fCallAnalyzers.put("removeMethods", new MethodsRemoveMethods(rdef));
        this.fCallAnalyzers.put("getMethod", new MethodsGetMethod(rdef));
        this.fCallAnalyzers.put("selectMethod", new MethodsSelectMethod(rdef));
        this.fCallAnalyzers.put("getMethods", new MethodsGetMethods(rdef));
        this.fCallAnalyzers.put("findMethod", new MethodsFindMethod(rdef));
        analyzer = new MethodsSlot(rdef);
        this.fCallAnalyzers.put("slot", analyzer);
        this.fCallAnalyzers.put("slot<-", analyzer);
        for (String name : rdef.getKnownFunctions()) {
            if (this.fCallAnalyzers.containsKey(name)) continue;
            this.fCallAnalyzers.put(name, new CommonDefBased(rdef.getParameters(name)));
        }
        this.fCallFallback = new NoDefFallback();
    }

    public @Nullable RSourceUnitModelInfo createModel(RSourceUnit u, AstInfo ast) {
        if (!(ast.getRoot() instanceof SourceComponent)) {
            throw new IllegalArgumentException("ast");
        }
        SourceComponent root = (SourceComponent)ast.getRoot();
        this.anonymCount = 0;
        this.sourceUnit = u;
        try {
            this.init();
            RSourceUnitElement fileElement = new RSourceUnitElement(this.sourceUnit, ast.getStamp(), this.topLevelEnvir, root);
            this.enterElement(fileElement, this.topLevelEnvir, root);
            root.acceptInRChildren(this);
            this.leaveElement();
            this.finish();
            this.ast = new AstInfo(4, ast);
            RSourceUnitModelInfoImpl modelInfo = new RSourceUnitModelInfoImpl(this.ast, this.frames, this.topLevelEnvir, this.packageRefs, this.dependencyEnvironments, fileElement);
            this.roxygenExamples = false;
            this.roxygenAdapter.update(modelInfo);
            if (this.roxygenExamples) {
                BuildSourceFrame.ElementAccessList modelList;
                BuildSourceFrame.ElementAccessList docuList;
                String name;
                Map.Entry<String, BuildSourceFrame.ElementAccessList> entry;
                this.finish();
                Iterator<Map.Entry<@Nullable String, BuildSourceFrame.ElementAccessList>> iter = this.topLevelEnvir.data.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    name = entry.getKey();
                    docuList = entry.getValue();
                    if (docuList.isCreated != 0) continue;
                    iter.remove();
                    modelList = modelInfo.topFrame.data.get(name);
                    if (modelList != null) {
                        for (ElementAccess access : docuList.entries) {
                            access.shared = modelList;
                        }
                        modelList.entries.addAll(docuList.entries);
                        continue;
                    }
                    docuList.frame = modelInfo.topFrame;
                    modelInfo.topFrame.data.put(name, docuList);
                }
                iter = this.packageRefs.data.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    name = entry.getKey();
                    docuList = entry.getValue();
                    if (docuList.isCreated != 0) continue;
                    iter.remove();
                    modelList = modelInfo.packageRefs.data.get(name);
                    if (modelList != null) {
                        for (ElementAccess access : docuList.entries) {
                            access.shared = modelList;
                        }
                        modelList.entries.addAll(docuList.entries);
                        continue;
                    }
                    docuList.frame = modelInfo.topFrame;
                    modelInfo.packageRefs.data.put(name, docuList);
                }
            }
            RSourceUnitModelInfoImpl rSourceUnitModelInfoImpl = modelInfo;
            return rSourceUnitModelInfoImpl;
        }
        catch (InvocationTargetException | OperationCanceledException throwable) {
        }
        finally {
            this.cleanup();
            this.sourceUnit = null;
        }
        return null;
    }

    public void beginChunkSession(RSourceUnit sourceUnit, AstInfo ast) {
        this.anonymCount = 0;
        this.sourceUnit = sourceUnit;
        this.ast = ast;
        if (this.chunkElements == null) {
            this.chunkElements = new ArrayList<EmbeddedRBuildElement>();
            this.inlineElements = new ArrayList<EmbeddedRBuildElement>();
        }
        this.init();
    }

    public void processChunk(EmbeddedRBuildElement element, List<SourceComponent> sourceComponents) {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        try {
            chunkElements.add(element);
            for (SourceComponent sourceComponent : sourceComponents) {
                element.envir = this.topLevelEnvir;
                this.enterElement(element, this.topLevelEnvir, sourceComponent);
                sourceComponent.acceptInRChildren(this);
                this.leaveElement();
            }
        }
        catch (InvocationTargetException | OperationCanceledException throwable) {
            // empty catch block
        }
    }

    public void processInlineNode(EmbeddedRBuildElement element, SourceComponent sourceComponent) {
        List inlineElements = (List)ObjectUtils.nonNullAssert(this.inlineElements);
        try {
            inlineElements.add(element);
            element.envir = this.topLevelEnvir;
            this.enterElement(element, this.topLevelEnvir, sourceComponent);
            sourceComponent.acceptInRChildren(this);
            this.leaveElement();
        }
        catch (InvocationTargetException | OperationCanceledException throwable) {
            // empty catch block
        }
    }

    public RSourceUnitModelInfo stopChunkSession() {
        List chunkElements = (List)ObjectUtils.nonNullAssert(this.chunkElements);
        List inlineElements = (List)ObjectUtils.nonNullAssert(this.inlineElements);
        try {
            this.finish();
            CompositeSourceElement compositeElement = new CompositeSourceElement(this.sourceUnit, this.ast.getStamp(), this.topLevelEnvir, chunkElements, (TextRegion)this.ast.getRoot());
            RSourceUnitModelInfoImpl rSourceUnitModelInfoImpl = new RSourceUnitModelInfoImpl(this.ast, this.frames, this.topLevelEnvir, this.packageRefs, this.dependencyEnvironments, compositeElement);
            return rSourceUnitModelInfoImpl;
        }
        finally {
            this.cleanup();
            this.sourceUnit = null;
            chunkElements.clear();
            inlineElements.clear();
        }
    }

    private void init() {
        this.frames = new LinkedHashMap();
        this.dependencyEnvironments = new HashMap<String, BuildSourceFrame>();
        String projId = this.sourceUnit instanceof WorkspaceSourceUnit ? ((WorkspaceSourceUnit)this.sourceUnit).getResource().getProject().getName() : "<noproject:" + this.sourceUnit.getElementName();
        BuildSourceFrame.DefScope fileEnvir = new BuildSourceFrame.DefScope(1, BuildSourceFrame.createId(1, projId, 0), null, new BuildSourceFrame[0]);
        this.currentEnvironments.add(fileEnvir);
        this.topLevelEnvir = this.globalEnvir = fileEnvir;
        this.genericDefaultEnvir = this.globalEnvir;
        this.packageRefs = new BasicPackageReferences();
        this.topScope = this.currentEnvironments.get(this.currentEnvironments.size() - 1);
        this.idComponents.add(projId);
    }

    private void finish() {
        for (BuildSourceFrame si : this.dependencyEnvironments.values()) {
            si.runLateResolve(false);
        }
        this.topLevelEnvir.parents = ImCollections.concatList(this.dependencyEnvironments.values(), this.topLevelEnvir.parents);
        for (BuildSourceFrame si : this.frames.values()) {
            si.runLateResolve(false);
        }
        HashMap<String, Integer> commonNames = this.commonNames;
        HashMap<String, Integer> classNames = this.classNames;
        HashMap<String, Integer> importNames = this.importNames;
        int anonymous = 0;
        try {
            for (SourceElementBuilder seb : this.sourceContainerBuilders) {
                String name;
                if (seb.element.getElementName() == null && seb.element instanceof RSourceElementByElementAccess.RMethod) {
                    RSourceElementByElementAccess element = (RSourceElementByElementAccess.RMethod)seb.element;
                    ((RSourceElementByElementAccess.RMethod)element).occurrenceCount = anonymous++;
                    this.registerAnonFunctionElement((RSourceElementByElementAccess.RMethod)element, seb.envir);
                }
                for (RSourceElementByElementAccess element : seb.children) {
                    HashMap<String, Integer> names;
                    name = element.getElementName().getDisplayName();
                    switch (element.type & 0xF00) {
                        case 1024: {
                            names = classNames;
                            break;
                        }
                        case 768: {
                            names = importNames;
                            break;
                        }
                        default: {
                            names = commonNames;
                        }
                    }
                    Integer occ = names.get(name);
                    if (occ == null) {
                        names.put(name, FIRST);
                        continue;
                    }
                    element.occurrenceCount = occ + 1;
                    names.put(name, element.occurrenceCount);
                }
                for (ElementAccess access : seb.toCheck) {
                    if (seb.envir != access.getFrame() || (name = access.getSegmentName()) == null || commonNames.containsKey(name)) continue;
                    commonNames.put(name, FIRST);
                    seb.children.add(new RSourceElementByElementAccess.RVariable(seb.element, seb.envir != this.topLevelEnvir ? 1553 : 1552, access));
                }
                Object[] finalChildren = seb.children.toArray(new RSourceElementByElementAccess[seb.children.size()]);
                Arrays.sort(finalChildren, SOURCEELEMENT_SORTER);
                if (finalChildren.length > 0) {
                    seb.element.setSourceChildren((List<? extends RLangSourceElement>)ImCollections.newList((Object[])finalChildren));
                }
                commonNames.clear();
                classNames.clear();
                importNames.clear();
            }
            if (this.chunkElements != null) {
                Integer occ;
                String name;
                HashMap<String, Integer> names = commonNames;
                for (EmbeddedRBuildElement element : this.chunkElements) {
                    name = element.getElementName().getDisplayName();
                    occ = names.get(name);
                    if (occ == null) {
                        names.put(name, FIRST);
                        continue;
                    }
                    element.occurrenceCount = occ + 1;
                    names.put(name, element.occurrenceCount);
                }
                for (EmbeddedRBuildElement element : this.inlineElements) {
                    name = element.getElementName().getDisplayName();
                    occ = names.get(name);
                    if (occ == null) {
                        names.put(name, FIRST);
                        continue;
                    }
                    element.occurrenceCount = occ + 1;
                    names.put(name, element.occurrenceCount);
                }
            }
        }
        finally {
            commonNames.clear();
            classNames.clear();
            importNames.clear();
        }
    }

    private void cleanup() {
        this.clean(this.currentEnvironments);
        this.clean(this.idComponents);
        this.argValueToIgnore.clear();
        this.clean(this.sourceContainerBuilders);
        this.ast = null;
        this.genericDefaultEnvir = null;
        this.globalEnvir = null;
        this.packageRefs = null;
        this.topLevelEnvir = null;
        this.frames = null;
        this.dependencyEnvironments = null;
        this.returnValue = null;
        this.currentSourceContainerBuilder = null;
    }

    private void clean(ArrayList<?> list) {
        if (list.size() > 2048) {
            list.clear();
            list.trimToSize();
            list.ensureCapacity(1024);
        } else {
            list.clear();
        }
    }

    private BuildSourceFrame getPkgEnvir(String name) {
        String id;
        BuildSourceFrame envir;
        if ((envir = this.dependencyEnvironments.get(id = BuildSourceFrame.createId(2, name, ++this.anonymCount))) == null) {
            envir = new BuildSourceFrame.DefScope(2, id, name, new BuildSourceFrame[0]);
            this.dependencyEnvironments.put(id, envir);
        }
        return envir;
    }

    private @Nullable SourceElementBuilder getCurrentSourceContainerBuilder() {
        return this.currentSourceContainerBuilder;
    }

    private @Nullable SourceElementBuilder getCurrentSourceContainerBuilder(int type) {
        SourceElementBuilder containerBuilder = this.currentSourceContainerBuilder;
        return containerBuilder != null && (type == 0 || containerBuilder.element.getElementType() == type) ? containerBuilder : null;
    }

    private void registerInEnvir(int search, String name, ElementAccess access) {
        if (access.shared != null) {
            return;
        }
        switch (search) {
            case 1: {
                this.topScope.add(name, access);
                return;
            }
            case 0: {
                this.globalEnvir.add(name, access);
                return;
            }
            case 2: {
                this.topScope.addLateResolve(name, access);
                return;
            }
        }
        throw new IllegalArgumentException("Illegal mode");
    }

    private ElementAccess registerSimpleClassAccessInEnvir(RAstNode refNode, RAstNode nameNode) {
        ElementAccess.Class access = new ElementAccess.Class(refNode);
        access.flags = 0;
        access.nameNode = nameNode;
        this.genericDefaultEnvir.addClass(nameNode.getText(), access);
        return access;
    }

    protected final void enterElement(BuildSourceFrameElement element, BuildSourceFrame envir, RAstNode node) {
        SourceElementBuilder containerBuilder = new SourceElementBuilder(element, this.currentSourceContainerBuilder, envir);
        envir.addFrameElement(element);
        this.frames.put(envir.getFrameId(), envir);
        node.addAttachment(envir);
        this.currentSourceContainerBuilder = containerBuilder;
        this.sourceContainerBuilders.add(containerBuilder);
    }

    protected final void addEnvirInsteadOfElement(BuildSourceFrame envir, RAstNode node) {
        this.frames.put(envir.getFrameId(), envir);
        node.addAttachment(envir);
    }

    protected final void leaveElement() {
        this.currentSourceContainerBuilder = this.currentSourceContainerBuilder.parent;
    }

    private @Nullable Object registerSourceElement(@Nullable Object value, ElementAccess access) {
        if (value instanceof RSourceElementByElementAccess) {
            RSourceElementByElementAccess element = (RSourceElementByElementAccess)value;
            if ((element.getElementType() & 0xF00) == 1280) {
                this.registerFunctionElement((RSourceElementByElementAccess.RMethod)value, element.getElementType(), access, null);
                return null;
            }
            element.setAccess(access);
            this.currentSourceContainerBuilder.children.add(element);
            access.getNode().addAttachment(element);
            return null;
        }
        if (access.getSegmentName() != null && access.getType() == 17 && access.nextSegment == null) {
            this.currentSourceContainerBuilder.toCheck.add(access);
        }
        return value;
    }

    private void registerAnonFunctionElement(RSourceElementByElementAccess.RMethod rMethod, RFrame<RLangSourceElement> frame) {
        AnonymousAccess access = new AnonymousAccess(rMethod.getFDefNode(), frame);
        rMethod.complete(access, SourceAnalyzer.createFParameters(rMethod.getFDefNode(), null));
        access.getNode().addAttachment(rMethod);
    }

    private void registerFunctionElement(RSourceElementByElementAccess.RMethod rMethod, int type, ElementAccess access, @Nullable Signature sig) {
        RFrame frame;
        if (rMethod.getElementType() == 1296 && (frame = access.getFrame()) != null && (frame.getFrameType() == 5 || frame.getFrameType() == 6)) {
            type |= 1;
        }
        rMethod.complete(type, access, SourceAnalyzer.createFParameters(rMethod.getFDefNode(), sig));
        if (sig != null) {
            ElementAccess[] argNameAccesses = sig.argNameAccesses;
            if (sig.argNameAccesses != null) {
                BuildSourceFrame buildFrame = rMethod.getBuildFrame();
                int i = 0;
                while (i < argNameAccesses.length) {
                    ElementAccess argNameAccess = argNameAccesses[i];
                    if (argNameAccess != null) {
                        buildFrame.add(argNameAccess.nameNode.getText(), argNameAccess);
                    }
                    ++i;
                }
            }
        }
        access.flags |= 0x10;
        this.currentSourceContainerBuilder.children.add(rMethod);
        access.getNode().addAttachment(rMethod);
    }

    private void registerFunctionElement(RSourceElementByElementAccess.RMethod rMethod) {
        this.currentSourceContainerBuilder.children.add(rMethod);
        rMethod.getAccess().getNode().addAttachment(rMethod);
    }

    private void registerClassElement(RSourceElementByElementAccess.RClass rClass) {
        this.currentSourceContainerBuilder.children.add(rClass);
        rClass.getAccess().getNode().addAttachment(rClass);
    }

    private void registerClassExtElement(RSourceElementByElementAccess.RClassExt rClassExt) {
        this.currentSourceContainerBuilder.children.add(rClassExt);
        rClassExt.getAccess().getNode().addAttachment(rClassExt);
    }

    private boolean isRequested(int requestId) {
        int i = 0;
        while (i < this.request.length) {
            if (this.request[i] == requestId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private @Nullable Object pollReturnValue() {
        Object returnValue = this.returnValue;
        this.returnValue = null;
        return returnValue;
    }

    private @Nullable Object evalArgValue(RAstNode node, int @Nullable [] request) throws InvocationTargetException {
        int[] prevRequest = this.request;
        if (request != null) {
            this.request = request;
        }
        this.returnValue = null;
        node.acceptInR(this);
        this.argValueToIgnore.add(node);
        this.request = prevRequest;
        return this.pollReturnValue();
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        throw new IllegalArgumentException();
    }

    @Override
    public void visit(Assignment node) throws InvocationTargetException {
        this.returnValue = null;
        node.getSourceChild().acceptInR(this);
        Object returnValue = this.returnValue;
        if (node.getNodeType() == NodeType.A_COLON) {
            this.returnValue = null;
            return;
        }
        RAstNode target = node.getTargetChild();
        if (target.getNodeType() == NodeType.F_CALL) {
            this.visit((FCall)target, node.getSourceChild(), NO_NODES);
            return;
        }
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 2;
        String name = this.resolveElementName(target, access, true);
        if (name != null || returnValue instanceof RSourceElementByElementAccess) {
            int mode;
            if (access.getNextSegment() == null) {
                switch (node.getOperator(0)) {
                    case ARROW_LEFT_D: 
                    case ARROW_RIGHT_D: {
                        mode = 2;
                        break;
                    }
                    default: {
                        mode = 1;
                        break;
                    }
                }
            } else {
                mode = 2;
            }
            this.registerInEnvir(mode, name, access);
            this.returnValue = this.registerSourceElement(returnValue, access);
        } else {
            this.returnValue = null;
        }
    }

    @Override
    public void visit(Pipe node) throws InvocationTargetException {
        if (node.getTargetChild().getNodeType() == NodeType.F_CALL) {
            this.visit((FCall)node.getTargetChild(), null, (ImList<RAstNode>)ImCollections.newList((Object)((Object)node.getSourceChild())));
        } else {
            this.request = NO_REQUESTS;
            node.acceptInRChildren(this);
            this.returnValue = null;
        }
    }

    @Override
    public void visit(CForLoop node) throws InvocationTargetException {
        Symbol symbol = node.getVarChild();
        ElementAccess.Default access = new ElementAccess.Default(symbol);
        access.flags = 2;
        String name = this.resolveElementName(symbol, access, false);
        if (name != null) {
            this.registerInEnvir(1, name, access);
        }
        this.request = NO_REQUESTS;
        node.getCondChild().acceptInR(this);
        node.getContChild().acceptInR(this);
        this.returnValue = null;
    }

    @Override
    public void visit(FDef node) throws InvocationTargetException {
        RSourceElementByElementAccess.RMethod rMethod;
        BuildSourceFrame.DefScope envir = new BuildSourceFrame.DefScope(5, BuildSourceFrame.createId(5, null, ++this.anonymCount), null, new BuildSourceFrame[]{this.topScope});
        this.currentEnvironments.add(envir);
        this.topScope = envir;
        SourceElementBuilder containerBuilder = this.getCurrentSourceContainerBuilder();
        if (containerBuilder != null) {
            rMethod = new RSourceElementByElementAccess.RMethod((RLangSourceElement)containerBuilder.element, envir, node);
            this.enterElement(rMethod, envir, node);
        } else {
            rMethod = null;
            this.addEnvirInsteadOfElement(envir, node);
        }
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        if (rMethod != null) {
            this.leaveElement();
        }
        this.currentEnvironments.remove(envir);
        this.topScope = this.currentEnvironments.get(this.currentEnvironments.size() - 1);
        this.returnValue = rMethod;
    }

    @Override
    public void visit(FDef.Arg node) throws InvocationTargetException {
        RAstNode nameNode = node.getNameChild();
        if ((nameNode.getStatusCode() & 0x400000) == 0) {
            ElementAccess.Default access = new ElementAccess.Default(node);
            access.flags = 34;
            access.nameNode = nameNode;
            this.registerInEnvir(1, nameNode.getText(), access);
            SourceElementBuilder containerBuilder = this.getCurrentSourceContainerBuilder();
            if (containerBuilder != null) {
                containerBuilder.children.add(new RSourceElementByElementAccess.RVariable(containerBuilder.element, 1585, access));
            }
        }
        if (node.hasDefault()) {
            node.getDefaultChild().acceptInR(this);
        }
        this.returnValue = null;
    }

    @Override
    public void visit(FCall node) throws InvocationTargetException {
        this.visit(node, null, NO_NODES);
    }

    private void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0Args) throws InvocationTargetException {
        RAstNode ref = node.getRefChild();
        ElementAccess.Default access = new ElementAccess.Default(node, ref);
        access.flags = 17;
        String name = this.resolveElementName(node.getRefChild(), access, true);
        if (name != null) {
            if (replValueArg != null) {
                name = String.valueOf(name) + "<-";
            }
            this.registerInEnvir(2, name, access);
        }
        FCallAnalyzer specialist = null;
        if (name != null) {
            specialist = this.fCallAnalyzers.get(name);
        }
        if (specialist == null) {
            specialist = this.fCallFallback;
        }
        specialist.visit(node, replValueArg, inject0Args);
    }

    @Override
    public void visit(FCall.Arg node) throws InvocationTargetException {
        this.visitFCallArgValue(node.getValueChild());
    }

    private void visitFCallArgs(FCall.Args argsNode, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
        for (RAstNode valueNode : inject0ArgValues) {
            this.visitFCallArgValue(valueNode);
        }
        int nPlaceholder = 0;
        for (FCall.Arg argNode : argsNode.getArgChildren()) {
            RAstNode valueNode = argNode.getValueChild();
            if (valueNode != null && !this.argValueToIgnore.remove((Object)valueNode)) {
                if (valueNode.getNodeType() == NodeType.PLACEHOLDER) {
                    if (nPlaceholder < inject0ArgValues.size()) {
                        valueNode.addAttachment(new PlaceholderDetail((Placeholder)valueNode, (RAstNode)((Object)inject0ArgValues.get(nPlaceholder))));
                    }
                    ++nPlaceholder;
                } else {
                    valueNode.acceptInR(this);
                }
            }
            this.returnValue = null;
        }
    }

    private void visitFCallArgValue(@Nullable RAstNode node) throws InvocationTargetException {
        if (node != null && !this.argValueToIgnore.remove((Object)node)) {
            node.acceptInR(this);
        }
        this.returnValue = null;
    }

    private @Nullable RSourceElementByElementAccess.RMethod visitAndCheckValue(@Nullable FCall.Arg node, String name) throws InvocationTargetException {
        Object value;
        RAstNode valueNode;
        if (node != null && (valueNode = node.getValueChild()) != null && (value = this.evalArgValue(valueNode, NO_REQUESTS)) instanceof RSourceElementByElementAccess.RMethod) {
            RSourceElementByElementAccess.RMethod rMethod = (RSourceElementByElementAccess.RMethod)value;
            ElementAccess.Default access = new ElementAccess.Default(node);
            access.flags = 18;
            access.nameNode = node.getNameChild();
            this.currentSourceContainerBuilder.envir.addRunResolve(name, access);
            this.registerFunctionElement(rMethod, 1297, access, null);
            return rMethod;
        }
        return null;
    }

    @Override
    public void visit(SubIndexed.Arg node) throws InvocationTargetException {
        RAstNode valueNode = node.getValueChild();
        if (valueNode != null) {
            valueNode.acceptInR(this);
        }
    }

    @Override
    public void visit(NSGet node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(1, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(Symbol node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
            if (name.equals(".GlobalEnv")) {
                this.returnValue = this.globalEnvir;
                return;
            }
        }
        this.returnValue = access;
    }

    @Override
    public void visit(SubNamed node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolvePartName(node, access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(SubIndexed node) throws InvocationTargetException {
        ElementAccess.Default access = new ElementAccess.Default(node);
        access.flags = 0;
        String name = this.resolveElementName(node, (ElementAccess)access);
        if (name != null) {
            this.registerInEnvir(2, name, access);
        }
        this.returnValue = access;
    }

    @Override
    public void visit(Model node) throws InvocationTargetException {
        node.acceptInRChildren(this);
        this.returnValue = node;
    }

    @Override
    public void visit(Help node) throws InvocationTargetException {
        this.returnValue = null;
    }

    @Override
    public void visit(StringConst node) throws InvocationTargetException {
        int i = 0;
        while (i < this.request.length) {
            if (this.request[i] == 3) {
                this.returnValue = new NodeArray(3, new StringConst[]{node});
                return;
            }
            ++i;
        }
        this.returnValue = node;
    }

    @Override
    public void visit(NumberConst node) throws InvocationTargetException {
        this.returnValue = null;
    }

    @Override
    public void visit(NullConst node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Special node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Sign node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Power node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Arithmetic node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Seq node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Relational node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Logical node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CIfElse node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CRepeatLoop node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CWhileLoop node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(CLoopCommand node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    @Override
    public void visit(Dummy node) throws InvocationTargetException {
        this.request = NO_REQUESTS;
        node.acceptInRChildren(this);
        this.returnValue = null;
    }

    private static boolean isValidPackageName(RAstNode node) {
        switch (node.getNodeType()) {
            case SYMBOL: {
                return (node.getStatusCode() & 0x400000) == 0;
            }
            case STRING_CONST: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTextEqualTo(RAstNode node, String text) {
        return text.equals(node.getText());
    }

    private static RAstNode getAssignBaseNode(RAstNode node, RAstNode nameNode, @Nullable RAstNode valueNode) {
        Pipe pipe;
        RAstNode parent = node.getRParent();
        if (parent != null && parent.getNodeType() == NodeType.PIPE_FORWARD && (pipe = (Pipe)parent).getTargetChild() == node && (pipe.getSourceChild() == nameNode || pipe.getSourceChild() == valueNode)) {
            return pipe;
        }
        return node;
    }

    private @Nullable String resolveElementName(RAstNode node, ElementAccess access, boolean allowString) throws InvocationTargetException {
        switch (node.getNodeType()) {
            case SYMBOL: {
                return this.resolveElementName((Symbol)node, access);
            }
            case STRING_CONST: {
                if (allowString && (node.getStatusCode() & 0x400000) == 0) {
                    access.nameNode = node;
                    return node.getText();
                }
                return null;
            }
            case SUB_INDEXED_S: 
            case SUB_INDEXED_D: {
                return this.resolveElementName((SubIndexed)node, access);
            }
            case SUB_NAMED_PART: {
                return this.resolvePartName((SubNamed)node, access);
            }
            case SUB_NAMED_SLOT: {
                return this.resolveSlotName((SubNamed)node, access);
            }
            case NS_GET: 
            case NS_GET_INT: {
                return this.resolveElementName((NSGet)node, access);
            }
        }
        if (node == access.fullNode) {
            node.acceptInRChildren(this);
        } else {
            node.acceptInR(this);
        }
        return null;
    }

    private @Nullable String resolveElementName(Symbol node, ElementAccess access) {
        if ((node.getStatusCode() & 0x400000) == 0) {
            access.nameNode = node;
            return node.getText();
        }
        return null;
    }

    private @Nullable String resolveElementName(SubIndexed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        node.getArgsChild().acceptInR(this);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(node.getOperator(0) == RTerminal.SUB_INDEXED_D_OPEN ? new SubIndexedDElementAccess(access, node) : new SubIndexedSElementAccess(access, node));
            return name;
        }
        return null;
    }

    private @Nullable String resolvePartName(SubNamed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(new SubNamedPartSyntacticElementAccess(access, node));
            return name;
        }
        return null;
    }

    private @Nullable String resolveSlotName(SubNamed node, ElementAccess access) throws InvocationTargetException {
        RAstNode child = node.getRefChild();
        String name = this.resolveElementName(child, access, false);
        if (name != null) {
            access.flags |= 0x100;
            access.appendSubElement(new SubNamedSlotSyntacticElementAccess(access, node));
            return name;
        }
        return null;
    }

    private @Nullable String resolveElementName(NSGet node, ElementAccess access) {
        String namespaceName;
        RAstNode namespaceChild = node.getNamespaceChild();
        RAstNode elementChild = node.getElementChild();
        String string = namespaceName = SourceAnalyzer.isValidPackageName(namespaceChild) ? namespaceChild.getText() : null;
        if (namespaceName != null) {
            ElementAccess.Scope packageAccess;
            ElementAccess.Scope scope = packageAccess = node.getNodeType() == NodeType.NS_GET_INT ? new ElementAccess.NamespaceInternal(access.fullNode, namespaceChild) : new ElementAccess.Namespace(access.fullNode, namespaceChild);
            if (namespaceName != null) {
                this.packageRefs.add(namespaceName, packageAccess);
            }
            if (access instanceof ElementAccess.Main) {
                ((ElementAccess.Main)access).setScope(packageAccess);
            }
        }
        BuildSourceFrame envir = namespaceName != null && (elementChild.getStatusCode() & 0x400000) == 0 ? this.getPkgEnvir(namespaceName) : this.topScope;
        access.nameNode = elementChild;
        envir.add(elementChild.getText(), access);
        return null;
    }

    private @Nullable Signature readSignature(RAstNode refNode, @Nullable RAstNode sigValue) throws InvocationTargetException {
        if (sigValue != null) {
            Object value = this.evalArgValue(sigValue, SIGNATURE_REQUESTS);
            if (value instanceof ReturnValue) {
                ReturnValue returnValue = (ReturnValue)value;
                if (returnValue.returnType == 2) {
                    return (Signature)returnValue;
                }
                if (returnValue.returnType == 3) {
                    RAstNode[] nodes = ((NodeArray)returnValue).array;
                    @Nullable String[] classNames = new String[nodes.length];
                    int i = 0;
                    while (i < nodes.length) {
                        this.registerSimpleClassAccessInEnvir(refNode, nodes[i]);
                        classNames[i] = nodes[i].getText();
                        ++i;
                    }
                    return new Signature(null, classNames);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Parameters createFParameters(@Nullable FDef fdefNode, @Nullable Signature sig) {
        block14: {
            block12: {
                block13: {
                    argList = fdefNode != null ? fdefNode.getArgsChild() : null;
                    b = new ParametersBuilder();
                    if (argList == null) break block12;
                    n = argList.getChildCount();
                    if (sig == null || sig.classNames == null) break block13;
                    i = 0;
                    while (i < n) {
                        argName = argList.getChild(i).getNameChild().getText();
                        if (argName == null) ** GOTO lbl-1000
                        argNameAccesses = sig.argNameAccesses;
                        if (sig.argNameAccesses != null) {
                            j = 0;
                            while (j < argNameAccesses.length) {
                                argNameAccess = argNameAccesses[j];
                                if (argNameAccess != null && (nameNode = argNameAccess.nameNode) != null && SourceAnalyzer.isTextEqualTo(nameNode, argName)) {
                                    b.add(argName, 0, sig.classNames[j]);
                                    break;
                                }
                                ++j;
                            }
                        } else if (i < sig.classNames.length) {
                            b.add(argName, 0, sig.classNames[i]);
                        } else {
                            b.add(argName, 0, null);
                        }
                        ++i;
                    }
                    break block14;
                }
                i = 0;
                while (i < n) {
                    argName = argList.getChild(i).getNameChild().getText();
                    b.add(argName, 0, null);
                    ++i;
                }
                break block14;
            }
            if (sig == null) break block14;
            argNameAccesses = sig.argNameAccesses;
            if (sig.argNameAccesses != null && sig.classNames != null) {
                i = 0;
                while (i < argNameAccesses.length) {
                    argNameAccess = argNameAccesses[i];
                    if (argNameAccess != null && (nameNode = argNameAccess.nameNode) != null) {
                        b.add(nameNode.getText(), 0, sig.classNames[i]);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        return b.build();
    }

    private BuildSourceFrame readScopeArgs(@Nullable RAstNode pos, BuildSourceFrame defaultScope) throws InvocationTargetException {
        this.returnValue = null;
        BuildSourceFrame envir = null;
        if (pos != null) {
            switch (pos.getNodeType()) {
                case NUM_CONST: {
                    Integer javaInt = RAsts.toJavaInt(pos, false);
                    if (javaInt == null || javaInt != 1) break;
                    envir = this.globalEnvir;
                    break;
                }
                case STRING_CONST: {
                    String text = pos.getText();
                    if (text == null) break;
                    if (text.equals(".GlobalEnv")) {
                        envir = this.globalEnvir;
                        break;
                    }
                    if (!text.startsWith("package:")) break;
                    envir = this.getPkgEnvir(text.substring(8));
                    break;
                }
                default: {
                    pos.acceptInR(this);
                    if (!(this.returnValue instanceof BuildSourceFrame)) break;
                    envir = (BuildSourceFrame)this.returnValue;
                }
            }
            this.argValueToIgnore.add(pos);
        }
        if (envir != null) {
            return envir;
        }
        return defaultScope;
    }

    protected final class BaseAssign
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_x;
        private final int paramIdx_value;

        public BaseAssign(RCoreFunctions rdef) {
            this.params = rdef.BASE_ASSIGN_parameters;
            this.paramIdx_x = this.params.indexOf("x");
            this.paramIdx_value = this.params.indexOf("value");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.returnValue = null;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode xNode = args.getArgValueNode(this.paramIdx_x);
            RAstNode valueNode = args.getArgValueNode(this.paramIdx_value);
            Object returnValue = null;
            if (valueNode != null) {
                returnValue = SourceAnalyzer.this.evalArgValue(valueNode, null);
            }
            if (xNode != null && xNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(SourceAnalyzer.getAssignBaseNode(node, xNode, valueNode));
                access.flags = 2;
                access.nameNode = xNode;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode("pos"), SourceAnalyzer.this.topScope);
                if (RAsts.toJavaBooleanValue(args.getArgValueNode("inherits"), false)) {
                    envir.addLateResolve(xNode.getText(), access);
                } else {
                    envir.add(xNode.getText(), access);
                }
                returnValue = SourceAnalyzer.this.registerSourceElement(returnValue, access);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class BaseC
    implements FCallAnalyzer {
        private final Parameters params;

        public BaseC(RCoreFunctions rdef) {
            this.params = rdef.BASE_C_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            NodeArray returnValue = null;
            int i = 0;
            block0: while (i < SourceAnalyzer.this.request.length) {
                if (SourceAnalyzer.this.request[i] == 3) {
                    RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
                    RAstNode[] array = new RAstNode[args.ellipsisArgs.length];
                    int j = 0;
                    while (j < array.length) {
                        FCall.Arg argNode = args.ellipsisArgs[j];
                        RAstNode valueNode = argNode.getValueChild();
                        if (valueNode != null) {
                            if (valueNode.getNodeType() != NodeType.STRING_CONST) break block0;
                            array[j] = valueNode;
                            SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                        }
                        ++j;
                    }
                    returnValue = new NodeArray(3, array);
                    break;
                }
                ++i;
            }
            SourceAnalyzer.this.request = NO_REQUESTS;
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class BaseCall
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;

        public BaseCall(RCoreFunctions rdef) {
            this.params = rdef.BASE_CALL_parameters;
            this.paramIdx_fName = this.params.indexOf("name");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode nameNode = args.getArgValueNode(this.paramIdx_fName);
            if (nameNode != null && nameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 16;
                access.nameNode = nameNode;
                SourceAnalyzer.this.topScope.addLateResolve(nameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(nameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private abstract class BaseCommonPackageLoad
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_packageName;
        private final int paramIdx_stringOnly;

        public BaseCommonPackageLoad(Parameters parameters) {
            this.params = parameters;
            this.paramIdx_packageName = this.params.indexOf("package");
            this.paramIdx_stringOnly = this.params.indexOf("character.only");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode nameValue = args.getArgValueNode(this.paramIdx_packageName);
            if (nameValue != null && (nameValue.getNodeType() == NodeType.STRING_CONST || !RAsts.toJavaBooleanValue(args.getArgValueNode(this.paramIdx_stringOnly), false) && nameValue.getNodeType() == NodeType.SYMBOL) && SourceAnalyzer.isValidPackageName(nameValue)) {
                String packageName = nameValue.getText();
                if (packageName != null) {
                    BuildSourceFrame envir;
                    ElementAccess.Package access = new ElementAccess.Package(node, nameValue);
                    access.flags |= 4;
                    SourceAnalyzer.this.packageRefs.add(packageName, access);
                    SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
                    if (containerBuilder != null) {
                        RSourceElementByElementAccess.RPkgImport rImport = new RSourceElementByElementAccess.RPkgImport(containerBuilder.element, access);
                        containerBuilder.children.add(rImport);
                    }
                    if (!SourceAnalyzer.this.globalEnvir.parents.contains((Object)(envir = SourceAnalyzer.this.getPkgEnvir(packageName)))) {
                        SourceAnalyzer.this.globalEnvir.parents = ImCollections.addElement(SourceAnalyzer.this.globalEnvir.parents, (int)0, (Object)envir);
                    }
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameValue);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.globalEnvir;
        }
    }

    protected final class BaseDoCall
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;

        public BaseDoCall(RCoreFunctions rdef) {
            this.params = rdef.BASE_DOCALL_parameters;
            this.paramIdx_fName = this.params.indexOf("what");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode nameNode = args.getArgValueNode(this.paramIdx_fName);
            if (nameNode != null) {
                ElementAccess.Default access = new ElementAccess.Default(node, nameNode);
                access.flags = 17;
                String name = SourceAnalyzer.this.resolveElementName(nameNode, access, true);
                if (name != null) {
                    SourceAnalyzer.this.topScope.addLateResolve(name, access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseExists
    extends CommonVarNamedRead {
        public BaseExists(RCoreFunctions rdef) {
            super(rdef.BASE_EXISTS_parameters, "x", "where");
        }
    }

    protected final class BaseGet
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_x;
        private final int paramIdx_scope;

        public BaseGet(RCoreFunctions rdef) {
            this.params = rdef.BASE_GET_parameters;
            this.paramIdx_x = this.params.indexOf("x");
            this.paramIdx_scope = this.params.indexOf("pos");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode xNode = args.getArgValueNode(this.paramIdx_x);
            if (xNode != null && xNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 0;
                access.nameNode = xNode;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode(this.paramIdx_scope), SourceAnalyzer.this.topScope);
                if (RAsts.toJavaBooleanValue(args.getArgValueNode("inherits"), true)) {
                    envir.addLateResolve(xNode.getText(), access);
                } else {
                    envir.add(xNode.getText(), access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(xNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseGlobalenv
    implements FCallAnalyzer {
        public BaseGlobalenv(RCoreFunctions rdef) {
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.globalEnvir;
        }
    }

    protected final class BaseLibrary
    extends BaseCommonPackageLoad {
        public BaseLibrary(RCoreFunctions rdef) {
            super(rdef.BASE_LIBRARY_parameters);
        }
    }

    protected final class BaseRemove
    implements FCallAnalyzer {
        private final Parameters params;

        public BaseRemove(RCoreFunctions rdef) {
            this.params = rdef.BASE_REMOVE_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            if (args.ellipsisArgs.length > 0) {
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg argNode = args.ellipsisArgs[i];
                    RAstNode valueNode = argNode.getValueChild();
                    if (valueNode != null) {
                        switch (valueNode.getNodeType()) {
                            case SYMBOL: 
                            case STRING_CONST: {
                                ElementAccess.Default access = new ElementAccess.Default(node);
                                access.flags = 3;
                                access.nameNode = valueNode;
                                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode("pos"), SourceAnalyzer.this.topScope);
                                if (RAsts.toJavaBooleanValue(args.getArgValueNode("inherits"), false)) {
                                    envir.addLateResolve(valueNode.getText(), access);
                                } else {
                                    envir.add(valueNode.getText(), access);
                                }
                                SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseRequire
    extends BaseCommonPackageLoad {
        public BaseRequire(RCoreFunctions rdef) {
            super(rdef.BASE_REQUIRE_parameters);
        }
    }

    protected final class BaseSave
    implements FCallAnalyzer {
        private final Parameters params;

        public BaseSave(RCoreFunctions rdef) {
            this.params = rdef.BASE_SAVE_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            if (args.ellipsisArgs.length > 0) {
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg argNode = args.ellipsisArgs[i];
                    RAstNode valueNode = argNode.getValueChild();
                    if (valueNode != null) {
                        switch (valueNode.getNodeType()) {
                            case SYMBOL: 
                            case STRING_CONST: {
                                ElementAccess.Default access = new ElementAccess.Default(node);
                                access.flags = 0;
                                access.nameNode = valueNode;
                                SourceAnalyzer.this.topScope.addLateResolve(valueNode.getText(), access);
                                SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class BaseTopenv
    implements FCallAnalyzer {
        public BaseTopenv(RCoreFunctions rdef) {
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = SourceAnalyzer.this.topLevelEnvir;
        }
    }

    protected final class CommonDefBased
    implements FCallAnalyzer {
        private final Parameters params;

        public CommonDefBased(Parameters parameters) {
            this.params = parameters;
        }

        private boolean matchesNameType(int nameType, int defType, RAstNode argValue) {
            return (defType & nameType) != 0 && ((defType & 0x4000000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST || (defType & 0x2000000) != 0 && argValue.getNodeType() == NodeType.SYMBOL) && argValue.getText() != null;
        }

        @Override
        public final void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            int i = 0;
            while (i < args.allocatedArgs.length) {
                RAstNode argValue = args.getArgValueNode(i);
                if (argValue != null) {
                    ElementAccess access;
                    if (this.matchesNameType(512, this.params.get(i).getType(), argValue)) {
                        access = new ElementAccess.Namespace(node, argValue);
                        access.nameNode = argValue;
                        @NonNull String packageName = argValue.getText();
                        SourceAnalyzer.this.packageRefs.add(packageName, access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.params.get(i).getType() & 0x4000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        access = new ElementAccess.Default(node);
                        access.flags = 16;
                        access.nameNode = argValue;
                        SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(argValue.getText(), access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.params.get(i).getType() & 0x2000) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, argValue);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if ((this.params.get(i).getType() & 0x100) != 0 && argValue.getNodeType() == NodeType.STRING_CONST) {
                        access = new ElementAccess.Default(node);
                        access.flags = 0;
                        access.nameNode = argValue;
                        SourceAnalyzer.this.topScope.addLateResolve(argValue.getText(), access);
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    } else if (this.matchesNameType(4096, this.params.get(i).getType(), argValue)) {
                        SourceAnalyzer.this.argValueToIgnore.add(argValue);
                    }
                }
                ++i;
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected class CommonVarNamedRead
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_name;
        private final int paramIdx_scope;

        protected CommonVarNamedRead(Parameters parameters, String nameArgName, String scopeArgName) {
            this.params = parameters;
            this.paramIdx_name = this.params.indexOf(nameArgName);
            this.paramIdx_scope = this.params.indexOf(scopeArgName);
        }

        @Override
        public final void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode nameValue = args.getArgValueNode(this.paramIdx_name);
            if (nameValue != null && nameValue.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 0;
                access.nameNode = nameValue;
                BuildSourceFrame envir = SourceAnalyzer.this.readScopeArgs(args.getArgValueNode(this.paramIdx_scope), SourceAnalyzer.this.topScope);
                if (RAsts.toJavaBooleanValue(args.getArgValueNode("inherits"), false)) {
                    envir.addLateResolve(nameValue.getText(), access);
                } else {
                    envir.add(nameValue.getText(), access);
                }
                SourceAnalyzer.this.argValueToIgnore.add(nameValue);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected static interface FCallAnalyzer {
        public void visit(FCall var1, @Nullable RAstNode var2, ImList<RAstNode> var3) throws InvocationTargetException;
    }

    protected final class MethodsAs
    extends MethodsCommonClassRead {
        public MethodsAs(RCoreFunctions rdef) {
            super(rdef.METHODS_AS_parameters, "Class");
        }
    }

    private abstract class MethodsCommonClassRead
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;

        protected MethodsCommonClassRead(Parameters parameters, String classNameNodeName) {
            this.params = parameters;
            this.paramIdx_className = this.params.indexOf(classNameNodeName);
        }

        @Override
        public final void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameNode = args.getArgValueNode(this.paramIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, classNameNode);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private class MethodsCommonMethodRead
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;

        protected MethodsCommonMethodRead(Parameters parameters, String fNameNodeName) {
            this.params = parameters;
            this.paramIdx_fName = this.params.indexOf(fNameNodeName);
        }

        @Override
        public final void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameNode = args.getArgValueNode(this.paramIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 16;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private abstract class MethodsCommonSetGeneric
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;
        private final int paramIdx_def;
        private final int paramIdx_useAsDefault;
        private final int paramIdx_genericFunction;
        private final int paramIdx_signature;

        protected MethodsCommonSetGeneric(Parameters parameters) {
            this.params = parameters;
            this.paramIdx_fName = this.params.indexOf("name");
            this.paramIdx_def = this.params.indexOf("def");
            this.paramIdx_useAsDefault = this.params.indexOf("useAsDefault");
            this.paramIdx_genericFunction = this.params.indexOf("genericFunction");
            this.paramIdx_signature = this.params.indexOf("signature");
        }

        @Override
        public final void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameNode = args.getArgValueNode(this.paramIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 18;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.topLevelEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
                BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(5, BuildSourceFrame.createId(5, access.getSegmentName(), ++SourceAnalyzer.this.anonymCount), SourceAnalyzer.this.topScope);
                SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
                if (containerBuilder != null) {
                    Parameters methodParams;
                    Object value;
                    RSourceElementByElementAccess.RMethod rMethod = new RSourceElementByElementAccess.RMethod((RLangSourceElement)containerBuilder.element, 1312, access, envir);
                    SourceAnalyzer.this.registerFunctionElement(rMethod);
                    SourceAnalyzer.this.enterElement(rMethod, envir, node);
                    RSourceElementByElementAccess.RMethod defMethod = SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_def), "def");
                    RSourceElementByElementAccess.RMethod defaultMethod = SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_useAsDefault), "useAsDefault");
                    SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_genericFunction), "genericFunction");
                    RAstNode signatureValue = args.getArgValueNode(this.paramIdx_signature);
                    RAstNode[] signatureArgNodes = null;
                    if (signatureValue != null && (value = SourceAnalyzer.this.evalArgValue(signatureValue, STRING_ARRAY_REQUEST)) instanceof ReturnValue && ((ReturnValue)value).returnType == 3) {
                        signatureArgNodes = ((NodeArray)value).array;
                    }
                    Parameters baseParams = null;
                    if (defMethod != null) {
                        baseParams = defMethod.getParameters();
                    }
                    if (defaultMethod != null && (baseParams == null || baseParams.size() == 0)) {
                        baseParams = defaultMethod.getParameters();
                    }
                    if (baseParams != null && baseParams.size() > 0) {
                        ParametersBuilder parametersBuilder = new ParametersBuilder();
                        if (signatureArgNodes != null) {
                            int i = 0;
                            while (i < baseParams.size()) {
                                block23: {
                                    String name = baseParams.get(i).getName();
                                    if (name != null) {
                                        int j = 0;
                                        while (j < signatureArgNodes.length) {
                                            if (SourceAnalyzer.isTextEqualTo(signatureArgNodes[j], name)) {
                                                parametersBuilder.add(name, 0, "<?>");
                                                break block23;
                                            }
                                            ++j;
                                        }
                                        parametersBuilder.add(name, 0, "\u2014");
                                    } else {
                                        parametersBuilder.add(name);
                                    }
                                }
                                ++i;
                            }
                        } else if (baseParams.size() == 1 && "...".equals(baseParams.get(0).getName())) {
                            parametersBuilder.add("...", 0, "<?>");
                        } else {
                            int i = 0;
                            while (i < baseParams.size()) {
                                String name = baseParams.get(i).getName();
                                if (name != null) {
                                    if (!name.equals("...")) {
                                        parametersBuilder.add(name, 0, "<?>");
                                    } else {
                                        parametersBuilder.add(name, 0, "\u2014");
                                    }
                                } else {
                                    parametersBuilder.add(name);
                                }
                                ++i;
                            }
                        }
                        methodParams = parametersBuilder.build();
                    } else {
                        methodParams = new Parameters(new String[0]);
                    }
                    rMethod.complete(methodParams);
                    SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
                    SourceAnalyzer.this.leaveElement();
                } else {
                    SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                    SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
                }
            } else {
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsFindClass
    extends MethodsCommonClassRead {
        public MethodsFindClass(RCoreFunctions rdef) {
            super(rdef.METHODS_FINDCLASS_parameters, "Class");
        }
    }

    protected final class MethodsFindMethod
    extends MethodsCommonMethodRead {
        public MethodsFindMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_FINDMETHOD_parameters, "f");
        }
    }

    protected final class MethodsGetClass
    extends MethodsCommonClassRead {
        public MethodsGetClass(RCoreFunctions rdef) {
            super(rdef.METHODS_GETCLASS_parameters, "Class");
        }
    }

    protected final class MethodsGetClassDef
    extends MethodsCommonClassRead {
        public MethodsGetClassDef(RCoreFunctions rdef) {
            super(rdef.METHODS_GETCLASSDEF_parameters, "Class");
        }
    }

    protected final class MethodsGetMethod
    extends MethodsCommonMethodRead {
        public MethodsGetMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_GETMETHOD_parameters, "f");
        }
    }

    protected final class MethodsGetMethods
    extends MethodsCommonMethodRead {
        public MethodsGetMethods(RCoreFunctions rdef) {
            super(rdef.METHODS_GETMETHODS_parameters, "f");
        }
    }

    protected final class MethodsNew
    extends MethodsCommonClassRead {
        public MethodsNew(RCoreFunctions rdef) {
            super(rdef.METHODS_NEW_parameters, "Class");
        }
    }

    protected final class MethodsPrototype
    implements FCallAnalyzer {
        private final Parameters params;

        public MethodsPrototype(RCoreFunctions rdef) {
            this.params = rdef.METHODS_PROTOTYPE_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceElementBuilder containerBuilder = SourceAnalyzer.this.request == PROTOTYPE_REQUEST ? SourceAnalyzer.this.getCurrentSourceContainerBuilder(1152) : null;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            if (args.ellipsisArgs.length > 0) {
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg arg = args.ellipsisArgs[i];
                    RAstNode slotNameNode = arg.getNameChild();
                    if (slotNameNode != null) {
                        String slotName = slotNameNode.getText();
                        RSourceElementByElementAccess.RSlot slot = null;
                        if (containerBuilder != null && slotName != null) {
                            ElementAccess.Slot access = new ElementAccess.Slot(arg);
                            access.flags = 2;
                            access.nameNode = slotNameNode;
                            containerBuilder.envir.addRunResolve(slotName, access);
                            for (RSourceElementByElementAccess child : containerBuilder.children) {
                                if (child.getElementType() != 1664 || !slotName.equals(child.getElementName().getSegmentName())) continue;
                                slot = (RSourceElementByElementAccess.RSlot)child;
                                break;
                            }
                        }
                        arg.hasValue();
                    }
                    ++i;
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveClass
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;

        public MethodsRemoveClass(RCoreFunctions rdef) {
            this.params = rdef.METHODS_REMOVECLASS_parameters;
            this.paramIdx_className = this.params.indexOf("Class");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameNode = args.getArgValueNode(this.paramIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Class access = new ElementAccess.Class(node);
                access.flags = 3;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveGeneric
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;

        public MethodsRemoveGeneric(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETGROUPGENERIC_parameters;
            this.paramIdx_fName = this.params.indexOf("f");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameNode = args.getArgValueNode(this.paramIdx_fName);
            if (fNameNode != null && fNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveMethod
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;
        private final int paramIdx_signature;

        public MethodsRemoveMethod(RCoreFunctions rdef) {
            this.params = rdef.METHODS_REMOVEMETHOD_parameters;
            this.paramIdx_fName = this.params.indexOf("f");
            this.paramIdx_signature = this.params.indexOf("signature");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameArg = args.getArgValueNode(this.paramIdx_fName);
            if (fNameArg != null && fNameArg.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameArg;
                SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(fNameArg.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameArg);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRemoveMethods
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;

        public MethodsRemoveMethods(RCoreFunctions rdef) {
            this.params = rdef.METHODS_REMOVEMETHODS_parameters;
            this.paramIdx_fName = this.params.indexOf("f");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameArg = args.getArgValueNode(this.paramIdx_fName);
            if (fNameArg != null && fNameArg.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 19;
                access.nameNode = fNameArg;
                SourceAnalyzer.this.genericDefaultEnvir.addLateResolve(fNameArg.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameArg);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsRepresentation
    implements FCallAnalyzer {
        private final Parameters params;

        public MethodsRepresentation(RCoreFunctions rdef) {
            this.params = rdef.METHODS_REPRESENTATION_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceElementBuilder containerBuilder = SourceAnalyzer.this.request == REPRESENTATION_REQUEST ? SourceAnalyzer.this.getCurrentSourceContainerBuilder(1152) : null;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            if (args.ellipsisArgs.length > 0) {
                RSourceElementByElementAccess.RClass rClass = containerBuilder != null ? (RSourceElementByElementAccess.RClass)containerBuilder.element : null;
                @Nullable String[] superClassNames = new String[args.ellipsisArgs.length];
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    FCall.Arg arg = args.ellipsisArgs[i];
                    RAstNode nameNode = arg.getNameChild();
                    if (nameNode != null) {
                        RAstNode valueNode;
                        RSourceElementByElementAccess.RSlot slot = null;
                        if (containerBuilder != null) {
                            ElementAccess.Slot access = new ElementAccess.Slot(arg);
                            access.flags = 2;
                            access.nameNode = nameNode;
                            containerBuilder.envir.addRunResolve(nameNode.getText(), access);
                            slot = new RSourceElementByElementAccess.RSlot(rClass, access);
                            containerBuilder.children.add(slot);
                        }
                        if ((valueNode = arg.getValueChild()) != null && valueNode.getNodeType() == NodeType.STRING_CONST) {
                            SourceAnalyzer.this.registerSimpleClassAccessInEnvir(arg, valueNode);
                            if (slot != null) {
                                slot.completeType(valueNode.getText());
                            }
                            SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                        }
                    } else {
                        RAstNode valueNode = arg.getValueChild();
                        if (valueNode != null && valueNode.getNodeType() == NodeType.STRING_CONST) {
                            SourceAnalyzer.this.registerSimpleClassAccessInEnvir(arg, valueNode);
                            if (containerBuilder != null) {
                                superClassNames[i] = valueNode.getText();
                            }
                            SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                        }
                    }
                    ++i;
                }
                if (containerBuilder != null) {
                    rClass.addSuperClasses(superClassNames);
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSelectMethod
    extends MethodsCommonMethodRead {
        public MethodsSelectMethod(RCoreFunctions rdef) {
            super(rdef.METHODS_SELECTMETHOD_parameters, "f");
        }
    }

    protected final class MethodsSetAs
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;
        private final int paramIdx_toClass;

        public MethodsSetAs(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETAS_parameters;
            this.paramIdx_className = this.params.indexOf("from");
            this.paramIdx_toClass = this.params.indexOf("to");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            ElementAccess.Class access;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameNode = args.getArgValueNode(this.paramIdx_className);
            RAstNode toClassNode = args.getArgValueNode(this.paramIdx_toClass);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            if (toClassNode != null && toClassNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 0;
                access.nameNode = toClassNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(toClassNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(toClassNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetClass
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;
        private final int paramIdx_superClasses;
        private final int paramIdx_representation;
        private final int paramIdx_prototype;

        public MethodsSetClass(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETCLASS_parameters;
            this.paramIdx_className = this.params.indexOf("Class");
            this.paramIdx_superClasses = this.params.indexOf("contains");
            this.paramIdx_representation = this.params.indexOf("representation");
            this.paramIdx_prototype = this.params.indexOf("prototype");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            String name;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            ElementAccess.Class access = new ElementAccess.Class(node);
            access.flags = 2;
            RAstNode classNameValue = args.getArgValueNode(this.paramIdx_className);
            if (classNameValue != null && classNameValue.getNodeType() == NodeType.STRING_CONST) {
                name = classNameValue.getText();
                access.nameNode = classNameValue;
                SourceAnalyzer.this.argValueToIgnore.add(classNameValue);
            } else {
                name = null;
            }
            SourceAnalyzer.this.genericDefaultEnvir.addClass(name, access);
            BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(6, BuildSourceFrame.createId(6, access.getSegmentName(), ++SourceAnalyzer.this.anonymCount), SourceAnalyzer.this.topScope);
            SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
            if (containerBuilder != null) {
                RAstNode prototypeValue;
                Object value;
                RAstNode superClassesValue;
                RSourceElementByElementAccess.RClass rClass = new RSourceElementByElementAccess.RClass((RLangSourceElement)containerBuilder.element, access, envir);
                SourceAnalyzer.this.registerClassElement(rClass);
                SourceAnalyzer.this.enterElement(rClass, envir, node);
                RAstNode representationValue = args.getArgValueNode(this.paramIdx_representation);
                if (representationValue != null) {
                    SourceAnalyzer.this.evalArgValue(representationValue, REPRESENTATION_REQUEST);
                }
                if ((superClassesValue = args.getArgValueNode(this.paramIdx_superClasses)) != null && (value = SourceAnalyzer.this.evalArgValue(superClassesValue, STRING_ARRAY_REQUEST)) instanceof ReturnValue && ((ReturnValue)value).returnType == 3) {
                    RAstNode[] superClassNameNodes = ((NodeArray)value).array;
                    RAstNode refNode = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)args.allocatedArgs[this.paramIdx_superClasses])));
                    @Nullable String[] names = new String[superClassNameNodes.length];
                    int i = 0;
                    while (i < superClassNameNodes.length) {
                        ElementAccess superClassAccess = SourceAnalyzer.this.registerSimpleClassAccessInEnvir(refNode, superClassNameNodes[i]);
                        names[i] = superClassAccess.getSegmentName();
                        ++i;
                    }
                    rClass.addSuperClasses(names);
                }
                if ((prototypeValue = args.getArgValueNode(this.paramIdx_prototype)) != null) {
                    SourceAnalyzer.this.evalArgValue(prototypeValue, PROTOTYPE_REQUEST);
                }
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
                SourceAnalyzer.this.leaveElement();
            } else {
                SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetClassUnion
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;
        private final int paramIdx_superClassNames;

        public MethodsSetClassUnion(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETCLASSUNION_parameters;
            this.paramIdx_className = this.params.indexOf("name");
            this.paramIdx_superClassNames = this.params.indexOf("members");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            String name;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameValue = args.getArgValueNode(this.paramIdx_className);
            RAstNode superClassNamesValue = args.getArgValueNode(this.paramIdx_superClassNames);
            ElementAccess.Class access = new ElementAccess.Class(node);
            access.flags = 2;
            if (classNameValue != null && classNameValue.getNodeType() == NodeType.STRING_CONST) {
                name = classNameValue.getText();
                access.nameNode = classNameValue;
                SourceAnalyzer.this.argValueToIgnore.add(classNameValue);
            } else {
                name = null;
            }
            SourceAnalyzer.this.genericDefaultEnvir.addClass(name, access);
            BuildSourceFrame.RunScope envir = new BuildSourceFrame.RunScope(6, BuildSourceFrame.createId(6, access.getSegmentName(), ++SourceAnalyzer.this.anonymCount), SourceAnalyzer.this.topScope);
            SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
            if (containerBuilder != null) {
                Object value;
                RSourceElementByElementAccess.RClass rClass = new RSourceElementByElementAccess.RClass((RLangSourceElement)containerBuilder.element, access, envir);
                SourceAnalyzer.this.registerClassElement(rClass);
                SourceAnalyzer.this.enterElement(rClass, envir, node);
                if (superClassNamesValue != null && (value = SourceAnalyzer.this.evalArgValue(superClassNamesValue, STRING_ARRAY_REQUEST)) instanceof ReturnValue && ((ReturnValue)value).returnType == 3) {
                    RAstNode[] superClassNameNodes = ((NodeArray)value).array;
                    RAstNode refNode = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)args.allocatedArgs[this.paramIdx_superClassNames])));
                    @Nullable String[] names = new String[superClassNameNodes.length];
                    int i = 0;
                    while (i < superClassNameNodes.length) {
                        ElementAccess superClassAccess = SourceAnalyzer.this.registerSimpleClassAccessInEnvir(refNode, superClassNameNodes[i]);
                        names[i] = superClassAccess.getSegmentName();
                        ++i;
                    }
                    rClass.addSuperClasses(names);
                }
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
                SourceAnalyzer.this.leaveElement();
            } else {
                SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetGeneric
    extends MethodsCommonSetGeneric {
        public MethodsSetGeneric(RCoreFunctions rdef) {
            super(rdef.METHODS_SETGENERIC_parameters);
        }
    }

    protected final class MethodsSetGroupGeneric
    extends MethodsCommonSetGeneric {
        public MethodsSetGroupGeneric(RCoreFunctions rdef) {
            super(rdef.METHODS_SETGROUPGENERIC_parameters);
        }
    }

    protected final class MethodsSetIs
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;
        private final int paramIdx_classToExtendName;
        private final int paramIdx_testF;
        private final int paramIdx_coerceF;
        private final int paramIdx_replaceF;

        public MethodsSetIs(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETIS_parameters;
            this.paramIdx_className = this.params.indexOf("class1");
            this.paramIdx_classToExtendName = this.params.indexOf("class2");
            this.paramIdx_testF = this.params.indexOf("test");
            this.paramIdx_coerceF = this.params.indexOf("coerce");
            this.paramIdx_replaceF = this.params.indexOf("replace");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            ElementAccess.Class access;
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameNode = args.getArgValueNode(this.paramIdx_className);
            RAstNode cToExtendNameNode = args.getArgValueNode(this.paramIdx_classToExtendName);
            RSourceElementByElementAccess.RClassExt rClassExt = null;
            BuildSourceFrame.RunScope envir = null;
            String extTypeName = null;
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                extTypeName = classNameNode.getText();
                access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(extTypeName, access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
                envir = new BuildSourceFrame.RunScope(5, BuildSourceFrame.createId(5, access.getSegmentName(), ++SourceAnalyzer.this.anonymCount), SourceAnalyzer.this.topScope);
                SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
                if (containerBuilder != null) {
                    rClassExt = new RSourceElementByElementAccess.RClassExt(containerBuilder.element, access, envir, "setIs");
                    SourceAnalyzer.this.registerClassExtElement(rClassExt);
                } else {
                    node.addAttachment(envir);
                }
            }
            if (cToExtendNameNode != null && cToExtendNameNode.getNodeType() == NodeType.STRING_CONST) {
                access = new ElementAccess.Class(node);
                access.flags = 0;
                access.nameNode = cToExtendNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(cToExtendNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(cToExtendNameNode);
                if (rClassExt != null) {
                    rClassExt.complete(extTypeName);
                }
            }
            if (rClassExt != null) {
                SourceAnalyzer.this.enterElement(rClassExt, envir, node);
                SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_testF), "test");
                SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_coerceF), "coerce");
                SourceAnalyzer.this.visitAndCheckValue(args.getArgNode(this.paramIdx_replaceF), "replace");
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
                SourceAnalyzer.this.leaveElement();
            } else {
                SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            }
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetMethod
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_fName;
        private final int paramIdx_signature;
        private final int paramIdx_fDef;

        public MethodsSetMethod(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETMETHOD_parameters;
            this.paramIdx_fName = this.params.indexOf("f");
            this.paramIdx_signature = this.params.indexOf("signature");
            this.paramIdx_fDef = this.params.indexOf("definition");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode fNameValue = args.getArgValueNode(this.paramIdx_fName);
            RAstNode fDefValue = args.getArgValueNode(this.paramIdx_fDef);
            if (fNameValue != null && fNameValue.getNodeType() == NodeType.STRING_CONST) {
                Object value;
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 18;
                access.nameNode = fNameValue;
                SourceAnalyzer.this.genericDefaultEnvir.add(fNameValue.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(fNameValue);
                Signature sig = SourceAnalyzer.this.readSignature(node, args.getArgValueNode(this.paramIdx_signature));
                Object object = value = fDefValue != null ? SourceAnalyzer.this.evalArgValue(fDefValue, NO_REQUESTS) : null;
                if (value instanceof RSourceElementByElementAccess.RMethod) {
                    RSourceElementByElementAccess.RMethod rMethod = (RSourceElementByElementAccess.RMethod)value;
                    SourceAnalyzer.this.registerFunctionElement(rMethod, 1408, access, sig);
                } else {
                    BuildSourceFrame.DefScope envir = new BuildSourceFrame.DefScope(5, BuildSourceFrame.createId(5, access.getSegmentName(), ++SourceAnalyzer.this.anonymCount), access.getSegmentName(), new BuildSourceFrame[]{SourceAnalyzer.this.topLevelEnvir});
                    SourceElementBuilder containerBuilder = SourceAnalyzer.this.getCurrentSourceContainerBuilder();
                    if (containerBuilder != null) {
                        RSourceElementByElementAccess.RMethod rMethod = new RSourceElementByElementAccess.RMethod((RLangSourceElement)containerBuilder.element, 1408, access, envir);
                        SourceAnalyzer.this.enterElement(rMethod, envir, node);
                        SourceAnalyzer.this.leaveElement();
                        SourceAnalyzer.this.registerFunctionElement(rMethod, 1408, access, sig);
                    } else {
                        SourceAnalyzer.this.addEnvirInsteadOfElement(envir, node);
                    }
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSetValidity
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_className;

        public MethodsSetValidity(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SETVALIDITY_parameters;
            this.paramIdx_className = this.params.indexOf("Class");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode classNameNode = args.getArgValueNode(this.paramIdx_className);
            if (classNameNode != null && classNameNode.getNodeType() == NodeType.STRING_CONST) {
                ElementAccess.Class access = new ElementAccess.Class(node);
                access.flags = 2;
                access.nameNode = classNameNode;
                SourceAnalyzer.this.genericDefaultEnvir.addClass(classNameNode.getText(), access);
                SourceAnalyzer.this.argValueToIgnore.add(classNameNode);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class MethodsSignature
    implements FCallAnalyzer {
        private final Parameters params;

        public MethodsSignature(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SIGNATURE_parameters;
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            Signature returnValue = null;
            if (args.ellipsisArgs.length > 0) {
                @Nullable ElementAccess[] argNameNodes = new ElementAccess[args.ellipsisArgs.length];
                @Nullable String[] classNames = new String[args.ellipsisArgs.length];
                int i = 0;
                while (i < args.ellipsisArgs.length) {
                    RAstNode valueNode;
                    FCall.Arg arg = args.ellipsisArgs[i];
                    RAstNode nameNode = arg.getNameChild();
                    if (nameNode != null && nameNode.getText() != null) {
                        ElementAccess.Default access = new ElementAccess.Default(node, nameNode);
                        access.flags = 32;
                        argNameNodes[i] = access;
                    }
                    if ((valueNode = arg.getValueChild()) != null && valueNode.getNodeType() == NodeType.STRING_CONST) {
                        classNames[i] = valueNode.getText();
                        SourceAnalyzer.this.registerSimpleClassAccessInEnvir(node, valueNode);
                        SourceAnalyzer.this.argValueToIgnore.add(valueNode);
                    }
                    ++i;
                }
                returnValue = new Signature(argNameNodes, classNames);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = returnValue;
        }
    }

    protected final class MethodsSlot
    implements FCallAnalyzer {
        private final Parameters params;
        private final int paramIdx_object;
        private final int paramIdx_slotName;

        public MethodsSlot(RCoreFunctions rdef) {
            this.params = rdef.METHODS_SLOT_parameters;
            this.paramIdx_object = this.params.indexOf("object");
            this.paramIdx_slotName = this.params.indexOf("name");
        }

        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            SourceAnalyzer.this.request = NO_REQUESTS;
            RAsts.FCallArgMatch args = RAsts.matchArgs(node.getArgsChild(), this.params, replValueArg, inject0ArgValues);
            RAstNode objectArg = args.getArgValueNode(this.paramIdx_object);
            RAstNode slotArg = args.getArgValueNode(this.paramIdx_slotName);
            if (objectArg != null && objectArg.getNodeType() == NodeType.SYMBOL) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = replValueArg != null ? 258 : 256;
                access.nameNode = objectArg;
                SourceAnalyzer.this.argValueToIgnore.add(objectArg);
                if (slotArg != null && slotArg.getNodeType() == NodeType.STRING_CONST) {
                    access.nextSegment = new SubNamedSlotSemanticElementAccess(access, slotArg);
                    SourceAnalyzer.this.argValueToIgnore.add(slotArg);
                }
                SourceAnalyzer.this.topScope.addLateResolve(objectArg.getText(), access);
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    protected final class NoDefFallback
    implements FCallAnalyzer {
        @Override
        public void visit(FCall node, @Nullable RAstNode replValueArg, ImList<RAstNode> inject0ArgValues) throws InvocationTargetException {
            FCall.Arg firstArg;
            RAstNode argValue;
            SourceAnalyzer.this.request = NO_REQUESTS;
            FCall.Args args = node.getArgsChild();
            if (args.getChildCount() > 0 && replValueArg != null && (argValue = (firstArg = args.getChild(0)).getValueChild()) != null) {
                ElementAccess.Default access = new ElementAccess.Default(node);
                access.flags = 2;
                String mainName = SourceAnalyzer.this.resolveElementName(argValue, access, false);
                SourceAnalyzer.this.argValueToIgnore.add(argValue);
                if (mainName != null) {
                    SourceAnalyzer.this.registerInEnvir(2, mainName, access);
                }
            }
            SourceAnalyzer.this.visitFCallArgs(node.getArgsChild(), inject0ArgValues);
            SourceAnalyzer.this.returnValue = null;
        }
    }

    private static class NodeArray
    extends ReturnValue {
        final RAstNode[] array;

        NodeArray(int returnType, RAstNode[] array) {
            super(returnType);
            this.array = array;
        }
    }

    private static class ReturnValue {
        final int returnType;

        ReturnValue(int returnType) {
            this.returnType = returnType;
        }
    }

    private class RoxygenAdapter
    implements RoxygenAnalyzeContext {
        private RSourceUnitModelInfoImpl modelInfo;
        private int counter;

        private RoxygenAdapter() {
        }

        @Override
        public RSourceUnitModelInfo getModelInfo() {
            return this.modelInfo;
        }

        @Override
        public void createSelfAccess(DocuTag docuTag, RLangSourceElement element, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            RElementAccess elementAccess = ((RSourceElementByElementAccess)element).getAccess();
            if (elementAccess != null && text.equals(elementAccess.getSegmentName()) && elementAccess.getNextSegment() == null) {
                ElementAccess.Default access = new ElementAccess.Default(docuTag, symbol);
                ((ElementAccess)elementAccess).shared.postAdd(access);
                return;
            }
        }

        @Override
        public void createNamespaceImportAccess(DocuTag docuTag, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            ElementAccess.Namespace access = new ElementAccess.Namespace(docuTag, symbol);
            access.flags |= 4;
            this.modelInfo.packageRefs.add(text, access);
        }

        @Override
        public void createNamespaceObjectImportAccess(DocuTag docuTag, RSourceFrame namespace, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            if (namespace instanceof BuildSourceFrame) {
                ElementAccess.Default access = new ElementAccess.Default(docuTag, symbol);
                BuildSourceFrame namespaceFrame = (BuildSourceFrame)namespace;
                BuildSourceFrame.ElementAccessList namespaceList = namespaceFrame.data.get(text);
                BuildSourceFrame next = this.modelInfo.localFrames.values().iterator().next();
                BuildSourceFrame.ElementAccessList defaultList = next.data.get(text);
                if (defaultList != null && defaultList.isCreated < 2) {
                    next.data.remove(text);
                    if (namespaceList != null) {
                        namespaceList.entries.addAll(defaultList.entries);
                        for (ElementAccess defaultAccess : defaultList.entries) {
                            defaultAccess.shared = namespaceList;
                        }
                        namespaceList.postAdd(access);
                    } else {
                        defaultList.frame = namespaceFrame;
                        defaultList.postAdd(access);
                        namespaceFrame.data.put(text, defaultList);
                    }
                } else if (namespaceList != null) {
                    namespaceList.postAdd(access);
                } else {
                    BuildSourceFrame.ElementAccessList accessList = new BuildSourceFrame.ElementAccessList(text);
                    accessList.frame = namespaceFrame;
                    accessList.postAdd(access);
                    namespaceFrame.data.put(text, accessList);
                }
            }
        }

        @Override
        public @Nullable RSourceFrame getNamespaceFrame(String name) {
            String id = BuildSourceFrame.createId(2, name, -1);
            BuildSourceFrame frame = this.modelInfo.namespaceFrames.get(id);
            if (frame == null) {
                frame = new BuildSourceFrame.DefScope(2, id, name, null);
                this.modelInfo.namespaceFrames.put(id, frame);
                return frame;
            }
            return null;
        }

        @Override
        public void createSlotAccess(DocuTag docuTag, RSourceElementByElementAccess.RClass rClass, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            BuildSourceFrame.ElementAccessList accessList = rClass.getBuildFrame().data.get(text);
            if (accessList == null) {
                return;
            }
            List<? extends RLangSourceElement> children = rClass.getSourceChildren(null);
            for (RLangSourceElement rLangSourceElement : children) {
                if (rLangSourceElement.getElementType() != 1664 || !text.equals(rLangSourceElement.getElementName().getSegmentName())) continue;
                ElementAccess.Slot access = new ElementAccess.Slot(docuTag, symbol);
                accessList.postAdd(access);
                return;
            }
        }

        @Override
        public void createArgAccess(DocuTag docuTag, RSourceElementByElementAccess.RMethod rMethod, RAstNode symbol) {
            String text = symbol.getText();
            if (text == null) {
                return;
            }
            BuildSourceFrame.ElementAccessList accessList = rMethod.getBuildFrame().data.get(text);
            if (accessList == null) {
                return;
            }
            List<? extends RLangSourceElement> children = rMethod.getSourceChildren(null);
            for (RLangSourceElement rLangSourceElement : children) {
                if (rLangSourceElement.getElementType() != 1585 || !text.equals(rLangSourceElement.getElementName().getSegmentName())) continue;
                ElementAccess.Default access = new ElementAccess.Default(docuTag, symbol);
                access.flags |= 0x20;
                accessList.postAdd(access);
                return;
            }
        }

        @Override
        public void createRSourceRegion(RAstNode node) {
            if (!SourceAnalyzer.this.roxygenExamples) {
                this.counter = 0;
                SourceAnalyzer.this.cleanup();
                SourceAnalyzer.this.init();
                SourceAnalyzer.this.roxygenExamples = true;
            }
            try {
                RoxygenRCodeElement element = new RoxygenRCodeElement(this.modelInfo.getSourceElement(), this.counter++, SourceAnalyzer.this.topLevelEnvir, node);
                SourceAnalyzer.this.enterElement(element, SourceAnalyzer.this.topLevelEnvir, node);
                node.acceptInRChildren(SourceAnalyzer.this);
                SourceAnalyzer.this.leaveElement();
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        public void update(RSourceUnitModelInfoImpl modelInfo) {
            this.modelInfo = modelInfo;
            SourceAnalyzer.this.roxygenAnalyzer.updateModel(SourceAnalyzer.this.roxygenAdapter);
        }
    }

    private static class Signature
    extends ReturnValue {
        private final @Nullable ElementAccess @Nullable [] argNameAccesses;
        private final @Nullable String[] classNames;

        Signature(@Nullable ElementAccess @Nullable [] argNameAccess, @Nullable String[] classNames) {
            super(2);
            this.argNameAccesses = argNameAccess;
            this.classNames = classNames;
        }
    }

    private static class SourceElementBuilder
    extends ReturnValue {
        private final @Nullable SourceElementBuilder parent;
        private final BuildSourceFrameElement element;
        private final List<RSourceElementByElementAccess> children;
        private final List<ElementAccess> toCheck;
        private final BuildSourceFrame envir;

        SourceElementBuilder(BuildSourceFrameElement element, @Nullable SourceElementBuilder parent, BuildSourceFrame envir) {
            super(1);
            this.element = element;
            this.parent = parent;
            this.children = new ArrayList<RSourceElementByElementAccess>();
            this.toCheck = new ArrayList<ElementAccess>();
            this.envir = envir;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SourceAnalyzer$SourceElementBuilder");
            sb.append("\n\tfor= ").append(this.element);
            sb.append("\n\tin= ").append(this.envir);
            return sb.toString();
        }
    }
}

