/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;

@NonNullByDefault
public class RSearchPattern
extends SearchPattern {
    private static final int NOT_CHECKED = -1;
    private int minCharCount;

    public RSearchPattern(int rules, String pattern) {
        super(rules, pattern);
    }

    protected void onPatternChanged(String pattern) {
        this.minCharCount = -1;
    }

    private int getR1MinCharCount() {
        int count = this.minCharCount;
        if (count == -1) {
            char[] pattern = this.getPatternChars();
            if (pattern.length > 0) {
                count = 1;
                int i = 1;
                while (i < pattern.length) {
                    char c = pattern[i];
                    if (c != '.' && c != '_') {
                        ++count;
                    }
                    ++i;
                }
            } else {
                count = 0;
            }
            this.minCharCount = count;
        }
        return count;
    }

    public int matches(String name) {
        int allowedRules = this.getRules();
        char[] patternChars = this.getPatternChars();
        char[] nameChars = null;
        int minCharCount = this.getR1MinCharCount();
        int lDiff = name.length() - minCharCount;
        if (lDiff >= 0) {
            if ((allowedRules & 4) != 0 && this.isR1PrefixMatch(patternChars, 0, patternChars.length, name, 0, name.length())) {
                return 4;
            }
            if (lDiff > 0 && patternChars.length > 0 && (allowedRules & 0x10) != 0 && this.isR1SubstringMatch(patternChars, 0, patternChars.length, minCharCount, nameChars = this.getNameChars(name), 1, nameChars.length)) {
                return 16;
            }
        }
        return 0;
    }

    protected boolean isR1PrefixMatch(char[] pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (nameEnd - nameStart == 0) {
            return false;
        }
        if (patternEnd - patternStart == 0) {
            return name.charAt(nameStart) != '.';
        }
        char patternChar = pattern[patternStart];
        char nameChar = Character.toLowerCase(name.charAt(nameStart));
        if (nameChar != patternChar) {
            return false;
        }
        int patternIdx = patternStart;
        int nameIdx = nameStart;
        while (true) {
            if (nameChar == patternChar) {
                if (++patternIdx >= patternEnd) {
                    return true;
                }
                if (++nameIdx >= nameEnd) break;
                patternChar = pattern[patternIdx];
                nameChar = Character.toLowerCase(name.charAt(nameIdx));
                continue;
            }
            if (patternChar == '.' || patternChar == '_') {
                if (++patternIdx >= patternEnd) {
                    return true;
                }
                patternChar = pattern[patternIdx];
                continue;
            }
            if (nameChar != '.' && nameChar != '_' || ++nameIdx >= nameEnd) break;
            nameChar = Character.toLowerCase(name.charAt(nameIdx));
        }
        return false;
    }

    protected boolean isR1PrefixMatch(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd) {
        if (nameEnd - nameStart == 0) {
            return false;
        }
        if (patternEnd - patternStart == 0) {
            return name[nameStart] != '.';
        }
        char nameChar = name[nameStart];
        char patternChar = pattern[patternStart];
        if (nameChar != patternChar) {
            return false;
        }
        int patternIdx = patternStart;
        int nameIdx = nameStart;
        while (true) {
            if (nameChar == patternChar) {
                if (++patternIdx >= patternEnd) {
                    return true;
                }
                if (++nameIdx >= nameEnd) break;
                patternChar = pattern[patternIdx];
                nameChar = name[nameIdx];
                continue;
            }
            if (patternChar == '.' || patternChar == '_') {
                if (++patternIdx >= patternEnd) {
                    return true;
                }
                patternChar = pattern[patternIdx];
                continue;
            }
            if (nameChar != '.' && nameChar != '_' || ++nameIdx >= nameEnd) break;
            nameChar = name[nameIdx];
        }
        return false;
    }

    protected boolean isR1SubstringMatch(char[] pattern, int patternStart, int patternEnd, int minCharCount, char[] name, int nameStart, int nameEnd) {
        int nameLastStart = nameEnd - minCharCount;
        int nameCurrentStart = nameStart;
        while (nameCurrentStart <= nameLastStart) {
            int nameIdx = nameCurrentStart;
            char nameChar = name[nameIdx];
            int patternIdx = patternStart;
            char patternChar = pattern[patternIdx];
            if (nameChar == patternChar) {
                while (true) {
                    if (nameChar == patternChar) {
                        if (++patternIdx >= patternEnd) {
                            return true;
                        }
                        if (++nameIdx >= nameEnd) break;
                        patternChar = pattern[patternIdx];
                        nameChar = name[nameIdx];
                        continue;
                    }
                    if (patternChar == '.' || patternChar == '_') {
                        if (++patternIdx >= patternEnd) {
                            return true;
                        }
                        patternChar = pattern[patternIdx];
                        continue;
                    }
                    if (nameChar != '.' && nameChar != '_' || ++nameIdx >= nameEnd) break;
                    nameChar = name[nameIdx];
                }
            }
            ++nameCurrentStart;
        }
        return false;
    }

    public int @Nullable [] getMatchingRegions(String name, int matchRule) {
        switch (matchRule) {
            case 2: 
            case 4: {
                char[] patternChars = this.getPatternChars();
                return this.getR1PrefixMatches(patternChars, 0, patternChars.length, name, 0, name.length());
            }
            case 16: {
                this.tmpRegions.clear();
                char[] patternChars = this.getPatternChars();
                char[] nameChars = this.getNameChars(name);
                this.addR1SubstringMatches(patternChars, 0, patternChars.length, this.getR1MinCharCount(), nameChars, 0, nameChars.length);
                return this.tmpRegions.toArray();
            }
        }
        return null;
    }

    private int @Nullable [] getR1PrefixMatches(char[] pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        int nameIdx;
        char patternChar;
        if (patternEnd - patternStart == 0) {
            return null;
        }
        if (patternEnd - patternStart == 1) {
            return new int[]{nameStart, nameStart + 1};
        }
        char nameChar = patternChar = pattern[patternStart];
        int patternIdx = patternStart;
        int matchEnd = nameIdx = nameStart;
        while (true) {
            if (nameChar != patternChar) {
                if (patternChar == '.' || patternChar == '_') {
                    if (++patternIdx >= patternEnd) {
                        return new int[]{nameStart, matchEnd};
                    }
                    patternChar = pattern[patternIdx];
                    continue;
                }
                if (nameChar == '.' || nameChar == '_') {
                    if (++nameIdx < nameEnd) {
                        nameChar = name.charAt(nameIdx);
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
            matchEnd = nameIdx + 1;
            if (++patternIdx >= patternEnd) {
                return new int[]{nameStart, matchEnd};
            }
            if (++nameIdx >= nameEnd) continue;
            patternChar = pattern[patternIdx];
            nameChar = name.charAt(nameIdx);
        }
    }

    private void addR1SubstringMatches(char[] pattern, int patternStart, int patternEnd, int minCharCount, char[] name, int nameStart, int nameEnd) {
        if (patternEnd - patternStart == 0) {
            return;
        }
        int nameLastStart = nameEnd - minCharCount;
        int nameCurrentStart = nameStart;
        block0: while (nameCurrentStart <= nameLastStart) {
            int nameIdx;
            int patternIdx = patternStart;
            int matchEnd = nameIdx = nameCurrentStart;
            char nameChar = name[nameIdx];
            char patternChar = pattern[patternIdx];
            if (nameChar == patternChar) {
                while (true) {
                    if (nameChar == patternChar) {
                        matchEnd = nameIdx + 1;
                        if (++patternIdx >= patternEnd) {
                            this.tmpRegions.add(nameCurrentStart);
                            this.tmpRegions.add(matchEnd);
                            nameCurrentStart = matchEnd;
                            continue block0;
                        }
                        if (++nameIdx >= nameEnd) break;
                        patternChar = pattern[patternIdx];
                        nameChar = name[nameIdx];
                        continue;
                    }
                    if (patternChar == '.' || patternChar == '_') {
                        if (++patternIdx >= patternEnd) {
                            this.tmpRegions.add(nameCurrentStart);
                            this.tmpRegions.add(matchEnd);
                            nameCurrentStart = matchEnd;
                            continue block0;
                        }
                        patternChar = pattern[patternIdx];
                        continue;
                    }
                    if (nameChar != '.' && nameChar != '_' || ++nameIdx >= nameEnd) break;
                    nameChar = name[nameIdx];
                }
            }
            ++nameCurrentStart;
        }
    }
}

