/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.util.List;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;

public class RPkgActionHelper {
    private final RuntimeRLibPaths rLibPaths;
    private final boolean sameLocation;
    private final RLibLocation defaultLibLocation;

    public RPkgActionHelper(boolean sameLocation, RLibLocation defaultLocation, RuntimeRLibPaths rLibPaths) {
        this.rLibPaths = rLibPaths;
        this.sameLocation = sameLocation;
        this.defaultLibLocation = defaultLocation;
    }

    public void updateLocation(RPkgAction.Install action) {
        IRPkgInfoAndData referencePkg;
        if (this.sameLocation && (referencePkg = action.getReferencePkg()) != null) {
            RLibLocation libLocation = referencePkg.getLibLocation();
            RLibLocationInfo info = this.rLibPaths.getInfo(libLocation);
            if (info != null && info.isWritable()) {
                action.setLibraryLocation(libLocation);
            }
            return;
        }
        if (this.defaultLibLocation == null) {
            throw new UnsupportedOperationException("missing default location");
        }
        action.setLibraryLocation(this.defaultLibLocation);
    }

    public void update(List<? extends RPkgAction.Install> actions) {
        for (RPkgAction.Install install : actions) {
            this.updateLocation(install);
        }
    }

    public int hashCode() {
        int h;
        int n = h = this.defaultLibLocation != null ? this.defaultLibLocation.hashCode() : 0;
        if (this.sameLocation) {
            ++h;
        }
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RPkgActionHelper) {
            RPkgActionHelper other = (RPkgActionHelper)obj;
            return Objects.equals(this.defaultLibLocation, other.defaultLibLocation) && this.sameLocation == other.sameLocation;
        }
        return false;
    }
}

