/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public abstract class AbstractSourceEditorHandler
extends AbstractHandler {
    protected static final Object ACTION_NOT_AVAILABLE = new Object();
    protected static final Object DOCUMENT_NOT_EDITABLE = new Object();
    private final @Nullable SourceEditor editor;

    public AbstractSourceEditorHandler() {
        this.editor = null;
    }

    public AbstractSourceEditorHandler(SourceEditor editor) {
        this.editor = (SourceEditor)ObjectUtils.nonNullAssert((Object)editor);
    }

    protected @Nullable SourceEditor getSourceEditor(@Nullable Object context) {
        SourceEditor editor = this.editor;
        if (editor != null) {
            return editor;
        }
        IWorkbenchPart part = WorkbenchUIUtils.getActivePart((Object)context);
        if (part != null) {
            if (part instanceof SourceEditor) {
                return (SourceEditor)part;
            }
            editor = (SourceEditor)part.getAdapter(SourceEditor.class);
            if (editor != null) {
                return editor;
            }
        }
        return null;
    }

    protected boolean isSupported(SourceEditor editor) {
        SourceViewer viewer = editor.getViewer();
        return UIAccess.isOkToUse((Viewer)viewer) && viewer.getDocument() != null;
    }

    protected boolean isEditAction() {
        return false;
    }

    protected boolean computeEnabled(SourceEditor editor, @Nullable Object evaluationContext) {
        return this.isSupported(editor) && (!this.isEditAction() || editor.isEditable(false));
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        SourceEditor editor = this.getSourceEditor(evaluationContext);
        this.setBaseEnabled(editor != null && this.computeEnabled(editor, evaluationContext));
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        SourceEditor editor = this.getSourceEditor(event.getApplicationContext());
        if (editor == null || !this.isSupported(editor)) {
            return null;
        }
        if (this.isEditAction() && !editor.isEditable(false)) {
            this.onDocumentNotEditable();
            return null;
        }
        Object result = this.execute(editor, event);
        if (result == ACTION_NOT_AVAILABLE) {
            this.onActionNotAvailable();
            return null;
        }
        if (result == DOCUMENT_NOT_EDITABLE) {
            this.onDocumentNotEditable();
            return null;
        }
        return result;
    }

    protected abstract @Nullable Object execute(SourceEditor var1, ExecutionEvent var2) throws ExecutionException;

    protected void onActionNotAvailable() {
        Display.getCurrent().beep();
    }

    protected void onDocumentNotEditable() {
        this.onActionNotAvailable();
    }
}

