/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.element.NameAccess;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

@NonNullByDefault
public class OpenDeclaration {
    public <T> @Nullable T selectElement(List<? extends T> list, IWorkbenchPart part) throws CoreException {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        ListDialog dialog = new ListDialog(part != null ? part.getSite().getShell() : UIAccess.getActiveWorkbenchShell((boolean)true));
        dialog.setTitle("Open Declaration");
        dialog.setMessage("Select the appropriate declaration:");
        dialog.setHelpAvailable(false);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider(this.createLabelProvider());
        dialog.setInput(list);
        dialog.setInitialSelections(new Object[]{list.get(0)});
        if (dialog.open() == 0) {
            return (T)dialog.getResult()[0];
        }
        throw new CoreException(Status.CANCEL_STATUS);
    }

    public <TNameAccess extends NameAccess<?, ?>> @Nullable TNameAccess selectAccess(List<? extends TNameAccess> accessList) {
        for (NameAccess candidate : accessList) {
            if (!candidate.isWriteAccess()) continue;
            return (TNameAccess)candidate;
        }
        return null;
    }

    public ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    public void open(SourceElement<?> element, boolean activate) throws PartInitException {
        IResource resource;
        SourceUnit su = element.getSourceUnit();
        if (su instanceof WorkspaceSourceUnit && (resource = ((WorkspaceSourceUnit)su).getResource()).getType() == 1) {
            this.open((IFile)resource, activate, element);
            return;
        }
    }

    public void open(IFile file, boolean activate, @Nullable SourceElement<?> element) throws PartInitException {
        TextRegion region;
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
        IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((IFile)file, (boolean)true, (boolean)true);
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editorPart = page.findEditor((IEditorInput)input);
        if (editorPart == null || !(editorPart instanceof ITextEditor)) {
            editorPart = page.openEditor((IEditorInput)input, editorDescriptor.getId(), activate);
        } else if (activate) {
            page.activate((IWorkbenchPart)editorPart);
        }
        if (element != null && editorPart instanceof ITextEditor && (region = LTKSelectionUtils.getRegionToSelect(element)) != null) {
            ((ITextEditor)editorPart).selectAndReveal(region.getStartOffset(), region.getLength());
        }
    }

    public void open(SourceEditor editor, NameAccess<?, ?> access) {
        AstNode node = access.getNameNode();
        if (node != null) {
            editor.selectAndReveal(node.getStartOffset(), node.getLength());
            return;
        }
        node = access.getNode();
        editor.selectAndReveal(node.getStartOffset(), 0);
    }
}

