/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ltk.ui.TemplatesMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.templates.TemplatePreview;
import org.eclipse.statet.ltk.ui.templates.config.EditTemplateDialog;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateCategoryConfiguration;
import org.eclipse.statet.ltk.ui.templates.config.ITemplateContribution;
import org.eclipse.statet.ltk.ui.templates.config.TemplateCategory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.ui.statushandlers.StatusManager;

public class CodeTemplateConfigurationBlock
extends ManagedConfigurationBlock
implements ButtonGroup.IActions<TemplateItem>,
ButtonGroup.IImportExportActions<TemplateItem> {
    public static final int ADD_ITEM = 1;
    public static final int LAZY_LOADING = 16;
    private static final int DEFAULT_MASK = 3840;
    public static final int DEFAULT_SINGLE = 256;
    public static final int DEFAULT_BY_CATEGORY = 512;
    private final int mode;
    private ImList<TemplateCategory> templateCategories;
    private TemplateDataAdapter dataAdapter;
    private ThisContentProvider contentProvider;
    private TreeViewer treeViewer;
    private ButtonGroup<TemplateItem> buttonGroup;
    private TemplatePreview preview;
    private String patternViewerConfiguredId = null;
    private final TemplateVariableProcessor editTemplateProcessor;
    private final Preference<String> defaultPref;
    private LocalResourceManager uiResources;

    private static boolean equalContent(Template t1, Template t2) {
        return t1.getDescription().equals(t2.getDescription()) && t1.getContextTypeId().equals(t2.getContextTypeId()) && t1.getPattern().equals(t2.getPattern());
    }

    public CodeTemplateConfigurationBlock(String title, int mode, List<? extends TemplateCategory> categories, Preference<String> defaultPref) throws CoreException {
        this(title, mode, defaultPref);
        this.setCategories(categories);
    }

    public CodeTemplateConfigurationBlock(String title, int mode, Preference<String> defaultPref) throws CoreException {
        super(null, title, null);
        if (defaultPref != null) {
            mode |= 0x100;
        }
        switch (mode & 0xF00) {
            case 0: {
                break;
            }
            case 256: {
                if (defaultPref != null) break;
                throw new NullPointerException("defaultPref");
            }
            case 512: {
                break;
            }
            default: {
                throw new IllegalArgumentException("mode");
            }
        }
        this.mode = mode;
        this.editTemplateProcessor = new TemplateVariableProcessor();
        this.defaultPref = defaultPref;
    }

    protected String getListLabel() {
        return TemplatesMessages.Config_DocTemplates_label;
    }

    protected void setCategories(List<? extends TemplateCategory> categories) {
        this.templateCategories = ImCollections.toList(categories);
    }

    protected List<TemplateCategory> getCategories() {
        return this.templateCategories;
    }

    protected TemplateCategory getCategory(String categoryId) {
        if (categoryId != null) {
            for (TemplateCategory category : this.templateCategories) {
                if (!category.getId().equals(categoryId)) continue;
                return category;
            }
        }
        return null;
    }

    protected String getCategoryId(Template template) {
        String name = template.getName();
        int idx = name.indexOf(58);
        return idx > 0 ? name.substring(0, idx) : name;
    }

    protected List<TemplateItem> getTemplates(TemplateCategory category) {
        Object[] children = (TemplateItem[])this.contentProvider.getChildren(category);
        return ImCollections.newList((Object[])children);
    }

    protected List<ITemplateContribution> getTemplateContributions(boolean activate) {
        ArrayList<ITemplateContribution> list = new ArrayList<ITemplateContribution>();
        for (TemplateCategory category : this.templateCategories) {
            ITemplateContribution contrib = category.getTemplateContrib(activate);
            if (list.contains(contrib)) continue;
            list.add(contrib);
        }
        return list;
    }

    public void dispose() {
        super.dispose();
        if (this.uiResources != null) {
            this.uiResources.dispose();
        }
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap prefs = new HashMap();
        if (this.defaultPref != null) {
            prefs.put(this.defaultPref, null);
        }
        this.setupPreferenceManager(prefs);
        Label label = new Label(pageComposite, 16384);
        label.setText(String.valueOf(this.getListLabel()) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.contentProvider = new ThisContentProvider();
        switch (this.mode & 0xF00) {
            case 256: {
                this.dataAdapter = new TemplateDataAdapter((ITreeContentProvider)this.contentProvider, (IObservableValue<String>)this.createObservable(this.defaultPref));
                break;
            }
            case 512: {
                this.dataAdapter = new TemplateDataAdapter((ITreeContentProvider)this.contentProvider, prefs);
                break;
            }
            default: {
                this.dataAdapter = new TemplateDataAdapter((ITreeContentProvider)this.contentProvider, null);
            }
        }
        Composite composite = new Composite(pageComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.treeViewer = this.createTreeViewer(composite);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonGroup = new ButtonGroup(composite, (ButtonGroup.IActions)this, false);
        this.buttonGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        if ((this.mode & 1) != 0) {
            this.buttonGroup.addAddButton(null);
            this.buttonGroup.addCopyButton(null);
        }
        this.buttonGroup.addEditButton(null);
        if ((this.mode & 1) != 0) {
            this.buttonGroup.addDeleteButton(null);
        }
        if ((this.mode & 0xF00) != 0) {
            this.buttonGroup.addSeparator();
            this.buttonGroup.addDefaultButton(null);
        }
        this.buttonGroup.addSeparator();
        this.buttonGroup.addImportButton(null);
        this.buttonGroup.addExportButton(null);
        this.preview = new TemplatePreview();
        label = new Label(pageComposite, 16384);
        label.setText(String.valueOf(TemplatesMessages.Preview_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SourceViewer viewer = this.preview.createSourceViewer(pageComposite);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = new PixelConverter(viewer.getControl()).convertHeightInCharsToPixels(6);
        viewer.getControl().setLayoutData((Object)gd);
        this.buttonGroup.connectTo((StructuredViewer)this.treeViewer, (DataAdapter)this.dataAdapter);
        this.treeViewer.setInput((Object)this.templateCategories.toArray());
        ViewerUtils.scheduleStandardSelection((TreeViewer)this.treeViewer);
        this.buttonGroup.refresh();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2818);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ThisLabelProvider());
        return viewer;
    }

    protected void updateSourceViewerInput(TemplateItem item) {
        if (item != null) {
            SourceEditorViewerConfigurator configurator;
            ITemplateCategoryConfiguration categoryConfig = item.category.getConfiguration();
            String viewerConfigId = categoryConfig.getViewerConfigId(item.data);
            if (viewerConfigId != this.patternViewerConfiguredId) {
                configurator = categoryConfig.createViewerConfiguator(viewerConfigId, item.data, this.preview.getTemplateVariableProcessor(), this.getProject());
                this.patternViewerConfiguredId = viewerConfigId;
            } else {
                configurator = null;
            }
            this.preview.updateSourceViewerInput(item.data.getTemplate(), item.category.getContextTypeRegistry(), configurator);
        } else {
            this.preview.updateSourceViewerInput(null, null, null);
        }
    }

    private Image getLocalImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/dummy");
        }
        if (this.uiResources == null) {
            this.uiResources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.uiResources.createImage(imageDescriptor);
    }

    public TemplateItem edit(int command, TemplateItem item, Object parent) {
        if (item == null) {
            TemplateCategory category = (TemplateCategory)parent;
            ITemplateContribution contrib = category.getTemplateContrib(true);
            if (contrib == null) {
                return null;
            }
            Template template = new Template("", "", category.getConfiguration().getDefaultContextTypeId(), "", false);
            item = new TemplateItem(category, contrib, new TemplatePersistenceData(template, true));
        }
        ITemplateCategoryConfiguration categoryConfig = item.category.getConfiguration();
        String viewerConfigId = categoryConfig.getViewerConfigId(item.data);
        EditTemplateDialog dialog = this.createEditDialog(item.data.getTemplate(), command, categoryConfig.createViewerConfiguator(viewerConfigId, item.data, this.editTemplateProcessor, this.getProject()), this.editTemplateProcessor, item.category.getContextTypeRegistry());
        if (dialog.open() == 0) {
            if ((command & 3) != 0) {
                Template template = dialog.getTemplate();
                template.setName(this.newName(item.category));
                item = new TemplateItem(item.category, item.contrib, new TemplatePersistenceData(dialog.getTemplate(), true));
            } else {
                item.data.setTemplate(dialog.getTemplate());
            }
            return item;
        }
        return null;
    }

    protected EditTemplateDialog createEditDialog(Template template, int command, SourceEditorViewerConfigurator configurator, TemplateVariableProcessor processor, ContextTypeRegistry registry) {
        return new EditTemplateDialog(this.getShell(), template, (command & 3) != 0, 2, configurator, processor, registry, "org.eclipse.statet.ltk.ui/templates/config");
    }

    private String newName(TemplateCategory category) {
        String s;
        while (category.hasName(s = String.valueOf(category.getId()) + ":" + System.currentTimeMillis())) {
        }
        return s;
    }

    public void updateState(IStructuredSelection selection) {
        TemplateItem item = selection.size() == 1 && this.buttonGroup.getDataAdapter().isContentItem(selection.getFirstElement()) ? (TemplateItem)selection.getFirstElement() : null;
        this.updateSourceViewerInput(item);
    }

    public void importItems() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(TemplatesMessages.Config_Import_title);
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                finally {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.buttonGroup.refresh();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        Template template = data.getTemplate();
        TemplateCategory category = this.getCategory(this.getCategoryId(template));
        if (category == null) {
            return;
        }
        if (category.initNames()) {
            this.contentProvider.getChildren(category);
        }
        if (data.isUserAdded() && category.hasName(data.getTemplate().getName())) {
            if (this.contentProvider.containsItem(category, data.getTemplate())) {
                return;
            }
            data.getTemplate().setName(this.newName(category));
        }
        if (data.isUserAdded() && this.contentProvider.containsItemContent(category, data.getTemplate())) {
            return;
        }
        ITemplateContribution contribution = category.getTemplateContrib(true);
        if (contribution == null) {
            return;
        }
        contribution.add(category.getId(), data);
    }

    public void exportItems(List<? extends Object> items) {
        TemplatePersistenceData[] array = new TemplatePersistenceData[items.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = ((TemplateItem)items.get((int)i)).data;
            ++i;
        }
        this.doExport(array);
    }

    private void doExport(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(NLS.bind((String)TemplatesMessages.Config_Export_title, (Object)String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setFileName(TemplatesMessages.Config_Export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            MessageDialog.openError((Shell)this.getShell(), (String)TemplatesMessages.Config_Export_error_title, (String)NLS.bind((String)TemplatesMessages.Config_Export_error_Hidden_message, (Object)file.getAbsolutePath()));
            return;
        }
        if (file.exists() && !file.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)TemplatesMessages.Config_Export_error_title, (String)NLS.bind((String)TemplatesMessages.Config_Export_error_CanNotWrite_message, (Object)file.getAbsolutePath()));
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            BufferedOutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, (OutputStream)output);
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                IOUtils.close(output, (Throwable)e);
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)TemplatesMessages.Config_Export_Exists_title, (String)NLS.bind((String)TemplatesMessages.Config_Export_Exists_message, (Object)file.getAbsolutePath()));
    }

    public void performDefaults() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CodeTemplateConfigurationBlock.this.doPerformDefaults();
            }
        });
    }

    protected void doPerformDefaults() {
        boolean completly = true;
        if ((this.mode & 1) != 0) {
            DefaultsDialog dialog = new DefaultsDialog(this.getShell());
            if (dialog.open() != 0) {
                return;
            }
            completly = dialog.completely;
        }
        List<ITemplateContribution> templateContributions = this.getTemplateContributions(true);
        if (completly) {
            for (ITemplateContribution contrib : templateContributions) {
                if (contrib == null) continue;
                contrib.restoreDefaults();
            }
            for (TemplateCategory category : this.templateCategories) {
                if (this.dataAdapter.defaultValues != null) {
                    this.dataAdapter.getDefaultFor(category);
                }
                category.clearNames();
            }
            super.performDefaults();
        } else {
            for (ITemplateContribution contrib : templateContributions) {
                if (contrib == null) continue;
                contrib.restoreDeleted();
            }
        }
        this.buttonGroup.refresh();
    }

    private boolean hasDeleted() {
        List<ITemplateContribution> templateContributions = this.getTemplateContributions((this.mode & 0x10) == 0);
        for (ITemplateContribution contrib : templateContributions) {
            if (contrib != null && !contrib.hasDeleted()) continue;
            return true;
        }
        return false;
    }

    public boolean performOk(int flags) {
        List<ITemplateContribution> templateContributions = this.getTemplateContributions(false);
        for (ITemplateContribution contrib : templateContributions) {
            if (contrib == null) continue;
            try {
                contrib.saveEdits();
            }
            catch (IOException e) {
                this.openWriteErrorDialog(e);
            }
        }
        return super.performOk(flags);
    }

    public void performCancel() {
        List<ITemplateContribution> templateContributions = this.getTemplateContributions(false);
        for (ITemplateContribution contrib : templateContributions) {
            if (contrib == null) continue;
            try {
                contrib.revertEdits();
            }
            catch (IOException e) {
                this.openReadErrorDialog(e);
            }
        }
        super.performCancel();
    }

    private void openReadErrorDialog(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", 0, TemplatesMessages.Config_error_Read_message, (Throwable)e), 3);
    }

    private void openWriteErrorDialog(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", 0, TemplatesMessages.Config_error_Write_message, (Throwable)e), 3);
    }

    private class DefaultsDialog
    extends MessageDialog {
        private Button completeControl;
        private Button deletedControl;
        private boolean completely;

        public DefaultsDialog(Shell parentShell) {
            super(parentShell, TemplatesMessages.Config_RestoreDefaults_title, null, String.valueOf(TemplatesMessages.Config_RestoreDefaults_title) + ": " + CodeTemplateConfigurationBlock.this.getTitle(), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
            this.completeControl = new Button(composite, 16);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            this.completeControl.setLayoutData((Object)gd);
            this.completeControl.setText(TemplatesMessages.Config_RestoreDefaults_Completely_label);
            this.deletedControl = new Button(composite, 16);
            gd = new GridData(4, 4, true, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            this.deletedControl.setLayoutData((Object)gd);
            this.deletedControl.setText(TemplatesMessages.Config_RestoreDefaults_Deleted_label);
            if (!CodeTemplateConfigurationBlock.this.hasDeleted()) {
                this.deletedControl.setEnabled(false);
            }
            this.completeControl.setSelection(true);
            return composite;
        }

        protected void buttonPressed(int buttonId) {
            this.completely = this.completeControl.getSelection();
            super.buttonPressed(buttonId);
        }
    }

    private class TemplateDataAdapter
    extends DataAdapter.TreeAdapter<TemplateItem> {
        private final @Nullable Map<String, IObservableValue<String>> defaultValues;
        private final @Nullable Map<Preference<?>, String> prefs;

        public TemplateDataAdapter(ITreeContentProvider treeProvider, IObservableValue<String> defaultValue) {
            super(treeProvider, defaultValue);
            this.prefs = null;
            this.defaultValues = null;
        }

        public TemplateDataAdapter(ITreeContentProvider treeProvider, Map<Preference<?>, String> prefs) {
            super(treeProvider, null);
            this.prefs = prefs;
            this.defaultValues = new HashMap<String, IObservableValue<String>>();
        }

        public boolean isContentItem(@Nullable Object element) {
            return element instanceof TemplateItem;
        }

        protected @Nullable ITemplateContribution getContainerFor(Object element) {
            if (element instanceof TemplateItem) {
                return ((TemplateItem)element).contrib;
            }
            return null;
        }

        protected Object getDefaultValue(TemplateItem item) {
            return item.data.getTemplate().getName();
        }

        protected IObservableValue<String> getDefaultFor(TemplateItem item) {
            if (this.defaultValues != null) {
                return this.getDefaultFor(item.category);
            }
            return super.getDefaultFor((Object)item);
        }

        protected IObservableValue<String> getDefaultFor(TemplateCategory category) {
            Preference<String> pref;
            IObservableValue observableValue = this.defaultValues.get(category.getId());
            if (observableValue == null && (pref = category.getDefaultPref()) != null) {
                this.prefs.put(pref, null);
                observableValue = CodeTemplateConfigurationBlock.this.createObservable(pref);
                this.defaultValues.put(category.getId(), (IObservableValue<String>)observableValue);
            }
            return observableValue;
        }

        public Object change(TemplateItem oldItem, TemplateItem newItem, Object parent, Object container) {
            ITemplateContribution contrib = newItem.contrib;
            if (oldItem == null) {
                contrib.add(newItem.category.getId(), newItem.data);
            } else {
                this.changeDefault(oldItem, newItem);
            }
            this.changeChecked(oldItem, newItem);
            return newItem;
        }

        public void delete(List<? extends Object> elements) {
            this.deleteDefault(elements);
            for (Object object : elements) {
                ITemplateContribution contrib = this.getContainerFor(object);
                if (contrib == null) continue;
                contrib.delete(((TemplateItem)object).data);
            }
            this.deleteChecked(elements);
        }
    }

    @NonNullByDefault
    protected static class TemplateItem {
        private final TemplateCategory category;
        private final ITemplateContribution contrib;
        private final TemplatePersistenceData data;

        public TemplateItem(TemplateCategory category, ITemplateContribution contrib, TemplatePersistenceData data) {
            this.category = category;
            this.contrib = contrib;
            this.data = data;
        }

        public TemplateCategory getCategory() {
            return this.category;
        }

        public TemplatePersistenceData getData() {
            return this.data;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TemplateItem) {
                TemplateItem other = (TemplateItem)obj;
                return this.contrib == other.contrib && this.category.equals(other.category) && this.data.equals((Object)other.data);
            }
            return false;
        }
    }

    private class ThisContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public @Nullable Object getParent(Object element) {
            if (element instanceof TemplateItem) {
                return ((TemplateItem)element).category;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof TemplateCategory;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TemplateCategory) {
                final TemplateCategory category = (TemplateCategory)parentElement;
                final ArrayList<TemplateItem> items = new ArrayList<TemplateItem>();
                if (category.initNames() || !category.isTemplateLoaded()) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ThisContentProvider.this.doGetChildren(category, items);
                        }
                    });
                } else {
                    this.doGetChildren(category, items);
                }
                return items.toArray(new TemplateItem[items.size()]);
            }
            return new Object[0];
        }

        protected void doGetChildren(TemplateCategory category, List<TemplateItem> items) {
            ITemplateContribution contrib = category.getTemplateContrib(true);
            List<? extends TemplatePersistenceData> templates = contrib.getTemplates(category.getId());
            if (templates != null) {
                for (TemplatePersistenceData templatePersistenceData : templates) {
                    Template contribTemplate = templatePersistenceData.getTemplate();
                    if (!CodeTemplateConfigurationBlock.this.getCategoryId(contribTemplate).equals(category.getId())) continue;
                    category.addName(contribTemplate.getName());
                    items.add(new TemplateItem(category, contrib, templatePersistenceData));
                }
            }
        }

        public TemplateItem findItemByName(TemplateCategory category, String name) {
            ITemplateContribution contrib = category.getTemplateContrib(true);
            List<? extends TemplatePersistenceData> templates = contrib.getTemplates(category.getId());
            if (templates != null) {
                for (TemplatePersistenceData templatePersistenceData : templates) {
                    Template contribTemplate = templatePersistenceData.getTemplate();
                    if (!contribTemplate.getName().equals(name)) continue;
                    return new TemplateItem(category, contrib, templatePersistenceData);
                }
            }
            return null;
        }

        public boolean containsItem(TemplateCategory category, Template template) {
            TemplateItem item = this.findItemByName(category, template.getName());
            return item != null && template.equals((Object)item.data.getTemplate());
        }

        public boolean containsItemContent(TemplateCategory category, Template template) {
            ITemplateContribution contrib = category.getTemplateContrib(true);
            List<? extends TemplatePersistenceData> templates = contrib.getTemplates(category.getId());
            if (templates != null) {
                for (TemplatePersistenceData templatePersistenceData : templates) {
                    Template contribTemplate = templatePersistenceData.getTemplate();
                    if (!CodeTemplateConfigurationBlock.this.getCategoryId(contribTemplate).equals(category.getId()) || !CodeTemplateConfigurationBlock.equalContent(contribTemplate, template)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class ThisLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof TemplateCategory) {
                return CodeTemplateConfigurationBlock.this.getLocalImage(((TemplateCategory)element).getImage());
            }
            if (element instanceof TemplateItem) {
                TemplateItem item = (TemplateItem)element;
                Image image = CodeTemplateConfigurationBlock.this.getLocalImage(item.category.getItemImage());
                IObservableValue<String> defaultValue = CodeTemplateConfigurationBlock.this.dataAdapter.getDefaultFor(item);
                if (defaultValue != null && item.data.getTemplate().getName().equals(defaultValue.getValue())) {
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[3] = SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/default_marker");
                    return CodeTemplateConfigurationBlock.this.getLocalImage((ImageDescriptor)new DecorationOverlayIcon(image, imageDescriptorArray, new Point(image.getBounds().width, image.getBounds().height)));
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TemplateCategory) {
                return ((TemplateCategory)element).getLabel();
            }
            if (element instanceof TemplateItem) {
                return ((TemplateItem)element).data.getTemplate().getDescription();
            }
            return super.getText(element);
        }
    }
}

