/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.SourceStructContentProvider;

@NonNullByDefault
public class ExtModelContentProvider
implements ITreeContentProvider {
    private static final @NonNull SourceStructElement<?, ?>[] NO_CHILDREN = new SourceStructElement[0];
    protected static final SourceStructContentProvider NO_PROVIDER = new SourceStructContentProvider(){};
    private final IdentityHashMap<String, SourceStructContentProvider> providers = new IdentityHashMap(4);
    private final ModelContent content;
    private final ArrayList<SourceStructElement<?, ?>> filteredChildren = new ArrayList();

    public ExtModelContentProvider(ModelContent content) {
        this.content = content;
    }

    public void dispose() {
        for (SourceStructContentProvider provider : this.providers.values()) {
            if (!(provider instanceof Disposable)) continue;
            ((Disposable)provider).dispose();
        }
        this.providers.clear();
    }

    protected final ModelContent getContent() {
        return this.content;
    }

    public @Nullable SourceModelStamp getStamp(Object inputElement) {
        SourceUnitModelInfo modelInfo = this.getContent().getModelInfo(inputElement);
        return modelInfo != null ? modelInfo.getStamp() : null;
    }

    public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
    }

    protected @Nullable SourceStructContentProvider getSourceStructContentProvider(@Nullable String modelId) {
        if (modelId == null) {
            return null;
        }
        SourceStructContentProvider provider = this.providers.get(modelId);
        if (provider == null) {
            provider = (SourceStructContentProvider)LtkModels.getModelAdapter((String)modelId, SourceStructContentProvider.class);
            if (provider == null) {
                provider = NO_PROVIDER;
            }
            this.providers.put(modelId, provider);
        }
        return provider != NO_PROVIDER ? provider : null;
    }

    protected void addProvider(String modelId, SourceStructContentProvider provider) {
        this.providers.put(modelId, provider);
    }

    private @NonNull SourceStructElement<?, ?>[] filter(List<? extends SourceStructElement<?, ?>> elements, @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        if (elements.isEmpty()) {
            return NO_CHILDREN;
        }
        if (filter == null) {
            return elements.toArray(new SourceStructElement[elements.size()]);
        }
        try {
            for (SourceStructElement<?, ?> element : elements) {
                if (!filter.include(element)) continue;
                this.filteredChildren.add(element);
            }
            SourceStructElement[] sourceStructElementArray = this.filteredChildren.toArray(new SourceStructElement[elements.size()]);
            return sourceStructElementArray;
        }
        finally {
            this.filteredChildren.clear();
        }
    }

    private boolean skipToForeignElement(@Nullable SourceStructElement<?, ?> element) {
        return element != null && (element.getElementType() & 0xF00) == 2048;
    }

    protected boolean skipInTree(SourceStructElement<?, ?> element) {
        return false;
    }

    protected @NonNull SourceStructElement<?, ?>[] getElements(@Nullable SourceUnitModelInfo modelInfo) {
        if (modelInfo != null) {
            return this.getChildren(modelInfo.getSourceElement());
        }
        return NO_CHILDREN;
    }

    protected @Nullable SourceStructElement<?, ?> getParent(SourceStructElement<?, ?> element) {
        SourceStructElement parent = element.getSourceParent();
        while (parent != null && (this.skipToForeignElement(parent) || this.skipInTree(parent))) {
            parent = parent.getSourceParent();
        }
        return parent;
    }

    protected boolean hasChildren(@Nullable SourceStructElement<?, ?> element) {
        if (element != null) {
            SourceStructContentProvider provider = this.getSourceStructContentProvider(element.getModelTypeId());
            if (provider != null) {
                return provider.hasSourceChildren(element, this.getContent().getContentFilter());
            }
            return element.hasSourceChildren(this.getContent().getContentFilter());
        }
        return false;
    }

    protected @NonNull SourceStructElement<?, ?>[] getChildren(@Nullable SourceStructElement<?, ?> element) {
        if (element != null) {
            try {
                SourceStructContentProvider provider = this.getSourceStructContentProvider(element.getModelTypeId());
                if (provider != null) {
                    List<SourceStructElement<?, ?>> children = provider.getSourceChildren(element, this.getContent().getContentFilter(), this.filteredChildren);
                    SourceStructElement[] sourceStructElementArray = children.toArray(new SourceStructElement[children.size()]);
                    return sourceStructElementArray;
                }
                List children = LtkModelUtils.filter((List)element.getSourceChildren(null), this.getContent().getContentFilter(), this.filteredChildren);
                SourceStructElement[] sourceStructElementArray = children.toArray(new SourceStructElement[children.size()]);
                return sourceStructElementArray;
            }
            finally {
                this.filteredChildren.clear();
            }
        }
        return NO_CHILDREN;
    }

    public @NonNull Object[] getElements(Object inputElement) {
        return this.getElements(this.getContent().getModelInfo(inputElement));
    }

    public @Nullable Object getParent(Object element) {
        if (element instanceof SourceStructElement) {
            return this.getParent((SourceStructElement)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SourceStructElement) {
            SourceStructElement sourceElement = (SourceStructElement)element;
            if (this.skipToForeignElement(sourceElement)) {
                sourceElement = ((EmbeddingForeignElement)element).getForeignElement();
            }
            return this.hasChildren(sourceElement);
        }
        return false;
    }

    public @NonNull Object[] getChildren(Object element) {
        if (element instanceof SourceStructElement) {
            SourceStructElement sourceElement = (SourceStructElement)element;
            if (this.skipToForeignElement(sourceElement)) {
                sourceElement = ((EmbeddingForeignElement)element).getForeignElement();
            }
            return this.getChildren(sourceElement);
        }
        return NO_CHILDREN;
    }

    public static interface ModelContent {
        public @Nullable SourceUnitModelInfo getModelInfo(Object var1);

        public @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> getContentFilter();
    }
}

