/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class IndentUtil {
    public static final int COLUMN_IDX = 0;
    public static final int OFFSET_IDX = 1;
    private final IDocument document;
    private final int tabWidth;
    private final boolean tabAsDefault;
    private final int numOfSpaces;
    private final EditStrategy editStrategy;

    public static final char[] repeat(char c, int n) {
        char[] chars = new char[n];
        Arrays.fill(chars, c);
        return chars;
    }

    public IndentUtil(IDocument document, IIndentSettings settings) {
        this.document = document;
        this.editStrategy = settings.getReplaceConservative() ? new ConserveStrategy() : new CorrectStrategy();
        this.tabAsDefault = settings.getIndentDefaultType() == IIndentSettings.IndentationType.TAB;
        this.tabWidth = settings.getTabSize();
        this.numOfSpaces = settings.getIndentSpacesCount();
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    @Deprecated
    public int[] getLineIndent(int line, boolean markBlankLine) throws BadLocationException {
        IRegion lineInfo = this.document.getLineInformation(line);
        int column = 0;
        int offset = lineInfo.getOffset();
        block5: while (true) {
            int c = this.getDocumentChar(offset++);
            switch (c) {
                case 32: {
                    ++column;
                    continue block5;
                }
                case 9: {
                    column += this.tabWidth - column % this.tabWidth;
                    continue block5;
                }
                case -1: 
                case 10: 
                case 13: {
                    if (!markBlankLine) break block5;
                    return new int[]{-1, --offset};
                }
            }
            break;
        }
        return new int[]{column, --offset};
    }

    public String copyLineIndent(int line) throws BadLocationException {
        return this.editStrategy.copyLineIndent(line);
    }

    public int getMultilineIndentColumn(int startLine, int endLine) throws BadLocationException {
        int indentation = Integer.MAX_VALUE;
        int line = startLine;
        while (line <= endLine) {
            int[] lineIndent = this.getLineIndent(line, true);
            if (lineIndent[0] >= 0) {
                indentation = Math.min(indentation, lineIndent[0]);
            }
            ++line;
        }
        if (indentation == Integer.MAX_VALUE) {
            indentation = 0;
        }
        return indentation;
    }

    public void editInIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
        this.editStrategy.editInIndent(firstLine, lastLine, action);
    }

    public void changeIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
        this.editStrategy.changeIndent(firstLine, lastLine, action);
    }

    public final ILineIndent getIndent(CharSequence line) {
        int offset = 0;
        int column = 0;
        block5: while (offset < line.length()) {
            char c = line.charAt(offset);
            switch (c) {
                case ' ': {
                    ++column;
                    break;
                }
                case '\t': {
                    column += this.tabWidth - column % this.tabWidth;
                    break;
                }
                case '\n': 
                case '\r': {
                    break block5;
                }
                default: {
                    return new LineIndent.NonBlank(0, offset, column);
                }
            }
            ++offset;
        }
        return new LineIndent.Blank(0, offset, column);
    }

    public final int getColumn(CharSequence line, int offset) {
        int checkOffset = 0;
        int column = 0;
        while (checkOffset < offset) {
            switch (line.charAt(checkOffset++)) {
                case '\t': {
                    column += this.tabWidth - column % this.tabWidth;
                    break;
                }
                default: {
                    ++column;
                }
            }
        }
        return column;
    }

    public final int getColumn(CharSequence line, int offset, int startColumn) {
        int checkOffset = 0;
        int column = startColumn;
        while (checkOffset < offset) {
            switch (line.charAt(checkOffset++)) {
                case '\t': {
                    column += this.tabWidth - column % this.tabWidth;
                    break;
                }
                default: {
                    ++column;
                }
            }
        }
        return column;
    }

    public final int getIndentedOffsetAt(CharSequence line, int column) {
        int currentOffset = 0;
        int currentColumn = 0;
        while (currentOffset < line.length() && currentColumn < column) {
            char c = line.charAt(currentOffset);
            switch (c) {
                case ' ': {
                    ++currentColumn;
                    break;
                }
                case '\t': {
                    currentColumn += this.tabWidth - currentColumn % this.tabWidth;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.createNoIndentationCharMessage(c));
                }
            }
            ++currentOffset;
        }
        return currentOffset;
    }

    public final ILineIndent getIndent(int lineNum) throws BadLocationException {
        int offset = this.document.getLineOffset(lineNum);
        int column = 0;
        int bound = this.document.getLength();
        block5: while (offset < bound) {
            char c = this.document.getChar(offset);
            switch (c) {
                case ' ': {
                    ++column;
                    break;
                }
                case '\t': {
                    column += this.tabWidth - column % this.tabWidth;
                    break;
                }
                case '\n': 
                case '\r': {
                    break block5;
                }
                default: {
                    return new LineIndent.NonBlank(0, offset, column);
                }
            }
            ++offset;
        }
        return new LineIndent.Blank(0, offset, column);
    }

    public final int getColumn(int offset) throws BadLocationException {
        return this.getColumn(this.document.getLineOfOffset(offset), offset);
    }

    public final int getColumn(int lineNum, int offset) throws BadLocationException {
        int checkOffset = this.document.getLineOffset(lineNum);
        int column = 0;
        while (checkOffset < offset) {
            switch (this.document.getChar(checkOffset++)) {
                case '\t': {
                    column += this.tabWidth - column % this.tabWidth;
                    break;
                }
                default: {
                    ++column;
                }
            }
        }
        return column;
    }

    public final int getIndentedOffsetAt(int lineNum, int column) throws BadLocationException {
        IRegion lineInfo = this.document.getLineInformation(lineNum);
        int currentOffset = lineInfo.getOffset();
        int currentColumn = 0;
        while (currentColumn < column) {
            char c = this.document.getChar(currentOffset++);
            switch (c) {
                case ' ': {
                    ++currentColumn;
                    break;
                }
                case '\t': {
                    currentColumn += this.tabWidth - currentColumn % this.tabWidth;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.createNoIndentationCharMessage(c));
                }
            }
        }
        return currentOffset;
    }

    public final int getOffsetAtMax(int lineNum, int column) throws BadLocationException {
        IRegion lineInfo = this.document.getLineInformation(lineNum);
        int offset = lineInfo.getOffset();
        int bound = lineInfo.getLength();
        int current = 0;
        while (current < column) {
            if (offset >= bound) {
                return -1;
            }
            switch (this.document.getChar(offset++)) {
                case '\t': {
                    current += this.tabWidth - current % this.tabWidth;
                    break;
                }
                default: {
                    ++current;
                }
            }
        }
        return current > column ? offset - 1 : offset;
    }

    public int getLevelColumns() {
        if (this.tabAsDefault) {
            return this.tabWidth;
        }
        return this.numOfSpaces;
    }

    public int getNextLevelColumn(int currentColumn, int levels) {
        int columns = this.getLevelColumns();
        return (currentColumn / columns + levels) * columns;
    }

    public String createIndentString(int indentColumn) {
        if (this.tabAsDefault) {
            return new StringBuilder(indentColumn).append(IndentUtil.repeat('\t', indentColumn / this.tabWidth)).append(IndentUtil.repeat(' ', indentColumn % this.tabWidth)).toString();
        }
        return new String(IndentUtil.repeat(' ', indentColumn));
    }

    public final String createIndentCompletionString(int currentColumn) {
        if (this.tabAsDefault) {
            return "\t";
        }
        int rest = currentColumn % this.numOfSpaces;
        return new String(IndentUtil.repeat(' ', this.numOfSpaces - rest));
    }

    public final String createTabCompletionString(int currentColumn) {
        if (this.tabAsDefault) {
            return "\t";
        }
        return this.createTabSpacesCompletionString(currentColumn);
    }

    public final String createTabSpacesCompletionString(int currentColumn) {
        int rest = currentColumn % this.tabWidth;
        return new String(IndentUtil.repeat(' ', this.tabWidth - rest));
    }

    protected final int getDocumentChar(int idx) throws BadLocationException {
        if (idx >= 0 && idx < this.document.getLength()) {
            return this.document.getChar(idx);
        }
        if (idx == -1 || idx == this.document.getLength()) {
            return -1;
        }
        throw new BadLocationException();
    }

    public final void appendIndent(StringBuilder sb, int indentColumn) {
        if (this.tabAsDefault) {
            sb.append(IndentUtil.repeat('\t', indentColumn / this.tabWidth));
            sb.append(IndentUtil.repeat(' ', indentColumn % this.tabWidth));
        } else {
            sb.append(IndentUtil.repeat(' ', indentColumn));
        }
    }

    public final void appendIndent(StringBuilder sb, int currentColumn, int indentColumn) {
        if (this.tabAsDefault) {
            int tabDiff = indentColumn / this.tabWidth - currentColumn / this.tabWidth;
            if (tabDiff > 0) {
                int spaces = currentColumn % this.tabWidth;
                if (spaces > 0) {
                    sb.append(IndentUtil.repeat(' ', this.tabWidth - spaces));
                    sb.append(IndentUtil.repeat('\t', tabDiff - 1));
                } else {
                    sb.append(IndentUtil.repeat('\t', tabDiff));
                }
                sb.append(IndentUtil.repeat(' ', indentColumn % this.tabWidth));
            } else {
                sb.append(IndentUtil.repeat(' ', indentColumn - currentColumn));
            }
        } else {
            sb.append(IndentUtil.repeat(' ', indentColumn));
        }
    }

    protected final void appendSpaces(StringBuilder s, int num) {
        s.append(IndentUtil.repeat(' ', num));
    }

    private String createNoIndentationCharMessage(int c) {
        return NLS.bind((String)"No indentation char: ''{0}''.", (Object)Character.valueOf((char)c));
    }

    private class ConserveStrategy
    implements EditStrategy {
        private ConserveStrategy() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void editInIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
            replacement = new StringBuilder(20);
            line = firstLine;
            while (line <= lastLine) {
                block12: {
                    lineInfo = IndentUtil.this.document.getLineInformation(line);
                    indentColumn = action.getIndentColumn(line, lineInfo.getOffset());
                    if (indentColumn < 0) break block12;
                    if (indentColumn <= 0) ** GOTO lbl-1000
                    replacement.setLength(0);
                    indentation = 0;
                    offset = lineInfo.getOffset();
                    changed = false;
                    while (indentation < indentColumn) {
                        c = IndentUtil.this.getDocumentChar(offset);
                        switch (c) {
                            case 32: {
                                ++indentation;
                                ++offset;
                                replacement.append(' ');
                                break;
                            }
                            case 9: {
                                tabStart = indentation / IndentUtil.this.tabWidth * IndentUtil.this.tabWidth;
                                tabEnd = tabStart + IndentUtil.this.tabWidth;
                                if (tabEnd > indentColumn) {
                                    spaceCount = tabEnd - indentation;
                                    replacement.append(IndentUtil.repeat(' ', spaceCount));
                                    changed = true;
                                } else {
                                    replacement.append('\t');
                                }
                                indentation = tabEnd;
                                ++offset;
                                break;
                            }
                            case -1: 
                            case 10: 
                            case 13: {
                                tabStart = indentation / IndentUtil.this.tabWidth * IndentUtil.this.tabWidth;
                                tabEnd = tabStart + IndentUtil.this.tabWidth;
                                if (IndentUtil.this.tabAsDefault && tabEnd <= indentColumn) {
                                    spaceCount = indentation - tabStart;
                                    replacement.delete(replacement.length() - spaceCount, replacement.length());
                                    replacement.append('\t');
                                    indentation = tabEnd;
                                    changed = true;
                                    break;
                                }
                                spaceCount = indentColumn - indentation;
                                replacement.append(IndentUtil.repeat(' ', spaceCount));
                                indentation += spaceCount;
                                changed = true;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(IndentUtil.this.createNoIndentationCharMessage(c));
                            }
                        }
                    }
                    if (changed) {
                        action.doEdit(line, lineInfo.getOffset(), offset - lineInfo.getOffset(), replacement);
                    } else lbl-1000:
                    // 2 sources

                    {
                        action.doEdit(line, lineInfo.getOffset(), 0, null);
                    }
                }
                ++line;
            }
        }

        @Override
        public void changeIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
            StringBuilder replacement = new StringBuilder(20);
            int line = firstLine;
            while (line <= lastLine) {
                IRegion lineInfo = IndentUtil.this.document.getLineInformation(line);
                int indentColumn = action.getIndentColumn(line, lineInfo.getOffset());
                if (indentColumn >= 0) {
                    int c;
                    replacement.setLength(0);
                    int column = 0;
                    int offset = lineInfo.getOffset();
                    block5: while (column < indentColumn) {
                        c = IndentUtil.this.getDocumentChar(offset);
                        switch (c) {
                            case 32: {
                                ++column;
                                ++offset;
                                replacement.append(' ');
                                break;
                            }
                            case 9: {
                                int tabStart = column / IndentUtil.this.tabWidth * IndentUtil.this.tabWidth;
                                int tabEnd = tabStart + IndentUtil.this.tabWidth;
                                if (tabEnd > indentColumn) {
                                    int spaceCount = indentColumn - column;
                                    replacement.append(IndentUtil.repeat(' ', spaceCount));
                                    column = indentColumn;
                                } else {
                                    replacement.append('\t');
                                    column = tabEnd;
                                }
                                ++offset;
                                break;
                            }
                            default: {
                                break block5;
                            }
                        }
                    }
                    while ((c = IndentUtil.this.getDocumentChar(offset)) == 32 || c == 9) {
                        ++offset;
                    }
                    if (column < indentColumn) {
                        IndentUtil.this.appendIndent(replacement, column, indentColumn);
                    }
                    action.doEdit(line, lineInfo.getOffset(), offset - lineInfo.getOffset(), replacement);
                }
                ++line;
            }
        }

        @Override
        public String copyLineIndent(int line) throws BadLocationException {
            IRegion lineInfo = IndentUtil.this.document.getLineInformation(line);
            int offset = lineInfo.getOffset();
            block4: while (true) {
                int c = IndentUtil.this.getDocumentChar(offset++);
                switch (c) {
                    case 32: {
                        continue block4;
                    }
                    case 9: {
                        continue block4;
                    }
                }
                break;
            }
            return IndentUtil.this.document.get(lineInfo.getOffset(), --offset - lineInfo.getOffset());
        }
    }

    private class CorrectStrategy
    implements EditStrategy {
        private CorrectStrategy() {
        }

        @Override
        public void editInIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
            StringBuilder replacement = new StringBuilder(20);
            int line = firstLine;
            while (line <= lastLine) {
                int lineOffset = IndentUtil.this.document.getLineOffset(line);
                int indentColumn = action.getIndentColumn(line, lineOffset);
                if (indentColumn >= 0) {
                    int[] current = IndentUtil.this.getLineIndent(line, true);
                    replacement.setLength(0);
                    IndentUtil.this.appendIndent(replacement, indentColumn);
                    if (current[0] >= 0) {
                        IndentUtil.this.appendSpaces(replacement, current[0] - indentColumn);
                    }
                    action.doEdit(line, lineOffset, current[1] - lineOffset, replacement);
                }
                ++line;
            }
        }

        @Override
        public void changeIndent(int firstLine, int lastLine, IndentEditAction action) throws BadLocationException {
            StringBuilder replacement = new StringBuilder(20);
            int line = firstLine;
            while (line <= lastLine) {
                int lineOffset = IndentUtil.this.document.getLineOffset(line);
                int indentColumn = action.getIndentColumn(line, lineOffset);
                if (indentColumn >= 0) {
                    int[] current = IndentUtil.this.getLineIndent(line, false);
                    replacement.setLength(0);
                    IndentUtil.this.appendIndent(replacement, indentColumn);
                    action.doEdit(line, lineOffset, current[1] - lineOffset, replacement);
                }
                ++line;
            }
        }

        @Override
        public String copyLineIndent(int line) throws BadLocationException {
            IRegion lineInfo = IndentUtil.this.document.getLineInformation(line);
            int column = 0;
            int offset = lineInfo.getOffset();
            block4: while (true) {
                int c = IndentUtil.this.getDocumentChar(offset++);
                switch (c) {
                    case 32: {
                        ++column;
                        continue block4;
                    }
                    case 9: {
                        column += IndentUtil.this.tabWidth - column % IndentUtil.this.tabWidth;
                        continue block4;
                    }
                }
                break;
            }
            return IndentUtil.this.createIndentString(column);
        }
    }

    private static interface EditStrategy {
        public void editInIndent(int var1, int var2, IndentEditAction var3) throws BadLocationException;

        public void changeIndent(int var1, int var2, IndentEditAction var3) throws BadLocationException;

        public String copyLineIndent(int var1) throws BadLocationException;
    }

    public static interface ILineIndent
    extends TextRegion {
        public int getIndentOffset();

        public int getIndentColumn();

        public boolean isBlank();
    }

    public static abstract class IndentEditAction {
        private final int indentColumn;

        public IndentEditAction() {
            this.indentColumn = 0;
        }

        public IndentEditAction(int indentColumn) {
            this.indentColumn = indentColumn;
        }

        public int getIndentColumn(int line, int lineOffset) throws BadLocationException {
            return this.indentColumn;
        }

        public abstract void doEdit(int var1, int var2, int var3, @Nullable StringBuilder var4) throws BadLocationException;
    }

    private static abstract class LineIndent
    implements ILineIndent {
        private final int lineOffset;
        private final int indentOffset;
        private final int indentColumn;

        public LineIndent(int lineOffset, int indentOffset, int indentColumn) {
            this.lineOffset = lineOffset;
            this.indentOffset = indentOffset;
            this.indentColumn = indentColumn;
        }

        public int getStartOffset() {
            return this.lineOffset;
        }

        public int getEndOffset() {
            return this.indentOffset;
        }

        public int getLength() {
            return this.indentOffset - this.lineOffset;
        }

        @Override
        public int getIndentOffset() {
            return this.indentOffset;
        }

        @Override
        public int getIndentColumn() {
            return this.indentColumn;
        }

        @Override
        public abstract boolean isBlank();

        private static final class Blank
        extends LineIndent {
            public Blank(int lineOffset, int indentOffset, int indentColumn) {
                super(lineOffset, indentOffset, indentColumn);
            }

            @Override
            public boolean isBlank() {
                return true;
            }
        }

        private static final class NonBlank
        extends LineIndent {
            public NonBlank(int lineOffset, int indentOffset, int indentColumn) {
                super(lineOffset, indentOffset, indentColumn);
            }

            @Override
            public boolean isBlank() {
                return false;
            }
        }
    }
}

