/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.refactoring.core.Messages;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.DynamicValidationRefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.TextChangeManager;

public abstract class CommonPasteCodeProcessor
extends RefactoringProcessor {
    private final RefactoringAdapter adapter;
    private final String code;
    private final RefactoringDestination destination;
    private Change insertChange;

    public CommonPasteCodeProcessor(String code, RefactoringDestination destination, RefactoringAdapter adapter) {
        assert (code != null);
        assert (destination != null);
        assert (adapter != null);
        this.destination = destination;
        this.code = code;
        this.adapter = adapter;
    }

    public abstract String getIdentifier();

    protected abstract String getRefactoringIdentifier();

    public String getProcessorName() {
        return Messages.PasteRefactoring_label;
    }

    public Object[] getElements() {
        return this.destination.getInitialObjects().toArray();
    }

    public Change getInsertChange() {
        return this.insertChange;
    }

    public boolean isApplicable() throws CoreException {
        return this.adapter.canInsertTo(this.destination);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.adapter.checkInitialToModify(result, this.destination);
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)13);
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.destination.postProcess();
            this.adapter.checkFinalToModify(result, this.destination, (IProgressMonitor)m.newChild(1));
            m.worked(1);
            TextChangeManager textManager = new TextChangeManager();
            this.insertChange = this.adapter.createChangeToInsert(this.getProcessorName(), this.code, this.destination, textManager, (IProgressMonitor)m.newChild(10));
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.adapter.buildDeltaToModify(this.destination, deltaFactory);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        finally {
            m.done();
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        ArrayList result = new ArrayList();
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringMessages.Common_CreateChanges_label, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = Messages.PasteRefactoring_Code_description;
            IProject resource = this.destination.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, this.getProcessorName(), new Change[]{this.insertChange}, null);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }
}

