/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.internal.ltk.refactoring.core.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.model.core.util.LtkModelElementComparator;
import org.eclipse.statet.ltk.refactoring.core.RefactoringDestination;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeManager;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RefactoringAdapter {
    private static final Comparator<LtkModelElement> MODELELEMENT_SORTER = new LtkModelElementComparator();
    private final String modelTypeId;

    public RefactoringAdapter(String modelTypeId) {
        this.modelTypeId = modelTypeId;
    }

    public Comparator<LtkModelElement> getModelElementComparator() {
        return MODELELEMENT_SORTER;
    }

    public String getModelTypeId() {
        return this.modelTypeId;
    }

    public boolean isSupportedModelType(String typeId) {
        return this.modelTypeId == typeId;
    }

    public abstract String getPluginIdentifier();

    public abstract boolean isCommentContent(ITypedRegion var1);

    public abstract BasicHeuristicTokenScanner getScanner(SourceUnit var1);

    public SourceStructElement[] checkElements(SourceStructElement[] elements) {
        if (elements.length <= 1) {
            return elements;
        }
        Arrays.sort(elements, this.getModelElementComparator());
        SourceStructElement last = elements[0];
        SourceUnit unitOfLast = last.getSourceUnit();
        int endOfLast = last.getSourceRange().getEndOffset();
        ArrayList<SourceStructElement> checked = new ArrayList<SourceStructElement>(elements.length);
        SourceStructElement[] sourceStructElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SourceStructElement element = sourceStructElementArray[n2];
            SourceUnit unit = element.getSourceUnit();
            int end = last.getSourceRange().getEndOffset();
            if (unit != unitOfLast) {
                checked.add(element);
                last = element;
                unitOfLast = unit;
                endOfLast = end;
            } else if (end > endOfLast) {
                checked.add(element);
                last = element;
                endOfLast = end;
            }
            ++n2;
        }
        return checked.toArray(new SourceStructElement[checked.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @Nullable IRegion getContinuousSourceRange(List<SourceStructElement<?, ?>> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        SourceStructElement<?, ?> element0 = elements.get(0);
        SourceUnit su = element0.getSourceUnit();
        if (su == null) {
            return null;
        }
        AbstractDocument doc = su.getDocument(null);
        if (doc == null) {
            return null;
        }
        try {
            BasicHeuristicTokenScanner scanner = this.getScanner(su);
            scanner.configure((IDocument)doc);
            int start = element0.getSourceRange().getStartOffset();
            int end = element0.getSourceRange().getEndOffset();
            int i = 1;
            while (true) {
                if (i >= elements.size()) {
                    ITypedRegion partition;
                    IRegion lastLine = doc.getLineInformationOfOffset(end);
                    int match = scanner.findAnyNonBlankForward(end, lastLine.getOffset() + lastLine.getLength(), true);
                    if (match >= 0 && this.isCommentContent(partition = doc.getPartition(scanner.getDocumentPartitioning(), match, false))) {
                        end = partition.getOffset() + partition.getLength();
                    }
                    return new Region(start, end - start);
                }
                SourceStructElement<?, ?> element = elements.get(i);
                if (element.getSourceUnit() != su) {
                    return null;
                }
                int elementStart = element.getSourceRange().getStartOffset();
                int elementEnd = elementStart + element.getSourceRange().getLength();
                if (elementEnd > end) {
                    while (true) {
                        int match;
                        if (end >= elementStart || (match = scanner.findAnyNonBlankForward(end, elementStart, true)) < 0) {
                            end = elementEnd;
                            break;
                        }
                        ITypedRegion partition = doc.getPartition(scanner.getDocumentPartitioning(), match, false);
                        if (!this.isCommentContent(partition)) {
                            return null;
                        }
                        end = partition.getOffset() + partition.getLength();
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            return null;
        }
    }

    public String getSourceCodeStringedTogether(SourceStructElement[] sourceElements, IProgressMonitor monitor) throws CoreException {
        return this.getSourceCodeStringedTogether(new ElementSet(sourceElements), monitor);
    }

    public String getSourceCodeStringedTogether(ElementSet sourceElements, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
        SourceUnit lastUnit = null;
        BasicHeuristicTokenScanner scanner = null;
        try {
            sourceElements.removeElementsWithAncestorsOnList();
            Collections.sort(sourceElements.getModelElements(), this.getModelElementComparator());
            String lineDelimiter = TextUtil.getPlatformLineDelimiter();
            AbstractDocument doc = null;
            List<LtkModelElement<?>> modelElements = sourceElements.getModelElements();
            int workRemaining = modelElements.size() * 3 + 1;
            StringBuilder sb = new StringBuilder(modelElements.size() * 100);
            ArrayList<String> codeFragments = new ArrayList<String>();
            for (LtkModelElement<?> element : modelElements) {
                m.setWorkRemaining(workRemaining);
                workRemaining -= 3;
                SourceUnit su = LtkModelUtils.getSourceUnit(element);
                if (su != lastUnit) {
                    if (lastUnit != null) {
                        lastUnit.disconnect((IProgressMonitor)m.newChild(1));
                        lastUnit = null;
                    }
                    su.connect((IProgressMonitor)m.newChild(1));
                    lastUnit = su;
                    scanner = this.getScanner(su);
                    doc = su.getDocument(monitor);
                }
                this.getSourceCode((SourceElement)element, doc, scanner, codeFragments);
                for (String s : codeFragments) {
                    sb.append(s);
                    sb.append(lineDelimiter);
                }
                codeFragments.clear();
                m.worked(1);
            }
            String string = sb.toString();
            return string;
        }
        catch (BadLocationException | BadPartitioningException e) {
            throw new CoreException(this.failDocAnalyzation(e));
        }
        finally {
            if (lastUnit != null) {
                m.setWorkRemaining(1);
                lastUnit.disconnect((IProgressMonitor)m.newChild(1));
                lastUnit = null;
            }
        }
    }

    protected void getSourceCode(SourceElement element, AbstractDocument doc, BasicHeuristicTokenScanner scanner, List<String> codeFragments) throws BadLocationException, BadPartitioningException {
        TextRegion range = this.expandElementRange(element, doc, scanner);
        if (range != null && range.getLength() > 0) {
            codeFragments.add(doc.get(range.getStartOffset(), range.getLength()));
        }
    }

    public TextRegion expandElementRange(SourceElement element, AbstractDocument document, BasicHeuristicTokenScanner scanner) throws BadLocationException, BadPartitioningException {
        TextRegion sourceRange = element.getSourceRange();
        int start = sourceRange.getStartOffset();
        int end = start + sourceRange.getLength();
        TextRegion docRange = element.getDocumentationRange();
        if (docRange != null) {
            if (docRange.getStartOffset() < start) {
                start = docRange.getStartOffset();
            }
            if (docRange.getEndOffset() > end) {
                end = docRange.getEndOffset();
            }
        }
        return this.expandSourceRange(start, end, document, scanner);
    }

    protected TextRegion expandSourceRange(int start, int end, AbstractDocument doc, BasicHeuristicTokenScanner scanner) throws BadLocationException, BadPartitioningException {
        IRegion checkLineInfo;
        int checkLine;
        ITypedRegion partition;
        scanner.configure((IDocument)doc);
        IRegion lastLineInfo = doc.getLineInformationOfOffset(end);
        int match = scanner.findAnyNonBlankForward(end, lastLineInfo.getOffset() + lastLineInfo.getLength(), true);
        if (match >= 0 && this.isCommentContent(partition = doc.getPartition(scanner.getDocumentPartitioning(), match, false))) {
            end = partition.getOffset() + partition.getLength();
        }
        if ((checkLine = doc.getLineOfOffset(end) + 1) < doc.getNumberOfLines() && (match = scanner.findAnyNonBlankForward(end, (checkLineInfo = doc.getLineInformation(checkLine)).getOffset() + checkLineInfo.getLength(), true)) < 0) {
            end = checkLineInfo.getOffset() + checkLineInfo.getLength();
        }
        return new BasicTextRegion(start, end);
    }

    public TextRegion expandWhitespaceBlock(AbstractDocument document, TextRegion region, BasicHeuristicTokenScanner scanner) throws BadLocationException {
        scanner.configure((IDocument)document);
        int firstLine = document.getLineOfOffset(region.getStartOffset());
        int lastLine = document.getLineOfOffset(region.getEndOffset());
        if (lastLine > firstLine && document.getLineOffset(lastLine) == region.getEndOffset()) {
            --lastLine;
        }
        int min = document.getLineOffset(firstLine);
        int max = document.getLineOffset(lastLine) + document.getLineLength(lastLine);
        int result = scanner.findAnyNonBlankForward(region.getEndOffset(), max, true);
        int end = result >= 0 ? result : max;
        result = scanner.findAnyNonBlankBackward(region.getStartOffset(), min, true);
        if (result >= 0) {
            return new BasicTextRegion(result + 1, end);
        }
        return new BasicTextRegion(min, end);
    }

    public boolean canDelete(ElementSet elements) {
        if (elements.getInitialObjects().size() == 0) {
            return false;
        }
        if (!elements.isOK()) {
            return false;
        }
        for (LtkModelElement<?> ltkModelElement : elements.getModelElements()) {
            if (this.canDelete(ltkModelElement)) continue;
            return false;
        }
        for (IResource iResource : elements.getResources()) {
            if (this.canDelete(iResource)) continue;
            return false;
        }
        return true;
    }

    public boolean canDelete(LtkModelElement element) {
        if (!element.exists()) {
            return false;
        }
        if (!this.isSupportedModelType(element.getModelTypeId())) {
            return false;
        }
        return !element.isReadOnly();
    }

    public boolean canDelete(IResource resource) {
        ResourceAttributes attributes;
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        if (resource.getType() == 8 || resource.getType() == 4) {
            return false;
        }
        return resource.getParent() == null || (attributes = resource.getParent().getResourceAttributes()) == null || !attributes.isReadOnly();
    }

    public boolean canInsert(ElementSet elements, RefactoringDestination to) {
        if (to.getInitialObjects().get(0) instanceof SourceElement) {
            return this.canInsert(elements, (SourceElement)to.getInitialObjects().get(0), to.getPosition());
        }
        return false;
    }

    protected boolean canInsert(ElementSet elements, SourceElement to, RefactoringDestination.Position pos) {
        if (elements.getInitialObjects().size() == 0) {
            return false;
        }
        if (!elements.isOK()) {
            return false;
        }
        if (!this.canInsertTo(to)) {
            return false;
        }
        for (LtkModelElement<?> ltkModelElement : elements.getModelElements()) {
            if (this.canInsert(ltkModelElement)) continue;
            return false;
        }
        Iterator<LtkModelElement<?>> iterator = elements.getResources().iterator();
        if (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            return false;
        }
        return !elements.includes(to);
    }

    protected boolean canInsert(LtkModelElement element) {
        if (!element.exists()) {
            return false;
        }
        return this.isSupportedModelType(element.getModelTypeId());
    }

    public boolean canInsertTo(RefactoringDestination destination) {
        if (destination.getModelElements().size() != 1) {
            return false;
        }
        return this.canInsertTo(destination.getModelElements().get(0));
    }

    protected boolean canInsertTo(LtkModelElement element) {
        if (!element.exists()) {
            return false;
        }
        if (!this.isSupportedModelType(element.getModelTypeId())) {
            return false;
        }
        return !element.isReadOnly();
    }

    public void checkInitialToModify(RefactoringStatus result, ElementSet elements) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.addAll(elements.getResources());
        for (LtkModelElement<?> element : elements.getModelElements()) {
            SourceUnit su = LtkModelUtils.getSourceUnit(element);
            if (su instanceof WorkspaceSourceUnit) {
                resources.add(((WorkspaceSourceUnit)su).getResource());
                continue;
            }
            result.addFatalError(Messages.Check_ElementNotInWS_message);
            return;
        }
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])resources.toArray(new IResource[resources.size()]))));
    }

    public void checkFinalToModify(RefactoringStatus result, ElementSet elements, IProgressMonitor monitor) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.addAll(elements.getResources());
        for (LtkModelElement<?> element : elements.getModelElements()) {
            SourceUnit su = LtkModelUtils.getSourceUnit(element);
            if (su instanceof WorkspaceSourceUnit) {
                resources.add(((WorkspaceSourceUnit)su).getResource());
                continue;
            }
            result.addFatalError(Messages.Check_ElementNotInWS_message);
            return;
        }
        IResource[] array = resources.toArray(new IResource[resources.size()]);
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])array)));
        result.merge(RefactoringStatus.create((IStatus)Resources.makeCommittable((IResource[])array, (Object)IWorkspace.VALIDATE_PROMPT)));
    }

    public void checkFinalToDelete(RefactoringStatus result, ElementSet elements) throws CoreException {
        for (LtkModelElement<?> ltkModelElement : elements.getModelElements()) {
            this.checkFinalToDelete(result, ltkModelElement);
        }
        for (IResource iResource : elements.getResources()) {
            this.checkFinalToDelete(result, iResource);
        }
    }

    public void checkFinalToDelete(final RefactoringStatus result, IResource element) throws CoreException {
        if (element.getType() == 1) {
            this.warnIfDirty(result, (IFile)element);
            return;
        }
        element.accept(new IResourceVisitor(){

            public boolean visit(IResource visitedResource) throws CoreException {
                if (visitedResource instanceof IFile) {
                    RefactoringAdapter.this.warnIfDirty(result, (IFile)visitedResource);
                }
                return true;
            }
        }, 2, false);
    }

    public void checkFinalToDelete(RefactoringStatus result, LtkModelElement element) throws CoreException {
        if ((element.getElementType() & 0xFF0) == 528) {
            if (element instanceof WorkspaceSourceUnit) {
                this.checkFinalToDelete(result, ((WorkspaceSourceUnit)element).getResource());
            }
        } else if ((element.getElementType() & 0xF00) == 256 && element instanceof SourceStructElement) {
            List children = ((SourceStructElement)element).getSourceChildren(null);
            for (LtkModelElement child : children) {
                this.checkFinalToDelete(result, child);
            }
        }
    }

    public void warnIfDirty(RefactoringStatus result, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(NLS.bind((String)Messages.Check_FileUnsavedChanges_message, (Object)FileUtil.getFileUtil((Object)file).getLabel()));
            } else {
                result.addFatalError(NLS.bind((String)Messages.Check_FileUnsavedChanges_message, (Object)FileUtil.getFileUtil((Object)file).getLabel()));
            }
        }
    }

    public boolean confirmDeleteOfReadOnlyElements(ElementSet elements, Object queries) throws CoreException {
        return this.hasReadOnlyElements(elements);
    }

    public boolean hasReadOnlyElements(ElementSet elements) throws CoreException {
        for (IResource iResource : elements.getResources()) {
            if (!this.hasReadOnlyElements(iResource)) continue;
            return true;
        }
        for (LtkModelElement ltkModelElement : elements.getModelElements()) {
            if (!this.hasReadOnlyElements(ltkModelElement)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReadOnlyElements(IResource element) throws CoreException {
        if (this.isReadOnly(element)) {
            return true;
        }
        if (element instanceof IContainer) {
            IResource[] members;
            IResource[] iResourceArray = members = ((IContainer)element).members(false);
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (this.hasReadOnlyElements(member)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasReadOnlyElements(LtkModelElement element) throws CoreException {
        SourceUnit su = LtkModelUtils.getSourceUnit(element);
        IResource resource = null;
        if (su instanceof WorkspaceSourceUnit) {
            resource = ((WorkspaceSourceUnit)su).getResource();
        }
        if (resource == null) {
            resource = (IResource)element.getAdapter(IResource.class);
        }
        if (resource != null) {
            return this.hasReadOnlyElements(resource);
        }
        return false;
    }

    public boolean isReadOnly(IResource element) {
        ResourceAttributes attributes = element.getResourceAttributes();
        if (attributes != null) {
            return attributes.isReadOnly();
        }
        return false;
    }

    public void addParticipantsToDelete(ElementSet elementsToDelete, List<RefactoringParticipant> list, RefactoringStatus status, RefactoringProcessor processor, SharableParticipants shared) throws CoreException {
        DeleteParticipant[] deletes;
        Set<String> natureIds = ElementSet.getAffectedProjectNatures(elementsToDelete);
        String[] natures = natureIds.toArray(new String[natureIds.size()]);
        DeleteArguments arguments = new DeleteArguments();
        for (IResource iResource : elementsToDelete.getResources()) {
            deletes = ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)iResource, (DeleteArguments)arguments, (String[])natures, (SharableParticipants)shared);
            list.addAll(Arrays.asList(deletes));
        }
        for (IResource iResource : elementsToDelete.getResourcesOwnedByElements()) {
            deletes = ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)iResource, (DeleteArguments)arguments, (String[])natures, (SharableParticipants)shared);
            list.addAll(Arrays.asList(deletes));
        }
        for (LtkModelElement ltkModelElement : elementsToDelete.getModelElements()) {
            deletes = ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)ltkModelElement, (DeleteArguments)arguments, (String[])natures, (SharableParticipants)shared);
            list.addAll(Arrays.asList(deletes));
        }
    }

    public void addParticipantsToMove(ElementSet elementsToMove, RefactoringDestination destination, List<RefactoringParticipant> list, RefactoringStatus status, RefactoringProcessor processor, SharableParticipants shared, ReorgExecutionLog executionLog) throws CoreException {
        Set<String> natureIds = ElementSet.getAffectedProjectNatures((List<ElementSet>)ImCollections.newList((Object[])new ElementSet[]{elementsToMove, destination}));
        String[] natures = natureIds.toArray(new String[natureIds.size()]);
        MoveArguments mArguments = new MoveArguments(destination.getModelElements().get(0), false);
        for (LtkModelElement<?> element : elementsToMove.getModelElements()) {
            MoveParticipant[] deletes = ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, element, (MoveArguments)mArguments, (String[])natures, (SharableParticipants)shared);
            list.addAll(Arrays.asList(deletes));
        }
    }

    public void addParticipantsToCopy(ElementSet elementsToCopy, RefactoringDestination destination, List<RefactoringParticipant> list, RefactoringStatus status, RefactoringProcessor processor, SharableParticipants shared, ReorgExecutionLog executionLog) throws CoreException {
        Set<String> natureIds = ElementSet.getAffectedProjectNatures((List<ElementSet>)ImCollections.newList((Object[])new ElementSet[]{elementsToCopy, destination}));
        String[] natures = natureIds.toArray(new String[natureIds.size()]);
        CopyArguments mArguments = new CopyArguments(destination.getModelElements().get(0), executionLog);
        for (LtkModelElement<?> element : elementsToCopy.getModelElements()) {
            CopyParticipant[] deletes = ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, element, (CopyArguments)mArguments, (String[])natures, (SharableParticipants)shared);
            list.addAll(Arrays.asList(deletes));
        }
    }

    public void buildDeltaToDelete(ElementSet elements, IResourceChangeDescriptionFactory resourceDelta) {
        for (IResource resource : elements.getResources()) {
            resourceDelta.delete(resource);
        }
        for (IResource resource : elements.getResourcesOwnedByElements()) {
            resourceDelta.delete(resource);
        }
        for (IFile file : elements.getFilesContainingElements()) {
            resourceDelta.change(file);
        }
    }

    public void buildDeltaToModify(ElementSet elements, IResourceChangeDescriptionFactory resourceDelta) {
        for (IResource resource : elements.getResources()) {
            if (!(resource instanceof IFile)) continue;
            resourceDelta.change((IFile)resource);
        }
        for (IResource resource : elements.getResourcesOwnedByElements()) {
            if (!(resource instanceof IFile)) continue;
            resourceDelta.change((IFile)resource);
        }
        for (IFile file : elements.getFilesContainingElements()) {
            resourceDelta.change(file);
        }
    }

    public Change createChangeToDelete(String changeName, ElementSet elementsToDelete, TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        CompositeChange result = new CompositeChange(changeName);
        this.addChangesToDelete(result, elementsToDelete, manager, m.newChild(1));
        result.addAll((Change[])manager.getAllChanges());
        m.worked(1);
        return result;
    }

    public Change createChangeToMove(String changeName, ElementSet elementsToMove, RefactoringDestination destination, TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        CompositeChange result = new CompositeChange(changeName);
        String code = this.getSourceCodeStringedTogether(elementsToMove, (IProgressMonitor)m.newChild(1));
        this.addChangesToDelete(result, elementsToMove, manager, m.newChild(1));
        this.addChangesToInsert(result, code, destination, manager, m.newChild(1));
        result.addAll((Change[])manager.getAllChanges());
        m.worked(1);
        return result;
    }

    public Change createChangeToCopy(String changeName, ElementSet elementsToMove, RefactoringDestination destination, TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        CompositeChange result = new CompositeChange(changeName);
        String code = this.getSourceCodeStringedTogether(elementsToMove, (IProgressMonitor)m.newChild(1));
        this.addChangesToInsert(result, code, destination, manager, m.newChild(1));
        result.addAll((Change[])manager.getAllChanges());
        m.worked(1);
        return result;
    }

    public Change createChangeToInsert(String changeName, String code, RefactoringDestination destination, TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        assert (changeName != null && code != null && destination != null && manager != null);
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        CompositeChange result = new CompositeChange(changeName);
        this.addChangesToInsert(result, code, destination, manager, m.newChild(1));
        result.addAll((Change[])manager.getAllChanges());
        m.worked(1);
        return result;
    }

    protected void addChangesToDelete(CompositeChange result, ElementSet elements, TextChangeManager manager, SubMonitor m) throws CoreException {
        for (IResource resource : elements.getResources()) {
            result.add(this.createChangeToDelete(elements, resource));
        }
        HashMap suSubChanges = new HashMap();
        for (LtkModelElement<?> ltkModelElement : elements.getModelElements()) {
            IResource resource = elements.getOwningResource(ltkModelElement);
            if (resource != null) {
                result.add(this.createChangeToDelete(elements, resource));
                continue;
            }
            SourceUnit su = LtkModelUtils.getSourceUnit(ltkModelElement);
            ArrayList list = (ArrayList)suSubChanges.get(su);
            if (list == null) {
                list = new ArrayList(1);
                suSubChanges.put(su, list);
            }
            list.add(ltkModelElement);
        }
        if (!suSubChanges.isEmpty()) {
            m.setWorkRemaining(suSubChanges.size() * 3);
            for (Map.Entry entry : suSubChanges.entrySet()) {
                this.createChangeToDelete(elements, (SourceUnit)entry.getKey(), (List)entry.getValue(), manager, m);
            }
        }
    }

    private void createChangeToDelete(ElementSet elements, SourceUnit su, List<LtkModelElement> elementsInUnit, TextChangeManager manager, SubMonitor m) throws CoreException {
        if (!(su instanceof WorkspaceSourceUnit) || ((WorkspaceSourceUnit)su).getResource().getType() != 1) {
            throw new IllegalArgumentException();
        }
        su.connect((IProgressMonitor)m.newChild(1));
        try {
            try {
                MultiTextEdit rootEdit = this.getRootEdit(manager, su);
                BasicHeuristicTokenScanner scanner = this.getScanner(su);
                AbstractDocument document = su.getDocument(null);
                for (LtkModelElement element : elementsInUnit) {
                    SourceElement member = (SourceElement)element;
                    TextRegion sourceRange = this.expandElementRange(member, document, scanner);
                    DeleteEdit edit = new DeleteEdit(sourceRange.getStartOffset(), sourceRange.getLength());
                    rootEdit.addChild((TextEdit)edit);
                }
                m.worked(1);
            }
            catch (BadLocationException | BadPartitioningException e) {
                throw new CoreException(this.failCreation(e));
            }
        }
        finally {
            su.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    protected Change createChangeToDelete(ElementSet elements, LtkModelElement element) throws CoreException {
        IResource resource = elements.getOwningResource(element);
        if (resource != null) {
            return this.createChangeToDelete(elements, resource);
        }
        throw new IllegalStateException();
    }

    protected Change createChangeToDelete(ElementSet elements, IResource resource) {
        if (resource.getType() == 8 || resource.getType() == 4) {
            throw new IllegalStateException();
        }
        return new DeleteResourceChange(resource.getFullPath(), true);
    }

    protected Change createChangeToDelete(ElementSet elements, SourceUnit su) throws CoreException {
        if (su instanceof WorkspaceSourceUnit) {
            return this.createChangeToDelete(elements, ((WorkspaceSourceUnit)su).getResource());
        }
        throw new IllegalStateException();
    }

    protected void addChangesToInsert(CompositeChange result, String code, RefactoringDestination destination, TextChangeManager manager, SubMonitor m) throws CoreException {
        SourceElement element = (SourceElement)destination.getModelElements().get(0);
        SourceUnit su = LtkModelUtils.getSourceUnit(element);
        m.setWorkRemaining(3);
        this.createChangeToInsert(su, code, element, destination, manager, m);
    }

    private void createChangeToInsert(SourceUnit su, String code, SourceElement desElement, RefactoringDestination destination, TextChangeManager manager, SubMonitor m) throws CoreException {
        if (!(su instanceof WorkspaceSourceUnit) || ((WorkspaceSourceUnit)su).getResource().getType() != 1) {
            throw new IllegalArgumentException();
        }
        su.connect((IProgressMonitor)m.newChild(1));
        try {
            try {
                AbstractDocument document = su.getDocument((IProgressMonitor)m.newChild(1));
                BasicHeuristicTokenScanner scanner = this.getScanner(su);
                int offset = destination.getPosition() == RefactoringDestination.Position.AT ? destination.getOffset() : this.getInsertionOffset(document, desElement, destination.getPosition(), scanner);
                MultiTextEdit rootEdit = this.getRootEdit(manager, su);
                InsertEdit edit = new InsertEdit(offset, code);
                rootEdit.addChild((TextEdit)edit);
                ((SourceUnitChange)manager.get(su)).setInsertPosition(new Position(edit.getOffset()));
                m.worked(1);
            }
            catch (BadLocationException | BadPartitioningException e) {
                throw new CoreException(this.failCreation(e));
            }
        }
        finally {
            su.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    protected int getInsertionOffset(AbstractDocument document, SourceElement element, RefactoringDestination.Position pos, BasicHeuristicTokenScanner scanner) throws BadLocationException, BadPartitioningException {
        int line;
        IRegion lineInformation;
        TextRegion range = this.expandElementRange(element, document, scanner);
        if (pos == RefactoringDestination.Position.ABOVE) {
            int offset = range.getStartOffset();
            return offset;
        }
        int offset = range.getEndOffset();
        if (offset == (lineInformation = document.getLineInformation(line = document.getLineOfOffset(offset))).getOffset() + lineInformation.getLength()) {
            offset += document.getLineDelimiter(line).length();
        }
        return offset;
    }

    private MultiTextEdit getRootEdit(TextChangeManager manager, SourceUnit su) {
        TextFileChange textFileChange = manager.get(su);
        if (su.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
            textFileChange.setSaveMode(4);
        }
        if (textFileChange.getEdit() == null) {
            textFileChange.setEdit((TextEdit)new MultiTextEdit());
        }
        return (MultiTextEdit)textFileChange.getEdit();
    }

    protected IStatus failDocAnalyzation(Throwable e) {
        return new Status(4, "org.eclipse.statet.ltk.core", Messages.Common_error_AnalyzingSourceDocument_message, e);
    }

    protected IStatus failCreation(Throwable e) {
        return new Status(4, "org.eclipse.statet.ltk.core", Messages.Common_error_CreatingElementChange_message, e);
    }
}

