/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;

public class CommonmarkIdGenerationStrategy
extends IdGenerationStrategy {
    private static final Pattern PATTERN = Pattern.compile("[^a-z0-9_]+");
    private final Matcher matcher = PATTERN.matcher("");

    public String generateId(String headingText) {
        String id = headingText.toLowerCase(Locale.ENGLISH);
        Matcher matcher = this.matcher.reset(id);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            int idx = 0;
            if (matcher.start() == 0) {
                idx = matcher.end();
                result = matcher.find();
            }
            while (result) {
                sb.append(id, idx, matcher.start());
                sb.append("-");
                idx = matcher.end();
                result = matcher.find();
            }
            if (idx < id.length()) {
                sb.append(id, idx, id.length());
            } else {
                if (sb.length() == 0) {
                    return "";
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return id;
    }
}

