/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LookAheadLineSequence;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;

@NonNullByDefault
public class ContentLineSequence
extends LineSequence {
    private final String content;
    private final TextLineInformation lineInfos;
    private @Nullable Line currentLine;
    private final List<Line> followingLines = new ArrayList<Line>();

    public ContentLineSequence(String content, TextLineInformation lineInfos) {
        this.content = content;
        this.lineInfos = lineInfos;
        this.currentLine = this.createLine(0);
    }

    private @Nullable Line createLine(int lineNumber) {
        String delimiter;
        if (lineNumber >= this.lineInfos.getNumberOfLines()) {
            return null;
        }
        int startOffset = this.lineInfos.getStartOffset(lineNumber);
        int endOffset = this.lineInfos.getEndOffset(lineNumber);
        switch (endOffset > startOffset ? (int)this.content.charAt(endOffset - 1) : 0) {
            case 10: {
                if (--endOffset > startOffset && this.content.charAt(endOffset - 1) == '\r') {
                    --endOffset;
                    delimiter = "\r\n";
                    break;
                }
                delimiter = "\n";
                break;
            }
            case 13: {
                --endOffset;
                delimiter = "\r";
                break;
            }
            default: {
                delimiter = "";
            }
        }
        return new Line(lineNumber, startOffset, 0, this.content.substring(startOffset, endOffset), delimiter);
    }

    @Override
    public @Nullable Line getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public @Nullable Line getNextLine() {
        return this.getNextLine(0);
    }

    public @Nullable Line getNextLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (this.currentLine != null) {
            while (index >= this.followingLines.size()) {
                Line line = this.createLine(this.currentLine.getLineNumber() + this.followingLines.size() + 1);
                if (line == null) break;
                this.followingLines.add(line);
            }
        }
        return index < this.followingLines.size() ? this.followingLines.get(index) : null;
    }

    @Override
    public void advance() {
        this.currentLine = this.getNextLine(0);
        if (this.currentLine != null) {
            this.followingLines.remove(0);
        }
    }

    @Override
    public LineSequence lookAhead() {
        return new LookAheadLineSequence(this);
    }
}

