/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
abstract class ContainerNode
extends WikitextAstNode {
    WikitextAstNode[] children = NO_CHILDREN;

    ContainerNode() {
    }

    ContainerNode(WikitextAstNode parent, int startOffset, int endOffset) {
        super(parent, startOffset, endOffset);
    }

    public boolean hasChildren() {
        return this.children.length > 0;
    }

    public int getChildCount() {
        return this.children.length;
    }

    @Override
    public WikitextAstNode getChild(int index) {
        return this.children[index];
    }

    public int getChildIndex(AstNode child) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        WikitextAstNode[] wikitextAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            WikitextAstNode child = wikitextAstNodeArray[n2];
            visitor.visit((AstNode)child);
            ++n2;
        }
    }

    @Override
    public void acceptInWikitextChildren(WikitextAstVisitor visitor) throws InvocationTargetException {
        WikitextAstNode[] wikitextAstNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            WikitextAstNode child = wikitextAstNodeArray[n2];
            child.acceptInWikitext(visitor);
            ++n2;
        }
    }
}

