/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.ast.LtxParser;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.source.TexSourceConfig;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CacheStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.source.SourceConfig;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.EmbeddingForeignReconcileTask;
import org.eclipse.statet.ltk.model.core.build.ReconcileConfig;

@NonNullByDefault
public class LtxEmbeddedModelReconciler
implements WikidocSourceUnitEmbeddedModelReconciler<ReconcileConfig<?>> {
    private final StringParserInput raInput = new StringParserInput(4096);
    private @Nullable LtxParser raParser;

    public String getModelTypeId() {
        return "Ltx";
    }

    public ReconcileConfig<?> createConfig(@Nullable IProject wsProject, @Nullable WikitextProject wikitextProject, int level) {
        return new ReconcileConfig((SourceConfig)TexSourceConfig.DEFAULT_CONFIG);
    }

    @Override
    public void reconcileAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level) {
        this.raInput.reset(content.getString());
        LtxParser parser = this.raParser;
        if (parser == null) {
            this.raParser = parser = new LtxParser(null, (StringFactory)new CacheStringFactory(32));
        }
        TexCommandSet commandSet = TexCore.getWorkbenchAccess().getTexCommandSet();
        for (EmbeddingAstNode embeddingAstNode : list) {
            if (embeddingAstNode.getForeignTypeId() != "Ltx") continue;
            SourceComponent component = parser.parseSourceFragment((TextParserInput)this.raInput.init(embeddingAstNode.getStartOffset(), embeddingAstNode.getEndOffset()), (AstNode)embeddingAstNode, commandSet);
            embeddingAstNode.setForeignNode((AstNode)component);
        }
    }

    @Override
    public void reconcileModel(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, List<? extends EmbeddingForeignReconcileTask<Embedded, WikitextSourceElement>> list, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level, SubMonitor m) {
    }

    @Override
    public void reportIssues(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, IssueRequestor issueRequestor, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level) {
    }
}

