/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DataStatus
implements IStatus {
    public static final int UPDATEABLE_ERROR = 3;
    public static final DataStatus OK_STATUS = new DataStatus(0, "ok");
    private static final IStatus[] NO_CHILDREN = new IStatus[0];
    private final int severity;
    private final String message;

    public static int getInfoSeverity(IStatus status) {
        if (status instanceof DataStatus) {
            return ((DataStatus)status).getInfoSeverity();
        }
        @NonNull IStatus[] children = status.getChildren();
        if (children.length > 0) {
            int maxSeverity = -1;
            int i = 0;
            while (i < children.length) {
                int severity = DataStatus.getInfoSeverity(children[i]);
                if (severity > maxSeverity) {
                    maxSeverity = severity;
                }
                ++i;
            }
            return maxSeverity;
        }
        return status.getSeverity();
    }

    public DataStatus(int severity, @Nullable String message) {
        this.severity = severity;
        this.message = message != null ? message : "";
    }

    public final int getSeverity() {
        switch (this.severity) {
            case 3: {
                return 2;
            }
        }
        return this.severity;
    }

    public final int getInfoSeverity() {
        switch (this.severity) {
            case 3: {
                return 4;
            }
        }
        return this.severity;
    }

    public final boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.getSeverity() & severityMask) != 0;
    }

    public String getPlugin() {
        return "org.eclipse.core.databinding";
    }

    public int getCode() {
        return 0;
    }

    public String getMessage() {
        return this.message;
    }

    public @Nullable Throwable getException() {
        return null;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public IStatus[] getChildren() {
        return NO_CHILDREN;
    }

    public int hashCode() {
        return this.severity * 31 + this.message.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataStatus) {
            DataStatus other = (DataStatus)obj;
            return this.severity == other.severity && this.message.equals(other.message);
        }
        return false;
    }
}

