/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs.groups;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.dialogs.groups.SelectionOptionsGroup;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class StructuredSelectionOptionsGroup<SelectionT extends StructuredViewer, ItemT>
extends SelectionOptionsGroup<ItemT> {
    private SelectionT fSelectionViewer;

    public StructuredSelectionOptionsGroup(boolean grabSelectionHorizontal, boolean grabVertical) {
        super(grabSelectionHorizontal, grabVertical);
    }

    @Override
    protected Control createSelectionControl(Composite parent) {
        this.fSelectionViewer = this.createSelectionViewer(parent);
        this.fSelectionViewer.setContentProvider(this.createContentProvider());
        this.fSelectionViewer.addSelectionChangedListener(this.createSelectionChangeListener());
        this.fSelectionViewer.addDoubleClickListener(this.createDoubleClickListener());
        this.fSelectionViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelectionOptionsGroup.this.handleKeyPressed(e);
            }
        });
        return this.fSelectionViewer.getControl();
    }

    protected abstract SelectionT createSelectionViewer(Composite var1);

    protected IContentProvider createContentProvider() {
        return new ItemContentProvider();
    }

    protected ISelectionChangedListener createSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                StructuredSelectionOptionsGroup.this.handleSelection(StructuredSelectionOptionsGroup.this.getSingleItem(selection), selection);
            }
        };
    }

    protected IDoubleClickListener createDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                StructuredSelectionOptionsGroup.this.handleDoubleClick(StructuredSelectionOptionsGroup.this.getSingleItem(selection), selection);
            }
        };
    }

    public SelectionT getStructuredViewer() {
        return this.fSelectionViewer;
    }

    @Override
    public void initFields() {
        super.initFields();
        this.fSelectionViewer.setInput(this.getListModel());
        this.fSelectionViewer.refresh();
    }

    public void refresh() {
        this.getStructuredViewer().refresh();
        this.reselect();
    }

    public void reselect() {
        IStructuredSelection selection = this.getSelectedItems();
        this.handleSelection(this.getSingleItem(selection), selection);
    }

    protected void handleSelection(ItemT item, IStructuredSelection rawSelection) {
    }

    protected void handleDoubleClick(ItemT item, IStructuredSelection rawSelection) {
    }

    protected void handleKeyPressed(KeyEvent event) {
    }

    public IStructuredSelection getSelectedItems() {
        return (IStructuredSelection)this.fSelectionViewer.getSelection();
    }

    public ItemT getSingleItem(IStructuredSelection selection) {
        if (selection.size() == 1) {
            return (ItemT)selection.getFirstElement();
        }
        return null;
    }

    private class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return StructuredSelectionOptionsGroup.this.getListModel().toArray();
        }
    }
}

