/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.ide.ui.StatetMessages;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class StatetUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ide.ui";
    private static StatetUIPlugin instance;
    private List<Disposable> fDisposables;

    public static void log(IStatus status) {
        if (status != null) {
            StatetUIPlugin.getInstance().getLog().log(status);
        }
    }

    public static void logError(String message, Throwable e) {
        StatetUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, message, e));
    }

    public static void logUnexpectedError(Throwable e) {
        StatetUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, 0, StatetMessages.InternalError_UnexpectedException, e));
    }

    public static StatetUIPlugin getInstance() {
        return instance;
    }

    public StatetUIPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        this.fDisposables = new ArrayList<Disposable>();
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            for (Disposable d : this.fDisposables) {
                try {
                    d.dispose();
                }
                catch (Throwable e) {
                    StatetUIPlugin.logError("Error occured when dispose module", e);
                }
            }
            this.fDisposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.ide.ui/image/obj/import", "obj_16", "ltk-import.png");
        util.register("org.eclipse.statet.ide.ui/image/obj/class", "obj_16", "ltk-class.png");
        util.register("org.eclipse.statet.ide.ui/image/obj/class_ext", "obj_16", "ltk-class_ext.png");
        util.register("org.eclipse.statet.ide.ui/image/tool/refresh", "tool_16", "refresh.png");
        util.register("org.eclipse.statet.ide.ui/image/toold/refresh", "tool_16_d", "refresh.png");
    }

    public void registerPluginDisposable(Disposable d) {
        List<Disposable> disposables = this.fDisposables;
        if (disposables == null) {
            throw new IllegalStateException();
        }
        disposables.add(d);
    }
}

