/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.text.InternalAccessor;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.ui.util.ColumnWidgetTokenOwner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ColumnHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static final AbstractInformationControlManager.Anchor[] TREE_ANCHORS = new AbstractInformationControlManager.Anchor[]{ANCHOR_RIGHT, ANCHOR_LEFT};
    public static final int WIDGET_PRIORITY = 0;
    private final Composite fSubjectControl;
    private final int fMarginY = 5;
    private final int fMarginX = 5;
    private final TreeViewer fTreeViewer;
    private final ColumnWidgetTokenOwner fColumnOwner;
    private Thread fThread;
    private final Object fMutex = new Object();
    private volatile Object fTextHover;

    protected ColumnHoverManager(TreeViewer treeViewer, ColumnWidgetTokenOwner tokenOwner, IInformationControlCreator creator) {
        super(creator);
        this.fTreeViewer = treeViewer;
        this.fColumnOwner = tokenOwner;
        this.fSubjectControl = treeViewer.getTree();
        this.fSubjectControl.setToolTipText("");
        this.setAnchor(ANCHOR_LEFT);
        this.setFallbackAnchors(TREE_ANCHORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeInformation() {
        Point location = this.getHoverEventLocation();
        ViewerCell cell = this.computeCellAtLocation(location);
        if (cell == null) {
            this.setInformation(null, null);
            return;
        }
        final Object element = this.prepareHoverInformation(cell);
        if (element == null) {
            this.setInformation(null, null);
            return;
        }
        Rectangle textArea = cell.getTextBounds();
        Rectangle imageArea = cell.getImageBounds();
        Rectangle clientArea = this.fSubjectControl.getClientArea();
        int x = Math.max(0, Math.min(textArea.x, imageArea.x));
        int x2 = (clientArea.width + location.x) / 2;
        x2 = Math.min(x2, location.x + 120);
        final Rectangle area = new Rectangle(x, textArea.y, x2 - x, textArea.height);
        Object object = this.fMutex;
        synchronized (object) {
            if (this.fThread != null) {
                this.setInfo(null, null);
                return;
            }
            this.fThread = new Thread("Structured Viewer Hover Presenter"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block26: {
                        boolean ok;
                        block23: {
                            block24: {
                                ok = false;
                                if (ColumnHoverManager.this.fThread != null) break block23;
                                if (ok) break block24;
                                Object object = ColumnHoverManager.this.fMutex;
                                synchronized (object) {
                                    ColumnHoverManager.this.setInfo(null, null);
                                    ColumnHoverManager.this.fThread = null;
                                }
                            }
                            return;
                        }
                        try {
                            try {
                                Object information = ColumnHoverManager.this.getHoverInformation(element);
                                Object object = ColumnHoverManager.this.fMutex;
                                synchronized (object) {
                                    if (ColumnHoverManager.this.fThread != null && information != null) {
                                        ColumnHoverManager.this.setInfo(information, area);
                                        ColumnHoverManager.this.fThread = null;
                                        ok = true;
                                    }
                                }
                            }
                            catch (RuntimeException e) {
                                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", 0, "Unexpected runtime error while computing a element hover", (Throwable)e));
                                if (ok) break block26;
                                Object object = ColumnHoverManager.this.fMutex;
                                synchronized (object) {
                                    ColumnHoverManager.this.setInfo(null, null);
                                    ColumnHoverManager.this.fThread = null;
                                    break block26;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (!ok) {
                                Object object = ColumnHoverManager.this.fMutex;
                                synchronized (object) {
                                    ColumnHoverManager.this.setInfo(null, null);
                                    ColumnHoverManager.this.fThread = null;
                                }
                            }
                            throw throwable;
                        }
                        if (!ok) {
                            Object object = ColumnHoverManager.this.fMutex;
                            synchronized (object) {
                                ColumnHoverManager.this.setInfo(null, null);
                                ColumnHoverManager.this.fThread = null;
                            }
                        }
                    }
                }
            };
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.fThread != null) {
                this.fThread.interrupt();
                this.fThread = null;
            }
        }
    }

    private ViewerCell computeCellAtLocation(Point location) {
        return this.fTreeViewer.getCell(location);
    }

    protected void setInfo(Object information, Rectangle subjectArea) {
        super.setInformation(information, subjectArea);
    }

    protected abstract Object prepareHoverInformation(ViewerCell var1);

    protected abstract Object getHoverInformation(Object var1);

    protected void presentInformation() {
        if (this.fSubjectControl == null) {
            return;
        }
        Composite control = this.fSubjectControl;
        if (control != null && !control.isDisposed()) {
            Display display = control.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ColumnHoverManager.super.presentInformation();
                }
            });
        }
    }

    protected Rectangle computeAvailableArea(Rectangle subjectArea, Rectangle bounds, AbstractInformationControlManager.Anchor anchor) {
        if (anchor == ANCHOR_RIGHT) {
            int x = this.getHoverEventLocation().x - subjectArea.x + 5;
            Rectangle area = new Rectangle(x, bounds.y, bounds.x + bounds.width - x, bounds.height);
            area.intersect(bounds);
            return area;
        }
        return super.computeAvailableArea(subjectArea, bounds, anchor);
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fColumnOwner != null && this.fColumnOwner.requestWidgetToken(this, 0)) {
            super.showInformationControl(subjectArea);
        } else if (DEBUG) {
            System.out.println("TextViewerHoverManager#showInformationControl(..) did not get widget token");
        }
    }

    protected void hideInformationControl() {
        try {
            this.fTextHover = null;
            super.hideInformationControl();
        }
        finally {
            if (this.fColumnOwner != null) {
                this.fColumnOwner.releaseWidgetToken(this);
            }
        }
    }

    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fColumnOwner != null) {
                this.fColumnOwner.releaseWidgetToken(this);
            }
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.fTextHover = null;
        super.hideInformationControl();
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 0) {
            this.fTextHover = null;
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        InternalAccessor accessor = this.getInternalAccessor();
        if (accessor.getInformationControlReplacer() == null) {
            return false;
        }
        IInformationControl iControl = accessor.getCurrentInformationControl();
        if (accessor.canReplace(iControl)) {
            accessor.replaceInformationControl(true);
            return true;
        }
        return iControl instanceof IInformationControlExtension5;
    }

    public void dispose() {
        this.stop();
        super.dispose();
    }
}

