/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.collections;

import org.eclipse.statet.ecommons.collections.CategoryElementComparator;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.collections.SortedListSet;

public class CategoryElementList<C, E>
extends SortedArraySet<E> {
    public CategoryElementList(E[] array, CategoryElementComparator<C, ? super E> comparator) {
        super((Object[])array, comparator);
    }

    protected final CategoryElementComparator<C, ? super E> comparator() {
        return (CategoryElementComparator)this.comparator;
    }

    public CategoryElementComparator<C, ? super E> getComparator() {
        return (CategoryElementComparator)this.comparator;
    }

    private int binarySearchCategory(E[] array, int begin, int end, C category) {
        --end;
        while (begin <= end) {
            int mid = begin + end >>> 1;
            int d = this.comparator().compareCategory(this.comparator().getCategory(array[mid]), category);
            if (d < 0) {
                begin = mid + 1;
                continue;
            }
            if (d > 0) {
                end = mid - 1;
                continue;
            }
            return mid;
        }
        return -(begin + 1);
    }

    private int binarySearchCategoryMatch(E[] array, int begin, int end, E element) {
        --end;
        while (begin <= end) {
            int mid = begin + end >>> 1;
            int d = this.comparator().compareElement(array[mid], element);
            if (d < 0) {
                begin = mid + 1;
                continue;
            }
            if (d > 0) {
                end = mid - 1;
                continue;
            }
            return mid;
        }
        return -(begin + 1);
    }

    public SortedListSet<E> subList(C category) {
        int size;
        if (category == null) {
            throw new NullPointerException("category");
        }
        Object[] array = this.array();
        int start = this.binarySearchCategory(array, 0, (size = this.size()) - 1, category);
        if (start < 0) {
            start = -(start + 1);
            return new CategorySubList(category, start, 0);
        }
        int end = start + 1;
        while (start > 0) {
            if (this.comparator().compareCategory(this.comparator().getCategory(array[start - 1]), category) != 0) break;
            --start;
        }
        while (end < size) {
            if (this.comparator().compareCategory(this.comparator().getCategory(array[end]), category) != 0) break;
            ++end;
        }
        return new CategorySubList(category, start, end - start);
    }

    protected class CategorySubList
    extends SortedArraySet.SubList {
        protected final C category;

        public CategorySubList(C category, int offset, int size) {
            super((SortedArraySet)CategoryElementList.this, offset, size);
            this.category = category;
        }

        protected int superIndexOfE(E element) {
            CategoryElementList.this.checkType(element);
            this.checkModification();
            if (CategoryElementList.this.comparator().compareCategory(this.category, ((CategoryElementComparator)CategoryElementList.this.comparator).getCategory(element)) != 0) {
                return -1;
            }
            return CategoryElementList.this.binarySearchCategoryMatch(CategoryElementList.this.array(), this.offset(), this.offset() + this.size(), element);
        }

        protected int superIndexOfEChecked(E element) {
            if (element == null) {
                throw new NullPointerException("element");
            }
            if (CategoryElementList.this.comparator().compareCategory(this.category, ((CategoryElementComparator)CategoryElementList.this.comparator).getCategory(element)) != 0) {
                throw new IllegalArgumentException("Element.category != SubList.category");
            }
            this.checkModification();
            return CategoryElementList.this.binarySearchCategoryMatch(CategoryElementList.this.array(), this.offset(), this.offset() + this.size(), element);
        }
    }
}

