/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.statet.ecommons.io.internal.EFSUtilImpl;
import org.eclipse.statet.ecommons.io.internal.WorkspaceUtilImpl;

public abstract class FileUtil {
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16_BE = "UTF-16BE";
    public static final String UTF_16_LE = "UTF-16LE";
    public static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};

    public static IFileStore getLocalFileStore(String s) throws CoreException {
        return FileUtil.getLocalFileStore(s, null);
    }

    public static IFileStore getLocalFileStore(String s, IFileStore relativeParent) throws CoreException {
        if (s.length() > 0) {
            URI uri;
            IFileSystem localFS = EFS.getLocalFileSystem();
            if (s.startsWith("file")) {
                try {
                    return localFS.getStore(new URI(s).normalize());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                }
            }
            IPath path = Path.fromOSString((String)s);
            if (path.isUNC() && (uri = URIUtil.toURI((IPath)path)) != null) {
                return localFS.getStore(uri);
            }
            if (path.isAbsolute()) {
                URI uri2;
                String device = path.getDevice();
                if ((device == null || device.length() <= 2) && (uri2 = URIUtil.toURI((String)s)) != null) {
                    return localFS.getStore(uri2);
                }
            } else if (relativeParent != null && path.getDevice() == null) {
                return relativeParent.getFileStore(path);
            }
        } else if (relativeParent != null) {
            return relativeParent;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No local filesystem resource."));
    }

    public static IFileStore getLocalFileStore(String s, IContainer relativeParent) throws CoreException {
        if (s.length() > 0) {
            URI uri;
            IFileSystem localFS = EFS.getLocalFileSystem();
            if (s.startsWith("file")) {
                try {
                    return localFS.getStore(new URI(s).normalize());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                }
            }
            IPath path = Path.fromOSString((String)s);
            if (path.isUNC() && (uri = URIUtil.toURI((IPath)path)) != null) {
                return localFS.getStore(uri);
            }
            if (path.isAbsolute()) {
                URI uri2;
                String device = path.getDevice();
                if ((device == null || device.length() <= 2) && (uri2 = URIUtil.toURI((String)s)) != null) {
                    return localFS.getStore(uri2);
                }
            } else if (relativeParent != null && path.getDevice() == null) {
                return EFS.getStore((URI)relativeParent.getFile(path).getLocationURI().normalize());
            }
        } else if (relativeParent != null) {
            return EFS.getStore((URI)relativeParent.getLocationURI().normalize());
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No local filesystem resource."));
    }

    public static IFileStore getFileStore(String location) throws CoreException {
        return FileUtil.getFileStore(location, null);
    }

    public static IFileStore getFileStore(String location, IFileStore relativeParent) throws CoreException {
        try {
            return FileUtil.getLocalFileStore(location, relativeParent);
        }
        catch (CoreException coreException) {
            int p = location.indexOf(58);
            if (p > 1) {
                try {
                    URI uri = new URI(location);
                    if (uri.getScheme() != null) {
                        return EFS.getStore((URI)uri);
                    }
                }
                catch (URISyntaxException e) {
                    try {
                        new URI(location.substring(0, p), "a", null);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No supported filesystem resource."));
        }
    }

    public static String toString(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        if (fileStore.getFileSystem().getScheme().equals("file")) {
            return fileStore.toString();
        }
        return fileStore.toURI().toString();
    }

    public static IFileStore expandToLocalFileStore(String location, IFileStore parent, String child) throws CoreException {
        IStringVariableManager variables = VariablesPlugin.getDefault().getStringVariableManager();
        String expanded = variables.performStringSubstitution(location);
        IFileStore localFileStore = FileUtil.getLocalFileStore(expanded, parent);
        if (child != null) {
            return localFileStore.getChild(child);
        }
        return localFileStore;
    }

    public static IFile getAsWorkspaceFile(URI uri) {
        IFile file;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = URIUtil.toPath((URI)uri);
        if (path != null && (file = root.getFileForLocation(path = path.makeAbsolute())) != null) {
            return file;
        }
        IFile[] files = root.findFilesForLocationURI(uri);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static void prepareTextOutput(OutputStream outputStream, String encoding) throws IOException {
        byte[] prefix;
        if (encoding == null) {
            return;
        }
        if (encoding.equals(UTF_8)) {
            prefix = BOM_UTF_8;
        } else if (encoding.equals(UTF_16_BE)) {
            prefix = BOM_UTF_16BE;
        } else if (encoding.equals(UTF_16_LE)) {
            prefix = BOM_UTF_16LE;
        } else {
            return;
        }
        int i = 0;
        while (i < prefix.length) {
            outputStream.write(prefix[i]);
            ++i;
        }
    }

    public static FileUtil getFileUtil(Object file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file instanceof IFile) {
            return new WorkspaceUtilImpl((IFile)file);
        }
        if (file instanceof IFileStore) {
            IFileStore efsFile = (IFileStore)file;
            IFile iFile = FileUtil.getAsWorkspaceFile(efsFile.toURI());
            if (iFile != null) {
                return new WorkspaceUtilImpl(iFile);
            }
            return new EFSUtilImpl(efsFile);
        }
        throw new IllegalArgumentException("Unknown file object: " + file.getClass());
    }

    protected static void saveClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract long getTimeStamp(IProgressMonitor var1) throws CoreException;

    public abstract String getLabel();

    public abstract URI getURI();

    public abstract ReadTextFileOperation createReadTextFileOp(ReaderAction var1);

    public abstract WriteTextFileOperation createWriteTextFileOp(String var1);

    public static abstract class AbstractFileOperation {
        protected int fMode = 0;
        protected String fCharset = "UTF-8";
        protected boolean fForceCharset = false;

        protected AbstractFileOperation() {
        }

        public void setFileOperationMode(int mode) {
            this.fMode = mode;
        }

        public void setCharset(String charset, boolean forceCharset) {
            this.fCharset = charset;
            this.fForceCharset = forceCharset;
        }

        public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            this.runInEnv(monitor);
        }

        protected abstract void runInEnv(IProgressMonitor var1) throws CoreException, OperationCanceledException;

        protected void runAsWorkspaceRunnable(IProgressMonitor monitor, ISchedulingRule rule) throws CoreException, OperationCanceledException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable workspaceRunner = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    this.runInEnv(monitor);
                }
            };
            workspace.run(workspaceRunner, rule, 1, monitor);
        }
    }

    protected static class FileInput
    implements Closeable {
        private String fEncoding;
        private String fDefaultEncoding;
        private InputStream fStream;

        public FileInput(InputStream input, String expliciteCharsetHint) throws IOException, CoreException {
            this.fStream = input;
            if (expliciteCharsetHint != null) {
                if (expliciteCharsetHint.equals(FileUtil.UTF_8) || expliciteCharsetHint.equals(FileUtil.UTF_16_BE) || expliciteCharsetHint.equals(FileUtil.UTF_16_LE)) {
                    this.read(input);
                }
                this.fDefaultEncoding = expliciteCharsetHint;
            } else {
                this.read(input);
            }
            this.fEncoding = this.fDefaultEncoding != null ? this.fDefaultEncoding : FileUtil.UTF_8;
        }

        void read(InputStream input) throws IOException {
            try {
                int n = 3;
                byte[] bytes = new byte[3];
                int readed = input.read(bytes, 0, 3);
                if (readed == 0) {
                    return;
                }
                int next = 0;
                if (this.startsWith(bytes, BOM_UTF_8)) {
                    next = BOM_UTF_8.length;
                    this.fDefaultEncoding = FileUtil.UTF_8;
                } else if (this.startsWith(bytes, BOM_UTF_16BE)) {
                    next = BOM_UTF_16BE.length;
                    this.fDefaultEncoding = FileUtil.UTF_16_BE;
                } else if (this.startsWith(bytes, BOM_UTF_16LE)) {
                    next = BOM_UTF_16LE.length;
                    this.fDefaultEncoding = FileUtil.UTF_16_LE;
                }
                if (readed - next > 0) {
                    this.fStream = new SequenceInputStream(new ByteArrayInputStream(bytes, next, readed - next), input);
                }
            }
            catch (IOException e) {
                FileUtil.saveClose(input);
                throw e;
            }
        }

        private boolean startsWith(byte[] array, byte[] start) {
            int i = 0;
            while (i < start.length) {
                if (array[i] != start[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void setEncoding(String encoding, boolean force) {
            if (encoding == null && this.fDefaultEncoding != null) {
                this.fEncoding = this.fDefaultEncoding;
            }
            if (force || this.fDefaultEncoding == null) {
                this.fEncoding = encoding;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.fStream != null) {
                this.fStream.close();
            }
        }

        public String getDefaultCharset() {
            return this.fDefaultEncoding;
        }

        public Reader getReader() throws UnsupportedEncodingException {
            return new InputStreamReader(this.fStream, this.fEncoding);
        }
    }

    public abstract class ReadTextFileOperation
    extends AbstractFileOperation {
        protected abstract FileInput getInput(IProgressMonitor var1) throws CoreException, IOException;

        protected abstract ReaderAction getAction();

        @Override
        protected void runInEnv(IProgressMonitor monitor) throws CoreException {
            FileInput fi = null;
            BufferedReader reader = null;
            try {
                try {
                    monitor.beginTask(null, 100);
                    String fileLabel = FileUtil.this.getLabel();
                    monitor.subTask("Opening " + fileLabel + "...");
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    fi = this.getInput((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    fi.setEncoding(this.fCharset, this.fForceCharset);
                    reader = new BufferedReader(fi.getReader());
                    monitor.worked(5);
                    monitor.subTask("Reading " + fileLabel + "...");
                    this.getAction().run(reader, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "The selected charset is unsupported on your system.", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "Error while reading the file.", (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                FileUtil.saveClose(reader);
                FileUtil.saveClose(fi);
                monitor.done();
                throw throwable;
            }
            FileUtil.saveClose(reader);
            FileUtil.saveClose(fi);
            monitor.done();
        }
    }

    public static interface ReaderAction {
        public void run(BufferedReader var1, IProgressMonitor var2) throws IOException, CoreException;
    }

    public abstract class WriteTextFileOperation
    extends AbstractFileOperation {
        protected WriteTextFileOperation() {
        }

        protected abstract void writeImpl(IProgressMonitor var1) throws CoreException, UnsupportedEncodingException, IOException;

        @Override
        protected void runInEnv(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            try {
                try {
                    monitor.beginTask("Writing to " + FileUtil.this.getLabel(), 100);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.writeImpl(monitor);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "The selected charset is unsupported on your system.", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "Error while writing to file.", (Throwable)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

