/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.core.LaunchConfiguration;

public class OverlayLaunchConfiguration
extends LaunchConfiguration {
    private final ILaunchConfiguration launchConfiguration;
    private final Map<String, Object> additionalAttributes;

    public OverlayLaunchConfiguration(ILaunchConfiguration orginal, Map<String, Object> additional) {
        super(orginal.getName(), null);
        this.launchConfiguration = orginal;
        this.additionalAttributes = additional;
    }

    public ILaunchConfiguration getOriginal() {
        return this.launchConfiguration;
    }

    public boolean contentsEqual(ILaunchConfiguration configuration) {
        return this.launchConfiguration.contentsEqual(configuration);
    }

    public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
        return this.launchConfiguration.copy(name);
    }

    public void delete() throws CoreException {
        this.launchConfiguration.delete();
    }

    public boolean exists() {
        return this.launchConfiguration.exists();
    }

    public boolean hasAttribute(String attributeName) throws CoreException {
        if (this.additionalAttributes.containsKey(attributeName)) {
            return true;
        }
        return this.launchConfiguration.hasAttribute(attributeName);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public List getAttribute(String attributeName, List defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof List) {
            return (List)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public Set getAttribute(String attributeName, Set defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof Set) {
            return (Set)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public Map getAttribute(String attributeName, Map defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public String getAttribute(String attributeName, String defaultValue) throws CoreException {
        Object obj = this.additionalAttributes.get(attributeName);
        if (obj instanceof String) {
            return (String)obj;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public Map getAttributes() throws CoreException {
        return this.launchConfiguration.getAttributes();
    }

    public String getCategory() throws CoreException {
        return this.launchConfiguration.getCategory();
    }

    public IFile getFile() {
        return this.launchConfiguration.getFile();
    }

    @Deprecated
    public IPath getLocation() {
        return this.launchConfiguration.getLocation();
    }

    public IFileStore getFileStore() throws CoreException {
        if (this.launchConfiguration instanceof LaunchConfiguration) {
            return ((LaunchConfiguration)this.launchConfiguration).getFileStore();
        }
        return super.getFileStore();
    }

    public IResource[] getMappedResources() throws CoreException {
        return this.launchConfiguration.getMappedResources();
    }

    public String getMemento() throws CoreException {
        return this.launchConfiguration.getMemento();
    }

    public Set getModes() throws CoreException {
        return this.launchConfiguration.getModes();
    }

    public String getName() {
        return this.launchConfiguration.getName();
    }

    public ILaunchDelegate getPreferredDelegate(Set modes) throws CoreException {
        return this.launchConfiguration.getPreferredDelegate(modes);
    }

    public ILaunchConfigurationType getType() throws CoreException {
        return this.launchConfiguration.getType();
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return this.launchConfiguration.getWorkingCopy();
    }

    public boolean isLocal() {
        return this.launchConfiguration.isLocal();
    }

    public boolean isMigrationCandidate() throws CoreException {
        return this.launchConfiguration.isMigrationCandidate();
    }

    public boolean isReadOnly() {
        return this.launchConfiguration.isReadOnly();
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void migrate() throws CoreException {
        this.launchConfiguration.migrate();
    }

    public boolean supportsMode(String mode) throws CoreException {
        return this.launchConfiguration.supportsMode(mode);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return (T)this.launchConfiguration.getAdapter(adapterType);
    }
}

